/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.integration.github.persistence.XdGitLabChangesProcessor;
import jetbrains.youtrack.integration.github.persistence.XdVcsHostingChangesProcessor;
import jetbrains.youtrack.integration.persistence.XdNoUserReason;
import jetbrains.youtrack.integration.persistence.XdVcsChange;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.vcs.dtos.GitLabChangeDTO;
import jetbrains.youtrack.integration.vcs.rest.VcsRestClient;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabCommit;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabHookPayload;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabProjectInsidePayload;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabRepository;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabRestV4;
import jetbrains.youtrack.integration.vcs.service.VcsHostingService;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="gitLabService")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0004H\u0014J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/integration/vcs/service/GitLabService;", "Ljetbrains/youtrack/integration/vcs/service/VcsHostingService;", "Ljetbrains/youtrack/integration/github/persistence/XdGitLabChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/rest/gitlab/GitLabHookPayload;", "Ljetbrains/youtrack/integration/vcs/rest/gitlab/GitLabCommit;", "()V", "integrationType", "", "getIntegrationType", "()Ljava/lang/String;", "createDto", "Ljetbrains/youtrack/integration/vcs/dtos/GitLabChangeDTO;", "commit", "processor", "userResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "getBranch", "payload", "getCommits", "", "getRepositoryPath", "getRest", "Ljetbrains/youtrack/integration/vcs/rest/VcsRestClient;", "changesProcessor", "getVersion", "resolveUser", "toDto", "vcsChange", "Ljetbrains/youtrack/integration/persistence/XdVcsChange;", "youtrack-github-integration"})
public final class GitLabService
extends VcsHostingService<XdGitLabChangesProcessor, GitLabHookPayload, GitLabCommit> {
    @NotNull
    private final String integrationType = "GitLab";

    @NotNull
    public String getIntegrationType() {
        return this.integrationType;
    }

    @Override
    @NotNull
    protected String getBranch(@NotNull GitLabHookPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String string = payload.getRef();
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected String getRepositoryPath(@NotNull GitLabHookPayload payload, @NotNull XdGitLabChangesProcessor processor2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        if (payload.getRepository() == null && payload.getProject() == null) {
            processor2.logError("Repository is not set in GitLab payload for project: " + payload.getProjectId() + " , ref: " + payload.getRef());
            string = null;
        } else if (payload.getProject() != null) {
            GitLabProjectInsidePayload gitLabProjectInsidePayload = payload.getProject();
            string = gitLabProjectInsidePayload != null ? gitLabProjectInsidePayload.getPathWithNamespace() : null;
        } else {
            List pathSegments;
            List list2;
            Object object = payload.getRepository();
            if (object != null && (object = ((GitLabRepository)object).getHomepage()) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null)) != null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)object;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    CharSequence charSequence = it;
                    if (!(charSequence.length() > 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = pathSegments = CollectionsKt.emptyList();
            }
            if (pathSegments.size() < 2) {
                GitLabRepository gitLabRepository = payload.getRepository();
                processor2.logError("Repository homepage path is too short: " + (gitLabRepository != null ? gitLabRepository.getHomepage() : null));
                string = null;
            } else {
                string = (String)pathSegments.get(pathSegments.size() - 2) + "/" + (String)pathSegments.get(pathSegments.size() - 1);
            }
        }
        return string;
    }

    @Override
    @NotNull
    protected List<GitLabCommit> getCommits(@NotNull GitLabHookPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        List list2 = payload.getCommits();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    protected GitLabChangeDTO createDto(@NotNull GitLabCommit commit, @NotNull XdGitLabChangesProcessor processor2, @NotNull UserResolution userResolution) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)userResolution, (String)"userResolution");
        XdUser xdUser = userResolution.getUser();
        XdNoUserReason xdNoUserReason = userResolution.getNoUserReason();
        return new GitLabChangeDTO(null, (Entity)(xdUser != null ? xdUser.getEntity() : null), (Entity)(xdNoUserReason != null ? xdNoUserReason.getEntity() : null), commit, processor2.getEntity());
    }

    @NotNull
    public GitLabChangeDTO toDto(@NotNull XdVcsChange vcsChange) {
        GitLabChangeDTO gitLabChangeDTO;
        Intrinsics.checkParameterIsNotNull((Object)vcsChange, (String)"vcsChange");
        GitLabChangeDTO $receiver = gitLabChangeDTO = new GitLabChangeDTO();
        boolean bl = false;
        this.tweakChangeDto(vcsChange, $receiver);
        $receiver.id = vcsChange.getVersion();
        return gitLabChangeDTO;
    }

    @Override
    @NotNull
    protected String getVersion(@NotNull GitLabCommit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        return commit.getId();
    }

    @Override
    @NotNull
    public UserResolution resolveUser(@NotNull XdGitLabChangesProcessor processor2, @NotNull GitLabCommit commit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        String authorName = commit.getAuthorName();
        String authorEmail = commit.getAuthorEmail();
        return authorName == null ? new UserResolution(null, null, XdNoUserReason.Companion.getGITLAB_NO_USER_INFO_PROVIDED()) : (authorEmail == null ? new UserResolution(null, authorName, XdNoUserReason.Companion.getGITLAB_NO_EMAIL()) : this.resolveUser((XdVcsHostingChangesProcessor)processor2, authorName, authorEmail, XdNoUserReason.Companion.getGITLAB_NO_USER_FOUND_IN_YOUTRACK(), XdNoUserReason.Companion.getGITLAB_USER_NOT_UNIQUE(), XdNoUserReason.Companion.getVCS_NOT_IN_COMMITTERS_GROUP()));
    }

    @Override
    @NotNull
    protected VcsRestClient<XdGitLabChangesProcessor> getRest(@NotNull XdGitLabChangesProcessor changesProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        return new GitLabRestV4(changesProcessor.getServer().getUrl(), changesProcessor.getServer().getSslKey());
    }
}

