/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.integration.github.persistence.CredentialsDto;
import jetbrains.youtrack.integration.github.persistence.XdVcsHostingChangesProcessor;
import jetbrains.youtrack.integration.github.persistence.XdVcsHostingServer;
import jetbrains.youtrack.integration.misc.BranchSpec;
import jetbrains.youtrack.integration.persistence.XdNoUserReason;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.persistence.XdVcsServer;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.service.VcsService;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.rest.VcsRestClient;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0000*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H$\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ)\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0015\u001a\u00028\u00002\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0015\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010)J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00020+2\u0006\u0010%\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010,J\u0015\u0010-\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010.\u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010/J\u001b\u00100\u001a\b\u0012\u0004\u0012\u00028\u0000012\u0006\u0010\u0015\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010&J\u001d\u00104\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u00105\u001a\u00020\t\u00a2\u0006\u0002\u00106J\u0013\u00107\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u001b\u00108\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u0001\u00a2\u0006\u0002\u00109J%\u0010:\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u00012\u0006\u0010;\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010<J\u001d\u0010=\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010>J?\u0010=\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00028\u00002\b\u0010?\u001a\u0004\u0018\u00010\t2\u0006\u0010@\u001a\u00020\t2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\u0006\u0010D\u001a\u00020BH\u0004\u00a2\u0006\u0002\u0010EJ%\u0010F\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010G\u001a\u00020H\u00a2\u0006\u0002\u0010IJ'\u0010J\u001a\u00020\u0014*\u00028\u00002\f\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00020+2\u0006\u0010;\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010LR\u0018\u0010\b\u001a\u00020\t*\u00028\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006M"}, d2={"Ljetbrains/youtrack/integration/vcs/service/VcsHostingService;", "P", "Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;", "O", "", "C", "Ljetbrains/youtrack/integration/service/VcsService;", "()V", "oneLineBrachSpec", "", "getOneLineBrachSpec", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;)Ljava/lang/String;", "createDto", "Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "commit", "processor", "userResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "(Ljava/lang/Object;Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljetbrains/youtrack/integration/service/UserResolution;)Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "createHook", "", "changesProcessor", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;)V", "deleteHook", "creds", "Ljetbrains/youtrack/integration/github/persistence/CredentialsDto;", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljetbrains/youtrack/integration/github/persistence/CredentialsDto;)V", "filterOutIrrelevant", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/persistent/XdUser;", "users", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Lkotlinx/dnq/query/XdQuery;)Lkotlinx/dnq/query/XdQuery;", "findCommittersGroup", "Ljetbrains/youtrack/persistent/XdUserGroup;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "getBranch", "payload", "(Ljava/lang/Object;)Ljava/lang/String;", "getCommit", "hash", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljava/lang/String;)Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "getCommits", "", "(Ljava/lang/Object;)Ljava/util/List;", "getLogPrefix", "getRepositoryPath", "(Ljava/lang/Object;Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;)Ljava/lang/String;", "getRest", "Ljetbrains/youtrack/integration/vcs/rest/VcsRestClient;", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;)Ljetbrains/youtrack/integration/vcs/rest/VcsRestClient;", "getVersion", "matchesBranchSpec", "branchName", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljava/lang/String;)Ljava/lang/String;", "ping", "process", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljava/lang/Object;)V", "processTruncatedPayload", "branch", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljava/lang/Object;Ljava/lang/String;)V", "resolveUser", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljava/lang/Object;)Ljetbrains/youtrack/integration/service/UserResolution;", "authorName", "authorEmail", "noUserError", "Ljetbrains/youtrack/integration/persistence/XdNoUserReason;", "multiUserError", "notACommiterError", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljava/lang/String;Ljava/lang/String;Ljetbrains/youtrack/integration/persistence/XdNoUserReason;Ljetbrains/youtrack/integration/persistence/XdNoUserReason;Ljetbrains/youtrack/integration/persistence/XdNoUserReason;)Ljetbrains/youtrack/integration/service/UserResolution;", "toDto", "enforceCommitersGroup", "", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljava/lang/Object;Z)Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "logBranchDoesNotMatch", "commits", "(Ljetbrains/youtrack/integration/github/persistence/XdVcsHostingChangesProcessor;Ljava/util/List;Ljava/lang/String;)V", "youtrack-github-integration"})
public abstract class VcsHostingService<P extends XdVcsHostingChangesProcessor, O, C>
extends VcsService<P> {
    @Nullable
    public CommonChangeDTO getCommit(@NotNull P changesProcessor, @NotNull String hash) {
        Intrinsics.checkParameterIsNotNull(changesProcessor, (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        return this.getRest(changesProcessor).getCommit((XdVcsChangeProcessor)changesProcessor, hash);
    }

    public final void createHook(@NotNull P changesProcessor) {
        Intrinsics.checkParameterIsNotNull(changesProcessor, (String)"changesProcessor");
        Object object = ((XdVcsHostingChangesProcessor)((Object)changesProcessor)).getApiKey();
        if (object == null || (object = object.getKey()) == null) {
            throw (Throwable)new IllegalArgumentException("Repo's API key has no value");
        }
        Object key = object;
        changesProcessor.logInfo("Creating hook");
        ((XdVcsHostingChangesProcessor)((Object)changesProcessor)).setHookId(this.getRest(changesProcessor).createHook((XdVcsChangeProcessor)changesProcessor, (String)key));
    }

    public final void deleteHook(@NotNull P changesProcessor, @NotNull CredentialsDto creds) {
        Intrinsics.checkParameterIsNotNull(changesProcessor, (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        changesProcessor.logInfo("Deleting hook");
        try {
            this.getRest(changesProcessor).deleteHook((XdVcsChangeProcessor)changesProcessor, creds);
        }
        catch (Exception e) {
            this.logException((XdVcsChangeProcessor)changesProcessor, e, "Failed to delete hook", false, false);
        }
    }

    public final void ping(@NotNull P changesProcessor) {
        Intrinsics.checkParameterIsNotNull(changesProcessor, (String)"changesProcessor");
        this.getRest(changesProcessor).ping((XdVcsChangeProcessor)changesProcessor);
    }

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull P processor2, @NotNull O payload) {
        void finished;
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull(payload, (String)"payload");
        String repoPathFromPayload = this.getRepositoryPath(payload, processor2);
        if (!StringsKt.equals((String)((XdVcsHostingChangesProcessor)((Object)processor2)).getPath(), (String)repoPathFromPayload, (boolean)true)) {
            processor2.logError("Processor is not set to process changes from repository " + repoPathFromPayload);
            return;
        }
        String branch = this.getBranch(payload);
        String logicalBranch = this.matchesBranchSpec(processor2, branch);
        List<C> commits = this.getCommits(payload);
        if (logicalBranch == null) {
            this.logBranchDoesNotMatch(processor2, commits, branch);
            return;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        processor2.process((Function1)new Function1<XdVcsChangeProcessor, List<? extends CommonChangeDTO>>(this, (Ref.BooleanRef)finished, commits, processor2, logicalBranch){
            final /* synthetic */ VcsHostingService this$0;
            final /* synthetic */ Ref.BooleanRef $finished;
            final /* synthetic */ List $commits;
            final /* synthetic */ XdVcsHostingChangesProcessor $processor;
            final /* synthetic */ String $logicalBranch;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<CommonChangeDTO> invoke(@NotNull XdVcsChangeProcessor p) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
                if (this.$finished.element) {
                    return CollectionsKt.emptyList();
                }
                Iterable $receiver$iv = this.$commits;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                Iterator<T> iterator = $receiver$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    T item$iv$iv;
                    T t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    CommonChangeDTO commonChangeDTO = this.this$0.toDto(this.$processor, it, true);
                    collection.add(commonChangeDTO);
                }
                List dtos = CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
                $receiver$iv = dtos;
                for (E element$iv : $receiver$iv) {
                    CommonChangeDTO it = (CommonChangeDTO)element$iv;
                    boolean bl = false;
                    it.branch = this.$logicalBranch;
                }
                this.$finished.element = true;
                return dtos;
            }
            {
                this.this$0 = vcsHostingService;
                this.$finished = booleanRef;
                this.$commits = list2;
                this.$processor = xdVcsHostingChangesProcessor;
                this.$logicalBranch = string;
                super(1);
            }
        });
        this.processTruncatedPayload(processor2, payload, branch);
    }

    public void processTruncatedPayload(@NotNull P processor2, @NotNull O payload, @NotNull String branch) {
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull(payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
    }

    @Nullable
    public final CommonChangeDTO toDto(@NotNull P processor2, @NotNull C commit, boolean enforceCommitersGroup) {
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull(commit, (String)"commit");
        UserResolution ur = this.resolveUser(processor2, commit);
        XdUser user = ur.getUser();
        if (user == null) {
            processor2.logDebug("Could not find YouTrack user for " + ur.getVcsUser() + " when processing " + this.getVersion(commit));
        } else if (enforceCommitersGroup && Intrinsics.areEqual((Object)ur.getNoUserReason(), (Object)XdNoUserReason.Companion.getVCS_NOT_IN_COMMITTERS_GROUP())) {
            processor2.logInfo("Skipping commit " + this.getVersion(commit) + " by vcs user " + ur.getVcsUser() + " (YouTrack user " + user.getLogin() + ')' + " since they do not belong to the committers group");
            return null;
        }
        return this.createDto(commit, processor2, ur);
    }

    @Nullable
    public final String matchesBranchSpec(@NotNull P processor2, @NotNull String branchName) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        String branchSpec = ((XdVcsHostingChangesProcessor)((Object)processor2)).getBranch();
        if (branchSpec == null || (charSequence = (CharSequence)branchSpec).length() == 0) {
            return branchName;
        }
        return BranchSpec.INSTANCE.match(branchSpec, branchName);
    }

    @NotNull
    protected XdQuery<XdUser> filterOutIrrelevant(@NotNull P changesProcessor, @NotNull XdQuery<? extends XdUser> users) {
        Intrinsics.checkParameterIsNotNull(changesProcessor, (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull(users, (String)"users");
        return ((XdVcsHostingChangesProcessor)((Object)changesProcessor)).getCommitters().getAllUsersGroup() ? users : XdQueryKt.intersect((XdQuery)((XdVcsHostingChangesProcessor)((Object)changesProcessor)).getCommitters().getAggregatedUsers(), users);
    }

    @NotNull
    public final XdUserGroup findCommittersGroup(@Nullable XdProject project) {
        XdUserGroup xdUserGroup;
        Iterable assigneeGroups;
        XdProject xdProject = project;
        Iterable iterable = assigneeGroups = jetbrains.charisma.service.BeansKt.getUserFields().getAssigneeGroups((Entity)(xdProject != null ? xdProject.getEntity() : null));
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"assigneeGroups");
        if (CollectionUtilKt.getSize((Iterable)iterable) == 1) {
            Object object = CollectionsKt.first((Iterable)assigneeGroups);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"assigneeGroups.first()");
            xdUserGroup = (XdUserGroup)XdExtensionsKt.toXd((Entity)((Entity)object));
        } else {
            xdUserGroup = BeansKt.getXdAllUsersGroup();
        }
        return xdUserGroup;
    }

    @NotNull
    protected abstract String getBranch(@NotNull O var1);

    @Nullable
    protected abstract String getRepositoryPath(@NotNull O var1, @NotNull P var2);

    @NotNull
    protected abstract List<C> getCommits(@NotNull O var1);

    @NotNull
    protected abstract CommonChangeDTO createDto(@NotNull C var1, @NotNull P var2, @NotNull UserResolution var3);

    @NotNull
    protected abstract String getVersion(@NotNull C var1);

    @NotNull
    public abstract UserResolution resolveUser(@NotNull P var1, @NotNull C var2);

    @NotNull
    protected final UserResolution resolveUser(@NotNull P processor2, @Nullable String authorName, @NotNull String authorEmail, @NotNull XdNoUserReason noUserError, @NotNull XdNoUserReason multiUserError, @NotNull XdNoUserReason notACommiterError) {
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)authorEmail, (String)"authorEmail");
        Intrinsics.checkParameterIsNotNull((Object)noUserError, (String)"noUserError");
        Intrinsics.checkParameterIsNotNull((Object)multiUserError, (String)"multiUserError");
        Intrinsics.checkParameterIsNotNull((Object)notACommiterError, (String)"notACommiterError");
        UserResolution userResolution = this.resolveUser((XdVcsChangeProcessor)processor2, authorEmail, noUserError, multiUserError, notACommiterError);
        XdUser xdUser = userResolution.getUser();
        String string = authorName;
        if (string == null) {
            string = authorEmail;
        }
        return new UserResolution(xdUser, string, userResolution.getNoUserReason());
    }

    @NotNull
    public String getLogPrefix(@NotNull P changesProcessor) {
        String string;
        Intrinsics.checkParameterIsNotNull(changesProcessor, (String)"changesProcessor");
        String it = string = this.getOneLineBrachSpec(changesProcessor);
        boolean bl = false;
        CharSequence charSequence = it;
        String branchSpec = charSequence.length() > 0 ? "" : " (branch spec: " + it + ')';
        XdVcsServer xdVcsServer = changesProcessor.getServer();
        if (xdVcsServer == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.integration.github.persistence.XdVcsHostingServer");
        }
        return '[' + ((XdVcsHostingServer)xdVcsServer).getIntegrationType() + " Integration " + changesProcessor.getProject().getShortName() + "<-" + ((XdVcsHostingChangesProcessor)((Object)changesProcessor)).getPath() + branchSpec + "]: ";
    }

    private final void logBranchDoesNotMatch(@NotNull P $receiver, List<? extends C> commits, String branch) {
        boolean multiple = commits.size() > 1;
        $receiver.logInfo("Skipped commit" + (multiple ? "s " : " ") + ' ' + CollectionsKt.joinToString$default((Iterable)commits, (CharSequence)",", null, null, (int)0, null, (Function1)new Function1<C, String>(this){
            final /* synthetic */ VcsHostingService this$0;

            @NotNull
            public final String invoke(@NotNull C it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.this$0.getVersion(it);
            }
            {
                this.this$0 = vcsHostingService;
                super(1);
            }
        }, (int)30, null) + " since " + (multiple ? "their" : "its") + " branch (" + branch + ") does not match the spec " + this.getOneLineBrachSpec($receiver));
    }

    private final String getOneLineBrachSpec(@NotNull P $receiver) {
        CharSequence charSequence = ((XdVcsHostingChangesProcessor)((Object)$receiver)).getBranch();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return "";
        }
        String string = ((XdVcsHostingChangesProcessor)((Object)$receiver)).getBranch();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.replace$default((String)string, (String)"\n", (String)"|", (boolean)false, (int)4, null);
    }

    @NotNull
    protected abstract VcsRestClient<P> getRest(@NotNull P var1);
}

