/*
 * Decompiled with CFR 0.152.
 */
package com.github.penemue.keap;

import com.github.penemue.keap.PriorityQueue;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 K*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001KB\u0017\b\u0016\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006B)\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tB\u0015\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\nB#\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u0005J\u001d\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u001eH\u0002J\u0015\u0010*\u001a\u00020\f2\u0006\u0010'\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020&H\u0016J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.H\u0096\u0002J\u0018\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\fH\u0002J\u0017\u00102\u001a\u00020&2\b\u00103\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u000f\u00104\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00105J\u000f\u00106\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00105J\r\u00107\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u00105J\u0010\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\fH\u0002J\u0010\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\fH\u0002J\u0010\u0010<\u001a\u00020\f2\u0006\u00109\u001a\u00020\fH\u0002J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020?H\u0002J\u0015\u0010@\u001a\u00020&2\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u0017\u0010A\u001a\u0004\u0018\u00018\u00002\u0006\u0010B\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010CJ\u0017\u0010D\u001a\u0004\u0018\u00018\u00002\u0006\u0010B\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010CJ\u0010\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020\fH\u0002J\u0010\u0010G\u001a\u00020\f2\u0006\u0010B\u001a\u00020\fH\u0002J\u0010\u0010H\u001a\u00020\u001e2\u0006\u0010I\u001a\u00020JH\u0002R\u0014\u0010\u000b\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0004\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0017X\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u001a\u0012\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006L"}, d2={"Lcom/github/penemue/keap/PriorityQueue;", "T", "Ljava/util/AbstractQueue;", "Ljava/io/Serializable;", "cmp", "Ljava/util/Comparator;", "(Ljava/util/Comparator;)V", "c", "", "(Ljava/util/Collection;Ljava/util/Comparator;)V", "(Lcom/github/penemue/keap/PriorityQueue;)V", "capacity", "", "(ILjava/util/Comparator;)V", "getCapacity$keap", "()I", "count", "heap", "", "heapSize", "modCount", "nextFree", "queue", "", "queue$annotations", "()V", "[Ljava/lang/Object;", "size", "getSize", "allocHeap", "", "compactIfNecessary", "comparator", "compareValues", "value1", "value2", "(Ljava/lang/Object;Ljava/lang/Object;)I", "contains", "", "element", "(Ljava/lang/Object;)Z", "heapify", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "min", "i1", "i2", "offer", "e", "peek", "()Ljava/lang/Object;", "poll", "pollRaw", "queueLeftChild", "parent", "queueParent", "child", "queueRightChild", "readObject", "input", "Ljava/io/ObjectInputStream;", "remove", "removeAt", "i", "(I)Ljava/lang/Object;", "removeAtEven", "siftUp", "index", "swapNeighboursAt", "writeObject", "output", "Ljava/io/ObjectOutputStream;", "Companion", "keap"})
public class PriorityQueue<T>
extends AbstractQueue<T>
implements Serializable {
    private int count;
    private transient int nextFree;
    private transient int modCount;
    private transient T[] queue;
    private transient int[] heap;
    private transient int heapSize;
    private final Comparator<? super T> cmp;
    private static final long serialVersionUID = 2808197179219145169L;
    private static final int NIL = -1;
    public static final int MIN_CAPACITY = 4;
    public static final Companion Companion = new Companion(null);

    private static /* synthetic */ void queue$annotations() {
    }

    @Nullable
    public final Comparator<? super T> comparator() {
        return this.cmp;
    }

    @Override
    @Nullable
    public T peek() {
        return this.isEmpty() ? null : (T)this.queue[this.heap[0]];
    }

    @Override
    @Nullable
    public T poll() {
        T t;
        T t2 = this.pollRaw();
        if (t2 != null) {
            T t3;
            T $receiver = t3 = t2;
            this.compactIfNecessary();
            t = t3;
        } else {
            t = null;
        }
        return t;
    }

    @Nullable
    public final T pollRaw() {
        return this.isEmpty() ? null : (T)this.removeAtEven(this.heap[0]);
    }

    @Override
    public boolean offer(@Nullable T e) {
        if (e == null) {
            throw (Throwable)new NullPointerException();
        }
        int i = this.nextFree;
        if (PriorityQueue.Companion.isOdd(i)) {
            T t = this.queue[i - 1];
            if (t == null) {
                throw (Throwable)new NullPointerException();
            }
            T neighbour = t;
            if (this.compareValues(e, neighbour) >= 0) {
                this.queue[i] = e;
            } else {
                this.queue[i - 1] = e;
                this.queue[i] = neighbour;
                this.siftUp(i - 1);
            }
        } else {
            if (i == this.queue.length) {
                Object[] q = this.queue;
                int newCapacity = Math.max(i, PriorityQueue.Companion.getToCapacity((this.count + 1) * 4 / 3));
                if (newCapacity > i) {
                    this.allocHeap(newCapacity);
                }
                int j = 0;
                if (q != this.queue) {
                    Object[] $receiver$iv;
                    for (T t : $receiver$iv = q) {
                        T t2;
                        T it = t;
                        if (it == null) continue;
                        T $receiver = t2;
                        int n = j;
                        j = n + 1;
                        this.queue[n] = $receiver;
                    }
                } else {
                    Object[] $receiver$iv;
                    for (T t : $receiver$iv = q) {
                        T t3;
                        T it = t;
                        if (it == null) continue;
                        T $receiver = t3;
                        int n = j;
                        j = n + 1;
                        q[n] = $receiver;
                    }
                    ArraysKt.fill((Object[])q, null, (int)j, (int)i);
                }
                this.nextFree = j;
                this.heapify();
                return this.offer(e);
            }
            this.queue[i] = e;
            this.siftUp(i);
        }
        this.nextFree = i + 1;
        PriorityQueue priorityQueue = this;
        ++priorityQueue.count;
        int cfr_ignored_0 = priorityQueue.count;
        PriorityQueue priorityQueue2 = this;
        ++priorityQueue2.modCount;
        int cfr_ignored_1 = priorityQueue2.modCount;
        return true;
    }

    public int getSize() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public final int getCapacity$keap() {
        return this.queue.length;
    }

    @Override
    public boolean remove(Object element) {
        int i = this.indexOf(element);
        if (i < 0) {
            return false;
        }
        this.removeAt(i);
        return true;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) >= 0;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private int expectedModCount;
            @Nullable
            private T next;
            private int cursor;
            final /* synthetic */ PriorityQueue this$0;

            public final int getExpectedModCount() {
                return this.expectedModCount;
            }

            public final void setExpectedModCount(int n) {
                this.expectedModCount = n;
            }

            @Nullable
            public final T getNext() {
                return this.next;
            }

            public final void setNext(@Nullable T t) {
                this.next = t;
            }

            public final int getCursor() {
                return this.cursor;
            }

            public final void setCursor(int n) {
                this.cursor = n;
            }

            public void remove() {
                this.checkUnmodified();
                int i = this.cursor;
                PriorityQueue.access$removeAt(this.this$0, i);
                if (com.github.penemue.keap.PriorityQueue$Companion.access$isEven$p(PriorityQueue.Companion, i)) {
                    iterator.1 v0 = this;
                    v0.cursor += -1;
                    int cfr_ignored_0 = v0.cursor;
                }
                this.expectedModCount = PriorityQueue.access$getModCount$p(this.this$0);
            }

            public T next() {
                T t;
                block3: {
                    block2: {
                        T t2;
                        this.hasNext();
                        t = this.next;
                        if (t == null) break block2;
                        T $receiver = t2 = t;
                        this.next = null;
                        t = t2;
                        if (t != null) break block3;
                    }
                    throw (Throwable)new NullPointerException();
                }
                return t;
            }

            public boolean hasNext() {
                this.checkUnmodified();
                int i = this.cursor;
                while (this.next == null && ++i != PriorityQueue.access$getQueue$p(this.this$0).length) {
                    this.next = PriorityQueue.access$getQueue$p(this.this$0)[i];
                }
                this.cursor = i;
                return this.next != null;
            }

            private final void checkUnmodified() {
                if (this.expectedModCount != PriorityQueue.access$getModCount$p(this.this$0)) {
                    throw (Throwable)new ConcurrentModificationException();
                }
            }
            {
                this.this$0 = $outer;
                this.expectedModCount = PriorityQueue.access$getModCount$p($outer);
                this.cursor = -1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final int indexOf(T element) {
        int n;
        block2: {
            T[] $receiver$iv = this.queue;
            int n2 = 0;
            int n3 = $receiver$iv.length;
            while (n2 < n3) {
                void index$iv;
                T it = $receiver$iv[index$iv];
                if (it != null && Intrinsics.areEqual(it, element)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private final void heapify() {
        int j;
        ArraysKt.fill$default((int[])this.heap, (int)-1, (int)0, (int)0, (int)6, null);
        int i = this.heapSize;
        int n = i / 2;
        int n2 = i;
        while (n < n2) {
            int min;
            int minRight;
            int minLeft = this.queueLeftChild(j);
            if (this.min(minLeft, minLeft + 1) == minLeft + 1) {
                this.swapNeighboursAt(minLeft);
            }
            if (this.min(minRight = this.queueRightChild(j), minRight + 1) == minRight + 1) {
                this.swapNeighboursAt(minRight);
            }
            if ((min = this.min(minLeft, minRight)) == -1) break;
            this.heap[j] = min;
            ++j;
        }
        while (i > 1) {
            int min;
            n2 = i;
            for (j = (i /= 2) / 2; j < n2 && (min = this.min(this.heap[PriorityQueue.Companion.getLeftChild(j)], this.heap[PriorityQueue.Companion.getRightChild(j)])) != -1; ++j) {
                this.heap[j] = min;
            }
        }
    }

    private final void siftUp(int index) {
        int i = this.queueParent(index);
        this.heap[i] = this.min(this.queueLeftChild(i), this.queueRightChild(i));
        while (i > 0) {
            int min = this.min(this.heap[PriorityQueue.Companion.getLeftChild(i = PriorityQueue.Companion.getParent(i))], this.heap[PriorityQueue.Companion.getRightChild(i)]);
            if (min == this.heap[i]) {
                if (min != index) break;
                continue;
            }
            this.heap[i] = min;
        }
    }

    private final void compactIfNecessary() {
        if (this.count > 0 && this.count < this.queue.length / 3) {
            T[] oldQueue = this.queue;
            this.allocHeap(this.count);
            int j = 0;
            int n = this.nextFree;
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                T t;
                int it = i;
                if (oldQueue[it] == null) continue;
                T $receiver = t;
                int n3 = j;
                j = n3 + 1;
                this.queue[n3] = $receiver;
            }
            this.nextFree = j;
            this.heapify();
        }
    }

    private final T removeAt(int i) {
        T t;
        T result;
        if (PriorityQueue.Companion.isEven(i)) {
            return this.removeAtEven(i);
        }
        T t2 = result = this.queue[i];
        if (t2 != null) {
            T t3;
            T $receiver = t3 = t2;
            this.queue[i] = null;
            if (i == this.nextFree - 1) {
                PriorityQueue priorityQueue = this;
                priorityQueue.nextFree += -1;
                int cfr_ignored_0 = priorityQueue.nextFree;
            }
            PriorityQueue priorityQueue = this;
            priorityQueue.count += -1;
            int cfr_ignored_1 = priorityQueue.count;
            PriorityQueue priorityQueue2 = this;
            ++priorityQueue2.modCount;
            int cfr_ignored_2 = priorityQueue2.modCount;
            t = t3;
        } else {
            t = null;
        }
        return t;
    }

    private final T removeAtEven(int i) {
        T t;
        T result;
        T t2 = result = this.queue[i];
        if (t2 != null) {
            T t3;
            T $receiver = t3 = t2;
            this.queue[i] = this.queue[i + 1];
            this.queue[i + 1] = null;
            this.siftUp(i);
            if (i == this.nextFree - 1) {
                int j;
                for (j = i; j > 0 && this.queue[j - 1] == null; --j) {
                }
                this.nextFree = j;
            }
            PriorityQueue priorityQueue = this;
            priorityQueue.count += -1;
            int cfr_ignored_0 = priorityQueue.count;
            PriorityQueue priorityQueue2 = this;
            ++priorityQueue2.modCount;
            int cfr_ignored_1 = priorityQueue2.modCount;
            t = t3;
        } else {
            t = null;
        }
        return t;
    }

    private final int swapNeighboursAt(int i) {
        T temp = this.queue[i];
        this.queue[i] = this.queue[i + 1];
        this.queue[i + 1] = temp;
        return i;
    }

    private final void allocHeap(int capacity) {
        int adjustedCapacity = PriorityQueue.Companion.getToCapacity(capacity);
        if (this.queue != null && adjustedCapacity == this.queue.length) {
            throw (Throwable)new IllegalArgumentException("Allocating keap of the same size as existing");
        }
        this.queue = new Object[adjustedCapacity];
        this.heap = new int[this.queue.length / 2 - 1];
        this.heapSize = this.heap.length;
    }

    private final int queueLeftChild(int parent) {
        return (PriorityQueue.Companion.getLeftChild(parent) - this.heapSize) * 2;
    }

    private final int queueRightChild(int parent) {
        return (PriorityQueue.Companion.getRightChild(parent) - this.heapSize) * 2;
    }

    private final int queueParent(int child) {
        return PriorityQueue.Companion.getParent(child / 2 + this.heapSize);
    }

    private final int min(int i1, int i2) {
        if (i2 == -1) {
            return i1;
        }
        if (i1 == -1) {
            return i2;
        }
        T value1 = this.queue[i1];
        T value2 = this.queue[i2];
        if (value1 == null && value2 == null) {
            return -1;
        }
        if (value2 == null) {
            return i1;
        }
        if (value1 == null) {
            return i2;
        }
        return this.compareValues(value1, value2) <= 0 ? i1 : i2;
    }

    private final int compareValues(T value1, T value2) {
        int n;
        Comparator<T> comparator = this.cmp;
        if (comparator != null) {
            n = comparator.compare(value1, value2);
        } else {
            T t = value1;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Comparable<T>");
            }
            n = ((Comparable)t).compareTo(value2);
        }
        return n;
    }

    private final void writeObject(ObjectOutputStream output) {
        output.defaultWriteObject();
        PriorityQueue $receiver$iv = this;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            output.writeObject(it);
        }
    }

    private final void readObject(ObjectInputStream input) {
        input.defaultReadObject();
        this.allocHeap(this.count);
        int n = this.count;
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            if (input.readObject() != null) continue;
            T cfr_ignored_0 = this.queue[it];
            throw (Throwable)new NullPointerException();
        }
        this.heapify();
        this.nextFree = this.count;
    }

    public PriorityQueue(int capacity, @Nullable Comparator<? super T> cmp) {
        this.cmp = cmp;
        this.queue = new Object[PriorityQueue.Companion.getToCapacity(capacity)];
        int[] nArray = new int[this.queue.length / 2 - 1];
        PriorityQueue priorityQueue = this;
        int[] $receiver = nArray;
        ArraysKt.fill$default((int[])$receiver, (int)-1, (int)0, (int)0, (int)6, null);
        int[] nArray2 = nArray;
        priorityQueue.heap = nArray2;
        this.heapSize = this.heap.length;
    }

    public /* synthetic */ PriorityQueue(int n, Comparator comparator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        if ((n2 & 2) != 0) {
            comparator = null;
        }
        this(n, comparator);
    }

    public PriorityQueue() {
        this(0, null, 3, null);
    }

    public PriorityQueue(@NotNull Comparator<? super T> cmp) {
        Intrinsics.checkParameterIsNotNull(cmp, (String)"cmp");
        this(4, cmp);
    }

    public PriorityQueue(@NotNull Collection<? extends T> c, @Nullable Comparator<? super T> cmp) {
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        this(c.size(), cmp);
        this.count = c.size();
        Iterable $receiver$iv = c;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            int n = this.nextFree;
            this.nextFree = n + 1;
            if (it != null) continue;
            T cfr_ignored_0 = this.queue[n];
            throw (Throwable)new NullPointerException();
        }
    }

    public /* synthetic */ PriorityQueue(Collection collection, Comparator comparator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            comparator = null;
        }
        this(collection, comparator);
    }

    public PriorityQueue(@NotNull PriorityQueue<T> c) {
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        this(c.queue.length, c.cmp);
        this.count = c.count;
        this.nextFree = c.nextFree;
        PriorityQueue.Companion.copyFrom(this.queue, c.queue);
        PriorityQueue.Companion.copyFrom(this.heap, c.heap);
    }

    @Nullable
    public static final /* synthetic */ Object access$removeAt(PriorityQueue $this, int i) {
        return $this.removeAt(i);
    }

    public static final /* synthetic */ int access$getModCount$p(PriorityQueue $this) {
        return $this.modCount;
    }

    public static final /* synthetic */ void access$setModCount$p(PriorityQueue $this, int n) {
        $this.modCount = n;
    }

    @NotNull
    public static final /* synthetic */ Object[] access$getQueue$p(PriorityQueue $this) {
        return $this.queue;
    }

    public static final /* synthetic */ void access$setQueue$p(PriorityQueue $this, @NotNull Object[] objectArray) {
        $this.queue = objectArray;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0018H\u0082\u0004\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u0015\u001a\u00020\u0016*\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u001bH\u0082\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\t*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0018\u0010\u000b\u001a\u00020\t*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0018\u0010\f\u001a\u00020\u0004*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0004*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0018\u0010\u0011\u001a\u00020\u0004*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0018\u0010\u0013\u001a\u00020\u0004*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/github/penemue/keap/PriorityQueue$Companion;", "", "()V", "MIN_CAPACITY", "", "NIL", "serialVersionUID", "", "isEven", "", "(I)Z", "isOdd", "leftChild", "getLeftChild", "(I)I", "parent", "getParent", "rightChild", "getRightChild", "toCapacity", "getToCapacity", "copyFrom", "", "E", "", "src", "([Ljava/lang/Object;[Ljava/lang/Object;)V", "", "keap"})
    public static final class Companion {
        private final int getToCapacity(int $receiver) {
            if ($receiver < 1) {
                throw (Throwable)new IllegalArgumentException();
            }
            int result = Integer.highestOneBit(2 * $receiver - 1);
            return result < 4 ? 4 : result;
        }

        private final int getLeftChild(int $receiver) {
            return $receiver * 2 + 1;
        }

        private final int getRightChild(int $receiver) {
            return $receiver * 2 + 2;
        }

        private final int getParent(int $receiver) {
            return ($receiver - 1) / 2;
        }

        private final boolean isOdd(int $receiver) {
            return ($receiver & 1) == 1;
        }

        private final boolean isEven(int $receiver) {
            return ($receiver & 1) == 0;
        }

        private final <E> void copyFrom(@NotNull E[] $receiver, E[] src) {
            System.arraycopy(src, 0, $receiver, 0, src.length);
        }

        private final void copyFrom(@NotNull int[] $receiver, int[] src) {
            System.arraycopy(src, 0, $receiver, 0, src.length);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

