/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth.interactive;

import jetbrains.jetpass.oauth2.server.AuthError;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\b\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\t\u001a\u00020\u0007J\n\u0010\n\u001a\u00060\u0004j\u0002`\u0005J\n\u0010\u000b\u001a\u00060\u0004j\u0002`\u0005J\n\u0010\f\u001a\u00060\u0004j\u0002`\u0005J\n\u0010\r\u001a\u00060\u0004j\u0002`\u0005J\n\u0010\u000e\u001a\u00060\u0004j\u0002`\u0005J\n\u0010\u000f\u001a\u00060\u0004j\u0002`\u0005J\u0014\u0010\u0010\u001a\u00060\u0004j\u0002`\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\u0011\u001a\u00060\u0004j\u0002`\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\n\u0010\u0013\u001a\u00060\u0004j\u0002`\u0005J\n\u0010\u0014\u001a\u00060\u0004j\u0002`\u0005J\u001a\u0010\u0015\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u001a\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u001b\u001a\u00020\u0007J\u0012\u0010\u001c\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u001d\u001a\u00020\u0007J\u0012\u0010\u001e\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u001f\u001a\u00020\u0007J\n\u0010 \u001a\u00060\u0004j\u0002`\u0005\u00a8\u0006!"}, d2={"Ljetbrains/jetpass/oauth/interactive/AuthErrors;", "", "()V", "authFailed", "Ljetbrains/jetpass/oauth2/server/AuthError;", "Ljetbrains/jetpass/oauth/interactive/OAuthError;", "message", "", "authUnsupported", "moduleName", "cantRestoreFederatedState", "emailVerificationFailed", "emptyPassword", "emptyUsername", "guestDisabled", "inviteCodeInvalid", "licenseRestriction", "reCaptchaVerificationFailed", "errorCode", "registrationDisabled", "restorePasswordCodeInvalid", "twoFactorAuthenticationFailuresNumberExceeded", "login", "maxAttempts", "", "twoFactorAuthenticationFailuresNumberExceededForAdmin", "twoFactorAuthenticationInvalidCode", "code", "twoFactorAuthenticationInvalidSession", "session", "unresolvedAuthProvider", "moduleId", "verifiedEmailHasChanged", "jetbrains.jetpass.oauth.interactive"})
public final class AuthErrors {
    public static final AuthErrors INSTANCE;

    @NotNull
    public final AuthError cantRestoreFederatedState() {
        return new AuthError("hub-auth-federated-cant-restore-state", null, null, null, 14, null);
    }

    @NotNull
    public final AuthError unresolvedAuthProvider(@NotNull String moduleId) {
        Intrinsics.checkParameterIsNotNull((Object)moduleId, (String)"moduleId");
        return new AuthError("hub-auth-federated-unresolved-provider", "Unknown federated authentication module (like Google or GitHub) with ID " + moduleId + '.', null, null, 12, null);
    }

    @NotNull
    public final AuthError authUnsupported(@NotNull String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        return new AuthError("hub-auth-federated-auth-unsupported", moduleName + " doesn't support federated authentication", null, null, 12, null);
    }

    @NotNull
    public final AuthError guestDisabled() {
        return new AuthError("hub-auth-guest-disabled", null, null, null, 14, null);
    }

    @NotNull
    public final AuthError licenseRestriction(@Nullable String message) {
        return new AuthError("hub-auth-license", message, null, null, 12, null);
    }

    @NotNull
    public final AuthError registrationDisabled() {
        return new AuthError("hub-auth-registration-disabled", null, null, null, 14, null);
    }

    @NotNull
    public final AuthError emptyUsername() {
        return new AuthError("hub-auth-empty-username", null, null, null, 14, null);
    }

    @NotNull
    public final AuthError emptyPassword() {
        return new AuthError("hub-auth-empty-password", null, null, null, 14, null);
    }

    @NotNull
    public final AuthError authFailed(@Nullable String message) {
        return new AuthError("hub-auth-failed", message, null, null, 12, null);
    }

    @NotNull
    public final AuthError emailVerificationFailed() {
        return new AuthError("hub-auth-email-verification-failed", null, null, null, 14, null);
    }

    @NotNull
    public final AuthError verifiedEmailHasChanged() {
        return new AuthError("hub-auth-email-verification-changed", null, null, null, 14, null);
    }

    @NotNull
    public final AuthError reCaptchaVerificationFailed(@Nullable String errorCode) {
        String string = errorCode;
        if (string == null) {
            string = "hub-auth-recaptcha-failed";
        }
        return new AuthError(string, "ReCAPTCHA validation failed with error \"" + errorCode + '\"', null, null, 12, null);
    }

    @NotNull
    public final AuthError twoFactorAuthenticationInvalidSession(@NotNull String session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new AuthError("hub-auth-2fa-invalid-session", "Two-factor authentication session was not found", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"session", (Object)session)), 4, null);
    }

    @NotNull
    public final AuthError twoFactorAuthenticationInvalidCode(@NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        return new AuthError("hub-auth-2fa-invalid-code", "Two-factor authentication code \"" + code + "\" is invalid", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"code", (Object)code)), 4, null);
    }

    @NotNull
    public final AuthError twoFactorAuthenticationFailuresNumberExceeded(@NotNull String login2, int maxAttempts) {
        Intrinsics.checkParameterIsNotNull((Object)login2, (String)"login");
        return new AuthError("hub-auth-2fa-failure-attempts-exceeded", "Invalid two-factor authentication code was entered more than " + maxAttempts + " times for user " + login2, null, MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"maxAttempts", (Object)String.valueOf(maxAttempts)), TuplesKt.to((Object)"login", (Object)login2)}), 4, null);
    }

    @NotNull
    public final AuthError twoFactorAuthenticationFailuresNumberExceededForAdmin(int maxAttempts) {
        return new AuthError("hub-auth-2fa-admin-failure-attempts-exceeded", "Invalid two-factor authentication code was entered more than " + maxAttempts + " times for user the admin user", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"maxAttempts", (Object)String.valueOf(maxAttempts))), 4, null);
    }

    @NotNull
    public final AuthError inviteCodeInvalid() {
        return new AuthError("hub-auth-invite-code-invalid", "The registration invite code is invalid. You may have already used it to set your password. Try to log in with your current credentials.", null, null, 12, null);
    }

    @NotNull
    public final AuthError restorePasswordCodeInvalid() {
        return new AuthError("hub-auth-restore-password-code-invalid", "The password restore code is invalid. You may have already used it to reset your password. Try to log in with your current credentials.", null, null, 12, null);
    }

    private AuthErrors() {
    }

    static {
        AuthErrors authErrors;
        INSTANCE = authErrors = new AuthErrors();
    }
}

