/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth.interactive;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthUrl;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo$approvalURL$1;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo$emailVerificationURL$1;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo$inviteURL$1;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo$login$1;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo$registerURL$1;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo$restore$1;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfoKt;
import jetbrains.jetpass.oauth.interactive.KotlinUriBuilderExtentsionsKt;
import jetbrains.jetpass.oauth.interactive.Oauth2InteractiveResource;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import jetbrains.jetpass.oauth2.server.Oauth2Resource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tH\u0016J\u0010\u0010.\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tH\u0016J\u0010\u0010/\u001a\n 0*\u0004\u0018\u00010\u000f0\u000fH\u0002J\u001c\u00101\u001a\n 0*\u0004\u0018\u00010\u000f0\u000f2\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0002J\u001c\u00104\u001a\n 0*\u0004\u0018\u00010\u000f0\u000f2\n\u00105\u001a\u0006\u0012\u0002\b\u000306H\u0002J\u0010\u00107\u001a\n 0*\u0004\u0018\u00010\u000f0\u000fH\u0002J\u001c\u00108\u001a\u00020\u00002\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0016J%\u0010:\u001a\u00020\t*\u00020\u000f2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020<0;\"\u00020<H\u0002\u00a2\u0006\u0002\u0010=R\u0014\u0010\u000b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u0014\u0010\u001e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\rR\u0014\u0010$\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\rR\u0014\u0010&\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\rR\u0014\u0010(\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\rR\u0014\u0010*\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\r\u00a8\u0006>"}, d2={"Ljetbrains/jetpass/oauth/interactive/AuthUrlInfo;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthUrl;", "info", "Ljavax/ws/rs/core/UriInfo;", "request", "Ljavax/servlet/http/HttpServletRequest;", "(Ljavax/ws/rs/core/UriInfo;Ljavax/servlet/http/HttpServletRequest;)V", "paramsMap", "", "", "(Ljavax/ws/rs/core/UriInfo;Ljava/util/Map;)V", "approvalURL", "getApprovalURL", "()Ljava/lang/String;", "builder", "Ljavax/ws/rs/core/UriBuilder;", "getBuilder", "()Ljavax/ws/rs/core/UriBuilder;", "certificateLoginURL", "getCertificateLoginURL", "emailVerificationURL", "getEmailVerificationURL", "frontEndLoginURL", "getFrontEndLoginURL", "guestLoginURL", "getGuestLoginURL", "getInfo", "()Ljavax/ws/rs/core/UriInfo;", "inviteURL", "getInviteURL", "oAuth2AuthEndpoint", "getOAuth2AuthEndpoint", "getParamsMap", "()Ljava/util/Map;", "passwordLoginURL", "getPasswordLoginURL", "passwordRestoreCodeURL", "getPasswordRestoreCodeURL", "passwordRestoreURL", "getPasswordRestoreURL", "registerURL", "getRegisterURL", "twoFactorAuthenticationURL", "getTwoFactorAuthenticationURL", "getFederatedReturnURL", "moduleId", "getFederatedStartURL", "login", "kotlin.jvm.PlatformType", "oauth2", "kMethod", "Lkotlin/reflect/KFunction;", "oauth2Interactive", "property", "Lkotlin/reflect/KProperty;", "restore", "withParameters", "params", "addParamsAndBuild", "", "", "(Ljavax/ws/rs/core/UriBuilder;[Ljava/lang/Object;)Ljava/lang/String;", "jetbrains.jetpass.oauth.interactive"})
public class AuthUrlInfo
implements AuthUrl {
    @NotNull
    private final UriInfo info;
    @NotNull
    private final Map<String, String> paramsMap;

    @NotNull
    public String getOAuth2AuthEndpoint() {
        UriBuilder uriBuilder = this.oauth2((KFunction<?>)oAuth2AuthEndpoint.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"oauth2(Oauth2Resource::auth)");
        return this.addParamsAndBuild(uriBuilder, new Object[0]);
    }

    @NotNull
    public AuthUrlInfo withParameters(@NotNull Map<String, String> params) {
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        return new AuthUrlInfo(this.info, params);
    }

    @NotNull
    public String getFederatedStartURL(@NotNull String moduleId) {
        Intrinsics.checkParameterIsNotNull((Object)moduleId, (String)"moduleId");
        UriBuilder uriBuilder = this.login();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"login()");
        UriBuilder uriBuilder2 = KotlinUriBuilderExtentsionsKt.path(uriBuilder, getFederatedStartURL.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder2, (String)"login().path(LoginSubresource::startFederated)");
        return this.addParamsAndBuild(uriBuilder2, moduleId);
    }

    @NotNull
    public String getFederatedReturnURL(@NotNull String moduleId) {
        Intrinsics.checkParameterIsNotNull((Object)moduleId, (String)"moduleId");
        UriBuilder uriBuilder = this.login();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"login()");
        String string = KotlinUriBuilderExtentsionsKt.path(uriBuilder, getFederatedReturnURL.1.INSTANCE).build(new Object[]{moduleId}).toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"login().path(LoginSubres\u2026moduleId).toASCIIString()");
        return string;
    }

    @NotNull
    public UriBuilder getBuilder() {
        UriBuilder uriBuilder = this.info.getBaseUriBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"info.baseUriBuilder");
        return uriBuilder;
    }

    @NotNull
    public String getGuestLoginURL() {
        UriBuilder uriBuilder = this.login();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"login()");
        UriBuilder uriBuilder2 = KotlinUriBuilderExtentsionsKt.path(uriBuilder, guestLoginURL.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder2, (String)"login().path(LoginSubresource::getGuest)");
        return this.addParamsAndBuild(uriBuilder2, new Object[0]);
    }

    @NotNull
    public String getPasswordLoginURL() {
        UriBuilder uriBuilder = this.login();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"login()");
        return this.addParamsAndBuild(uriBuilder, new Object[0]);
    }

    @NotNull
    public String getTwoFactorAuthenticationURL() {
        UriBuilder uriBuilder = this.login();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"login()");
        UriBuilder uriBuilder2 = KotlinUriBuilderExtentsionsKt.path(uriBuilder, twoFactorAuthenticationURL.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder2, (String)"login().path(LoginSubres\u2026:twoFactorAuthentication)");
        return this.addParamsAndBuild(uriBuilder2, new Object[0]);
    }

    @NotNull
    public String getApprovalURL() {
        String string = this.oauth2Interactive((KProperty)AuthUrlInfo$approvalURL$1.INSTANCE).build(new Object[0]).toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oauth2Interactive(Oauth2\u2026).build().toASCIIString()");
        return string;
    }

    private final UriBuilder login() {
        return this.oauth2Interactive((KProperty)AuthUrlInfo$login$1.INSTANCE);
    }

    @NotNull
    public String getRegisterURL() {
        UriBuilder uriBuilder = this.oauth2Interactive((KProperty)AuthUrlInfo$registerURL$1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"oauth2Interactive(Oauth2\u2026activeResource::register)");
        return this.addParamsAndBuild(uriBuilder, new Object[0]);
    }

    @NotNull
    public String getEmailVerificationURL() {
        UriBuilder uriBuilder = this.oauth2Interactive((KProperty)AuthUrlInfo$emailVerificationURL$1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"oauth2Interactive(Oauth2\u2026iveResource::verifyEmail)");
        return this.addParamsAndBuild(uriBuilder, new Object[0]);
    }

    @NotNull
    public String getPasswordRestoreURL() {
        UriBuilder uriBuilder = this.restore();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"restore()");
        return this.addParamsAndBuild(uriBuilder, new Object[0]);
    }

    @NotNull
    public String getPasswordRestoreCodeURL() {
        UriBuilder uriBuilder = this.restore();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"restore()");
        UriBuilder uriBuilder2 = KotlinUriBuilderExtentsionsKt.path(uriBuilder, passwordRestoreCodeURL.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder2, (String)"restore().path(RestorePa\u2026bresource::resetPassword)");
        return this.addParamsAndBuild(uriBuilder2, new Object[0]);
    }

    private final UriBuilder restore() {
        return this.oauth2Interactive((KProperty)AuthUrlInfo$restore$1.INSTANCE);
    }

    @NotNull
    public String getInviteURL() {
        UriBuilder uriBuilder = this.oauth2Interactive((KProperty)AuthUrlInfo$inviteURL$1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"oauth2Interactive(Oauth2\u2026eractiveResource::invite)");
        return this.addParamsAndBuild(uriBuilder, new Object[0]);
    }

    @NotNull
    public String getCertificateLoginURL() {
        UriBuilder uriBuilder = this.login();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"login()");
        UriBuilder uriBuilder2 = KotlinUriBuilderExtentsionsKt.path(uriBuilder, certificateLoginURL.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder2, (String)"login().path(LoginSubresource::certificateLogin)");
        return this.addParamsAndBuild(uriBuilder2, new Object[0]);
    }

    @NotNull
    public String getFrontEndLoginURL() {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)AuthUrlInfoKt.access$getUrlProvider$p().getLoginUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"UriBuilder.fromUri(urlProvider.loginUrl)");
        return this.addParamsAndBuild(uriBuilder, new Object[0]);
    }

    private final String addParamsAndBuild(@NotNull UriBuilder $receiver, Object ... params) {
        String string = KotlinUriBuilderExtentsionsKt.queryMatrixParam($receiver, this.paramsMap).build(Arrays.copyOf(params, params.length)).toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.queryMatrixParam(pa\u2026(*params).toASCIIString()");
        return string;
    }

    private final UriBuilder oauth2Interactive(KProperty<?> property) {
        UriBuilder uriBuilder = this.info.getBaseUriBuilder().path(Oauth2InteractiveResource.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"info.baseUriBuilder.path\u2026tiveResource::class.java)");
        return KotlinUriBuilderExtentsionsKt.path(uriBuilder, Reflection.getOrCreateKotlinClass(Oauth2InteractiveResource.class), property);
    }

    private final UriBuilder oauth2(KFunction<?> kMethod) {
        UriBuilder uriBuilder = this.info.getBaseUriBuilder().path(Oauth2Resource.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"info.baseUriBuilder.path\u2026uth2Resource::class.java)");
        return KotlinUriBuilderExtentsionsKt.path(uriBuilder, Reflection.getOrCreateKotlinClass(Oauth2Resource.class), kMethod);
    }

    @NotNull
    public final UriInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final Map<String, String> getParamsMap() {
        return this.paramsMap;
    }

    public AuthUrlInfo(@NotNull UriInfo info, @NotNull Map<String, String> paramsMap) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull(paramsMap, (String)"paramsMap");
        this.info = info;
        this.paramsMap = paramsMap;
    }

    public AuthUrlInfo(@Context @NotNull UriInfo info, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        this(info, OAuthUtilKt.getAuthParameters((HttpServletRequest)request));
    }
}

