/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth.interactive;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.api.authority.module.Credentials;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthUrl;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationHandler;
import jetbrains.jetpass.auth.module.dnq.authentication.FederatedAuthenticationHandler;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.State;
import jetbrains.jetpass.core.store.OneTimeStore;
import jetbrains.jetpass.oauth.interactive.AuthErrors;
import jetbrains.jetpass.oauth.interactive.AuthenticateUtilKt;
import jetbrains.jetpass.oauth.interactive.FederatedAuthenticationUtil;
import jetbrains.jetpass.oauth.interactive.GodMode;
import jetbrains.jetpass.oauth.interactive.LoginActions;
import jetbrains.jetpass.oauth2.server.AuthError;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J.\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014JJ\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u001c\u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u000b0\u00192\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000b0\u001dH\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Ljetbrains/jetpass/oauth/interactive/FederatedAuthenticationUtil;", "", "()V", "authStateStore", "Ljetbrains/jetpass/core/store/OneTimeStore;", "Ljetbrains/jetpass/auth/module/dnq/authentication/State;", "getAuthStateStore", "()Ljetbrains/jetpass/core/store/OneTimeStore;", "authStateStore$delegate", "Lkotlin/properties/ReadOnlyProperty;", "landFederatedAuthentication", "Ljavax/ws/rs/core/Response;", "moduleID", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "authUrl", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthUrl;", "startFederatedAuthentication", "rememberMe", "", "proxy", "withFederatedAuthenticationHandler", "action", "fn", "Lkotlin/Function2;", "Ljetbrains/jetpass/userManagement/persistence/dnq/module/XdAuthModule;", "Ljetbrains/jetpass/auth/module/dnq/authentication/FederatedAuthenticationHandler;", "handleError", "Lkotlin/Function1;", "Ljetbrains/jetpass/oauth2/server/AuthError;", "jetbrains.jetpass.oauth.interactive"})
public final class FederatedAuthenticationUtil {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private static final ReadOnlyProperty authStateStore$delegate;
    public static final FederatedAuthenticationUtil INSTANCE;

    static {
        FederatedAuthenticationUtil federatedAuthenticationUtil;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FederatedAuthenticationUtil.class), "authStateStore", "getAuthStateStore()Ljetbrains/jetpass/core/store/OneTimeStore;"))};
        INSTANCE = federatedAuthenticationUtil = new FederatedAuthenticationUtil();
        String name$iv = null;
        authStateStore$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public final OneTimeStore<State> getAuthStateStore() {
        return (OneTimeStore)authStateStore$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final Response startFederatedAuthentication(@NotNull String moduleID, @NotNull HttpServletRequest request, @NotNull AuthUrl authUrl, boolean rememberMe, boolean proxy) {
        Intrinsics.checkParameterIsNotNull((Object)moduleID, (String)"moduleID");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Map authParameters = OAuthUtilKt.getAuthParameters((HttpServletRequest)request);
        return this.withFederatedAuthenticationHandler(moduleID, "Federated auth start for module [" + moduleID + ']', (Function2)new Function2<XdAuthModule, FederatedAuthenticationHandler<?>, Response>(authUrl, authParameters, rememberMe, proxy, request){
            final /* synthetic */ AuthUrl $authUrl;
            final /* synthetic */ Map $authParameters;
            final /* synthetic */ boolean $rememberMe;
            final /* synthetic */ boolean $proxy;
            final /* synthetic */ HttpServletRequest $request;

            @NotNull
            public final Response invoke(@NotNull XdAuthModule $noName_0, @NotNull FederatedAuthenticationHandler<?> authenticationHandler) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull(authenticationHandler, (String)"authenticationHandler");
                URI landingUri = authenticationHandler.getReturnUri(this.$authUrl);
                State state2 = new State(this.$authParameters, this.$rememberMe, landingUri, this.$proxy);
                String stateId = FederatedAuthenticationUtil.INSTANCE.getAuthStateStore().put((Object)state2);
                return authenticationHandler.start(this.$request, state2, stateId, this.$authUrl);
            }
            {
                this.$authUrl = authUrl;
                this.$authParameters = map;
                this.$rememberMe = bl;
                this.$proxy = bl2;
                this.$request = httpServletRequest;
                super(2);
            }
        }, (Function1<? super AuthError, ? extends Response>)((Function1)new Function1<AuthError, Response>(authParameters){
            final /* synthetic */ Map $authParameters;

            @NotNull
            public final Response invoke(@NotNull AuthError error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                return AuthenticateUtilKt.loginFailed(error, this.$authParameters);
            }
            {
                this.$authParameters = map;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Response landFederatedAuthentication(@NotNull String moduleID, @NotNull HttpServletRequest request, @NotNull AuthUrl authUrl) {
        void actionState;
        Intrinsics.checkParameterIsNotNull((Object)moduleID, (String)"moduleID");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Function1 handleError2 = (Function1)new Function1<AuthError, Response>((Ref.ObjectRef)actionState){
            final /* synthetic */ Ref.ObjectRef $actionState;

            @NotNull
            public final Response invoke(@NotNull AuthError error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                State state2 = (State)this.$actionState.element;
                return state2 != null && !state2.isProxied() ? AuthenticateUtilKt.loginFailed(error, state2.getAuthParameters()) : AuthenticateUtilKt.fatal(error);
            }
            {
                this.$actionState = objectRef;
                super(1);
            }
        };
        return this.withFederatedAuthenticationHandler(moduleID, "Federated auth land for module [" + moduleID + ']', (Function2)new Function2<XdAuthModule, FederatedAuthenticationHandler<?>, Response>(request, authUrl, (Ref.ObjectRef)actionState){
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ AuthUrl $authUrl;
            final /* synthetic */ Ref.ObjectRef $actionState;

            @NotNull
            public final Response invoke(@NotNull XdAuthModule setting, @NotNull FederatedAuthenticationHandler<?> authenticationHandler) {
                Response response;
                Intrinsics.checkParameterIsNotNull((Object)setting, (String)"setting");
                Intrinsics.checkParameterIsNotNull(authenticationHandler, (String)"authenticationHandler");
                State state2 = authenticationHandler.restoreState(this.$request, this.$authUrl, (Function1)landFederatedAuthentication.state.1.INSTANCE);
                this.$actionState.element = state2;
                if (state2 == null) {
                    response = AuthenticateUtilKt.fatal(AuthErrors.INSTANCE.cantRestoreFederatedState());
                } else {
                    Response response2;
                    ServletRequestCredentials credentials = new ServletRequestCredentials(setting.getEntity(), this.$request, state2, this.$authUrl);
                    Map authParameters = state2.getAuthParameters();
                    try {
                        response2 = LoginActions.INSTANCE.login((Credentials)credentials, this.$authUrl.withParameters(authParameters), authParameters, state2.isRememberMe());
                    }
                    catch (ExecutionException ex) {
                        Throwable throwable = ex.getCause();
                        if (throwable == null) {
                            throwable = ex;
                        }
                        throw throwable;
                    }
                    response = response2;
                }
                return response;
            }
            {
                this.$request = httpServletRequest;
                this.$authUrl = authUrl;
                this.$actionState = objectRef;
                super(2);
            }
        }, (Function1<? super AuthError, ? extends Response>)handleError2);
    }

    private final Response withFederatedAuthenticationHandler(String moduleID, String action, Function2<? super XdAuthModule, ? super FederatedAuthenticationHandler<?>, ? extends Response> fn, Function1<? super AuthError, ? extends Response> handleError2) {
        return GodMode.INSTANCE.eval(action, (Function0)new Function0<Response>(moduleID, handleError2, fn){
            final /* synthetic */ String $moduleID;
            final /* synthetic */ Function1 $handleError;
            final /* synthetic */ Function2 $fn;

            @NotNull
            public final Response invoke() {
                Response response;
                XdAuthModule authModule = (XdAuthModule)XdAuthModule.Companion.resolve(this.$moduleID);
                if (authModule == null) {
                    response = (Response)this.$handleError.invoke((Object)AuthErrors.INSTANCE.unresolvedAuthProvider(this.$moduleID));
                } else if (Intrinsics.areEqual((Object)authModule.getCredentialsType(), ServletRequestCredentials.class) ^ true) {
                    response = (Response)this.$handleError.invoke((Object)AuthErrors.INSTANCE.authUnsupported(authModule.getName()));
                } else {
                    AuthenticationHandler authenticationHandler = authModule.getAuthenticationHandler();
                    if (authenticationHandler == null) {
                        throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.auth.module.dnq.authentication.FederatedAuthenticationHandler<*>");
                    }
                    FederatedAuthenticationHandler authenticationHandler2 = (FederatedAuthenticationHandler)authenticationHandler;
                    response = (Response)this.$fn.invoke((Object)authModule, (Object)authenticationHandler2);
                }
                return response;
            }
            {
                this.$moduleID = string;
                this.$handleError = function1;
                this.$fn = function2;
                super(0);
            }
        }, handleError2);
    }

    private FederatedAuthenticationUtil() {
    }
}

