/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth.interactive;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.auth.module.google.dnq.xd.XdGoogleAuthModule;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo;
import jetbrains.jetpass.oauth.interactive.FederatedAuthenticationUtil;
import jetbrains.jetpass.rest.common.ResourceUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="/cas/google")
@Produces(value={"application/json;charset=UTF-8"})
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u001c\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Ljetbrains/jetpass/oauth/interactive/LegacyCasGoogleResource;", "", "()V", "getIcon", "Ljavax/ws/rs/core/Response;", "getLanding", "request", "Ljavax/servlet/http/HttpServletRequest;", "info", "Ljetbrains/jetpass/oauth/interactive/AuthUrlInfo;", "jetbrains.jetpass.oauth.interactive"})
public final class LegacyCasGoogleResource {
    @GET
    @Path(value="/landing")
    @NotNull
    public final Response getLanding(@Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        String string = XdGoogleAuthModule.Companion.getActiveID();
        if (string == null) {
            throw (Throwable)new NotFoundException("Google auth is not enabled or misconfigured");
        }
        String activeId = string;
        return FederatedAuthenticationUtil.INSTANCE.landFederatedAuthentication(activeId, request, info);
    }

    @GET
    @Path(value="/icon")
    @Produces(value={"image/png"})
    @NotNull
    public final Response getIcon() {
        Response.ResponseBuilder responseBuilder = Response.ok();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"Response.ok()");
        Response response = ResourceUtilKt.classpathResourceEntity((Response.ResponseBuilder)responseBuilder, (String)"img/google_icon.png").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().classpathR\u2026google_icon.png\").build()");
        return response;
    }
}

