/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth.interactive;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.authority.module.Credentials;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthUrl;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.State;
import jetbrains.jetpass.auth.module.dnq.authentication.UsernamePasswordCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.login.OneTimeMessage;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth.interactive.AuthErrors;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo;
import jetbrains.jetpass.oauth.interactive.AuthenticateUtilKt;
import jetbrains.jetpass.oauth.interactive.GodMode;
import jetbrains.jetpass.oauth.interactive.recaptcha.ReCAPTCHA;
import jetbrains.jetpass.oauth2.server.AuthError;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import jetbrains.jetpass.rest.common.ExceptionExtKt;
import jetbrains.jetpass.rest.common.certificates.CertificateUtilsKt;
import jetbrains.jetpass.rest.dto.ErrorJSON;
import jetbrains.jetpass.service.api.FrontendURLProvider;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdGuestUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdInternalSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPasswordUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObject;
import jetbrains.jetpass.userManagement.persistence.dnq.totp.XdTwoFactorAuthentication;
import jetbrains.jetpass.userManagement.persistence.dnq.totp.XdTwoFactorAuthenticationSession;
import jetbrains.jetpass.userManagement.persistence.password.WeakPasswordValidationException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J<\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J<\u0010#\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020 J<\u0010)\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010 2\b\u0010+\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\b\u0010,\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u0018J2\u0010)\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"J\u0016\u0010-\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J.\u0010.\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u000201R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00062"}, d2={"Ljetbrains/jetpass/oauth/interactive/LoginActions;", "", "()V", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "Lkotlin/properties/ReadOnlyProperty;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "jetPass$delegate", "urlProvider", "Ljetbrains/jetpass/service/api/FrontendURLProvider;", "getUrlProvider", "()Ljetbrains/jetpass/service/api/FrontendURLProvider;", "urlProvider$delegate", "certificate", "Ljavax/ws/rs/core/Response;", "request", "Ljavax/servlet/http/HttpServletRequest;", "authUrl", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthUrl;", "createResponseCore", "details", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdPasswordUserDetails;", "credentials", "Ljetbrains/jetpass/api/authority/module/Credentials;", "params", "", "", "rememberMe", "", "createResponseExternal", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserDetails;", "getMessages", "", "Ljetbrains/jetpass/rest/dto/ErrorJSON;", "token", "login", "username", "password", "reCaptchaResponse", "loginGuest", "twoFactorAuthentication", "code", "session", "Ljetbrains/jetpass/oauth/interactive/AuthUrlInfo;", "jetbrains.jetpass.oauth.interactive"})
public final class LoginActions {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private static final ReadOnlyProperty daoContainer$delegate;
    @NotNull
    private static final ReadOnlyProperty urlProvider$delegate;
    @NotNull
    private static final ReadOnlyProperty jetPass$delegate;
    public static final LoginActions INSTANCE;

    static {
        LoginActions loginActions;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LoginActions.class), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LoginActions.class), "urlProvider", "getUrlProvider()Ljetbrains/jetpass/service/api/FrontendURLProvider;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LoginActions.class), "jetPass", "getJetPass()Ljetbrains/jetpass/service/api/JetPassMainApp;"))};
        INSTANCE = loginActions = new LoginActions();
        String name$iv = null;
        daoContainer$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
        name$iv = null;
        urlProvider$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
        name$iv = null;
        jetPass$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)daoContainer$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final FrontendURLProvider getUrlProvider() {
        return (FrontendURLProvider)urlProvider$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @NotNull
    public final JetPassMainApp getJetPass() {
        return (JetPassMainApp)jetPass$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @NotNull
    public final Response login(@NotNull HttpServletRequest request, @Nullable String username, @Nullable String password, boolean rememberMe, @Nullable String reCaptchaResponse, @NotNull AuthUrl authUrl) {
        boolean bl;
        CharSequence charSequence;
        CharSequence charSequence2;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Map params = OAuthUtilKt.getAuthParameters((HttpServletRequest)request);
        if (username == null || (charSequence2 = (CharSequence)username).length() == 0) {
            return AuthenticateUtilKt.loginFailed(AuthErrors.INSTANCE.emptyUsername(), params);
        }
        if (password == null || (charSequence2 = (CharSequence)password).length() == 0) {
            return AuthenticateUtilKt.loginFailed(AuthErrors.INSTANCE.emptyPassword(), params);
        }
        if (reCaptchaResponse != null && (charSequence = (CharSequence)reCaptchaResponse).length() > 0) {
            AuthError authError2 = (AuthError)GodMode.INSTANCE.eval((Function0)new Function0<AuthError>(reCaptchaResponse, request){
                final /* synthetic */ String $reCaptchaResponse;
                final /* synthetic */ HttpServletRequest $request;

                @Nullable
                public final AuthError invoke() {
                    String string = ((XdInternalSettings)XdInternalSettings.Companion.getInstance()).getCaptchaSecretKey();
                    String string2 = this.$request.getRemoteAddr();
                    String string3 = this.$reCaptchaResponse;
                    ReCAPTCHA reCAPTCHA = ReCAPTCHA.INSTANCE;
                    String string4 = string;
                    if (string4 == null) {
                        string4 = "";
                    }
                    String string5 = string4;
                    return reCAPTCHA.validate(string3, string2, string5);
                }
                {
                    this.$reCaptchaResponse = string;
                    this.$request = httpServletRequest;
                    super(0);
                }
            });
            if (authError2 != null) {
                return AuthenticateUtilKt.loginFailed(authError2, params);
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean isReCaptchaVerified2 = bl;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password, AuthenticateUtilKt.toLoginContext(request), isReCaptchaVerified2);
        return (Response)GodMode.INSTANCE.eval("Login with username [" + username + ']', (Function0)new Function0<Response>(credentials, authUrl, params, rememberMe){
            final /* synthetic */ UsernamePasswordCredentials $credentials;
            final /* synthetic */ AuthUrl $authUrl;
            final /* synthetic */ Map $params;
            final /* synthetic */ boolean $rememberMe;

            @NotNull
            public final Response invoke() {
                return LoginActions.INSTANCE.login((Credentials)this.$credentials, this.$authUrl, this.$params, this.$rememberMe);
            }
            {
                this.$credentials = usernamePasswordCredentials;
                this.$authUrl = authUrl;
                this.$params = map;
                this.$rememberMe = bl;
                super(0);
            }
        }, (Function1)new Function1<AuthError, Response>(params){
            final /* synthetic */ Map $params;

            @NotNull
            public final Response invoke(@NotNull AuthError authError2) {
                Intrinsics.checkParameterIsNotNull((Object)authError2, (String)"authError");
                return AuthenticateUtilKt.loginFailed(authError2, this.$params);
            }
            {
                this.$params = map;
                super(1);
            }
        });
    }

    @NotNull
    public final Response login(@NotNull Credentials credentials, @NotNull AuthUrl authUrl, @NotNull Map<String, String> params, boolean rememberMe) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        UserDetails loggedIn = this.getDaoContainer().getJetPassAuthModuleDAO().login(credentials, false);
        return (Response)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Response>(loggedIn, credentials, authUrl, params, rememberMe){
            final /* synthetic */ UserDetails $loggedIn;
            final /* synthetic */ Credentials $credentials;
            final /* synthetic */ AuthUrl $authUrl;
            final /* synthetic */ Map $params;
            final /* synthetic */ boolean $rememberMe;

            @NotNull
            public final Response invoke(@NotNull TransientStoreSession it) {
                XdBaseUserDetails details;
                XdBaseUserDetails xdBaseUserDetails;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdUUIDObject xdUUIDObject = XdBaseUserDetails.Companion.resolve(this.$loggedIn.getId());
                if (xdUUIDObject == null) {
                    Intrinsics.throwNpe();
                }
                return (xdBaseUserDetails = (details = (XdBaseUserDetails)xdUUIDObject)) instanceof XdPasswordUserDetails ? LoginActions.access$createResponseCore(LoginActions.INSTANCE, (XdPasswordUserDetails)details, this.$credentials, this.$authUrl, this.$params, this.$rememberMe) : LoginActions.access$createResponseExternal(LoginActions.INSTANCE, details, this.$credentials, this.$authUrl, this.$params, this.$rememberMe);
            }
            {
                this.$loggedIn = userDetails;
                this.$credentials = credentials;
                this.$authUrl = authUrl;
                this.$params = map;
                this.$rememberMe = bl;
                super(1);
            }
        }), (int)7, null);
    }

    @NotNull
    public final Response twoFactorAuthentication(@NotNull HttpServletRequest request, @NotNull String code, @NotNull String session, boolean rememberMe, @NotNull AuthUrlInfo authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Map params = OAuthUtilKt.getAuthParameters((HttpServletRequest)request);
        Integer n = StringsKt.toIntOrNull((String)code);
        if (n == null) {
            return AuthenticateUtilKt.loginFailed(AuthErrors.INSTANCE.twoFactorAuthenticationInvalidCode(code), params);
        }
        int iCode = n;
        return (Response)GodMode.INSTANCE.eval((Function0)new Function0<Response>(session, params, iCode, code, authUrl, rememberMe){
            final /* synthetic */ String $session;
            final /* synthetic */ Map $params;
            final /* synthetic */ int $iCode;
            final /* synthetic */ String $code;
            final /* synthetic */ AuthUrlInfo $authUrl;
            final /* synthetic */ boolean $rememberMe;

            @NotNull
            public final Response invoke() {
                Response response;
                XdTwoFactorAuthenticationSession xdSession = (XdTwoFactorAuthenticationSession)XdTwoFactorAuthenticationSession.Companion.resolve(this.$session);
                if (xdSession == null) {
                    response = AuthenticateUtilKt.loginFailed(AuthErrors.INSTANCE.twoFactorAuthenticationInvalidSession(this.$session), this.$params);
                } else {
                    XdTwoFactorAuthentication twoFactorAuthentication2 = xdSession.getTwoFactorAuthentication();
                    XdBaseUserDetails xdDetails = twoFactorAuthentication2.finishSession(xdSession);
                    if (twoFactorAuthentication2.getFailedAttemptsCounter() >= 10) {
                        String login2 = twoFactorAuthentication2.getUser().getLogin();
                        response = Intrinsics.areEqual((Object)LoginActions.INSTANCE.getJetPass().getAuth().getAdminLogin(), (Object)login2) ? AuthenticateUtilKt.loginFailed(AuthErrors.INSTANCE.twoFactorAuthenticationFailuresNumberExceededForAdmin(10), this.$params) : AuthenticateUtilKt.loginFailed(AuthErrors.INSTANCE.twoFactorAuthenticationFailuresNumberExceeded(login2, 10), this.$params);
                    } else {
                        boolean isValid = twoFactorAuthentication2.isValid(this.$iCode);
                        if (!isValid) {
                            XdTwoFactorAuthentication xdTwoFactorAuthentication = twoFactorAuthentication2;
                            int n = xdTwoFactorAuthentication.getFailedAttemptsCounter();
                            xdTwoFactorAuthentication.setFailedAttemptsCounter(n + 1);
                            response = AuthenticateUtilKt.loginFailed(AuthErrors.INSTANCE.twoFactorAuthenticationInvalidCode(this.$code), this.$params);
                        } else {
                            twoFactorAuthentication2.setFailedAttemptsCounter(0);
                            response = AuthenticateUtilKt.success(xdDetails, this.$authUrl, this.$rememberMe);
                        }
                    }
                }
                return response;
            }
            {
                this.$session = string;
                this.$params = map;
                this.$iCode = n;
                this.$code = string2;
                this.$authUrl = authUrlInfo;
                this.$rememberMe = bl;
                super(0);
            }
        });
    }

    @NotNull
    public final Response certificate(@NotNull HttpServletRequest request, @NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Map params = OAuthUtilKt.getAuthParameters((HttpServletRequest)request);
        URI redirectTo = URI.create(authUrl.getOAuth2AuthEndpoint());
        Object t = GodMode.INSTANCE.eval("Login with a certificate", (Function0)new Function0<Response>(request, redirectTo){
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ URI $redirectTo;

            public final Response invoke() {
                CertificateUtilsKt.loginWithCertificate((JetPassDAOContainer)LoginActions.INSTANCE.getDaoContainer(), (HttpServletRequest)this.$request);
                Response response = Response.seeOther((URI)this.$redirectTo).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(redirectTo).build()");
                return response;
            }
            {
                this.$request = httpServletRequest;
                this.$redirectTo = uRI;
                super(0);
            }
        }, (Function1)new Function1<AuthError, Response>(params){
            final /* synthetic */ Map $params;

            @NotNull
            public final Response invoke(@NotNull AuthError authError2) {
                Intrinsics.checkParameterIsNotNull((Object)authError2, (String)"authError");
                return AuthenticateUtilKt.loginFailed(authError2, this.$params);
            }
            {
                this.$params = map;
                super(1);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"GodMode.eval(\"Login with\u2026Failed(params)\n        })");
        return (Response)t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ErrorJSON> getMessages(@NotNull String token) {
        Collection destination$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        List list = this.getDaoContainer().getJetPassAuthModuleDAO().getMessages(token);
        if (list != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                OneTimeMessage oneTimeMessage = (OneTimeMessage)item$iv$iv;
                Collection collection = destination$iv$iv;
                ErrorJSON errorJSON = ExceptionExtKt.toJSON((OneTimeMessage)it);
                collection.add(errorJSON);
            }
        } else {
            throw (Throwable)new NotFoundException("Message list is not found");
        }
        return (List)destination$iv$iv;
    }

    private final Response createResponseExternal(XdBaseUserDetails details, Credentials credentials, AuthUrl authUrl, Map<String, String> params, boolean rememberMe) {
        Response response;
        if (credentials instanceof ServletRequestCredentials) {
            State state2 = ((ServletRequestCredentials)credentials).getState();
            URI proxy = state2.getProxyURI();
            response = proxy != null ? AuthenticateUtilKt.success(details, proxy, rememberMe) : AuthenticateUtilKt.success(details, authUrl, rememberMe);
        } else {
            response = AuthenticateUtilKt.checkSecondFactor(details, params, rememberMe);
            if (response == null) {
                response = AuthenticateUtilKt.success(details, authUrl, rememberMe);
            }
        }
        return response;
    }

    private final Response createResponseCore(XdPasswordUserDetails details, Credentials credentials, AuthUrl authUrl, Map<String, String> params, boolean rememberMe) {
        Response response;
        if (details.getPasswordChangeRequired()) {
            response = AuthenticateUtilKt.changePassword((XdBaseUserDetails)details, params, "hub-auth-login-password-change-request");
        } else {
            Response response2;
            try {
                Credentials credentials2 = credentials;
                if (credentials2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.auth.module.dnq.authentication.UsernamePasswordCredentials");
                }
                details.checkPasswordStrength(((UsernamePasswordCredentials)credentials2).getPassword());
                Response response3 = AuthenticateUtilKt.checkSecondFactor((XdBaseUserDetails)details, params, rememberMe);
                if (response3 == null) {
                    response3 = AuthenticateUtilKt.success((XdBaseUserDetails)details, authUrl, rememberMe);
                }
                response2 = response3;
            }
            catch (WeakPasswordValidationException e) {
                response2 = AuthenticateUtilKt.changePassword((XdBaseUserDetails)details, params, "hub-auth-login-password-policy-violated", e.getMessageId());
            }
            response = response2;
        }
        return response;
    }

    @NotNull
    public final Response loginGuest(@NotNull HttpServletRequest request, @NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        return GodMode.INSTANCE.eval("Guest login", this.getUrlProvider().getLoginUrl(), request, (Function0<? extends Response>)((Function0)new Function0<Response>(request, authUrl){
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ AuthUrl $authUrl;

            @NotNull
            public final Response invoke() {
                XdGuestUser guest = XdRoots.INSTANCE.getGuest();
                return guest == null || guest.getBanned() ? AuthenticateUtilKt.loginFailed(AuthErrors.INSTANCE.guestDisabled(), OAuthUtilKt.getAuthParameters((HttpServletRequest)this.$request)) : AuthenticateUtilKt.successGuest(guest, this.$authUrl);
            }
            {
                this.$request = httpServletRequest;
                this.$authUrl = authUrl;
                super(0);
            }
        }));
    }

    private LoginActions() {
    }

    @NotNull
    public static final /* synthetic */ Response access$createResponseCore(LoginActions $this, @NotNull XdPasswordUserDetails details, @NotNull Credentials credentials, @NotNull AuthUrl authUrl, @NotNull Map params, boolean rememberMe) {
        return $this.createResponseCore(details, credentials, authUrl, params, rememberMe);
    }

    @NotNull
    public static final /* synthetic */ Response access$createResponseExternal(LoginActions $this, @NotNull XdBaseUserDetails details, @NotNull Credentials credentials, @NotNull AuthUrl authUrl, @NotNull Map params, boolean rememberMe) {
        return $this.createResponseExternal(details, credentials, authUrl, params, rememberMe);
    }
}

