/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth.interactive;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BeanParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo;
import jetbrains.jetpass.oauth.interactive.AuthenticateUtilKt;
import jetbrains.jetpass.oauth.interactive.FederatedAuthenticationUtil;
import jetbrains.jetpass.oauth.interactive.LoginActions;
import jetbrains.jetpass.oauth.interactive.LoginFormSettingsJSON;
import jetbrains.jetpass.rest.dto.ErrorJSON;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J&\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\f\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\bH\u0007J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u000bH\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\bH\u0007JF\u0010\u0014\u001a\u00020\u00042\b\b\u0001\u0010\u0015\u001a\u00020\u000b2\b\b\u0001\u0010\u0016\u001a\u00020\u000b2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J&\u0010\u001a\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J0\u0010\u001b\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\bH\u0007J:\u0010\u001c\u001a\u00020\u00042\b\b\u0001\u0010\u001d\u001a\u00020\u000b2\b\b\u0001\u0010\u001e\u001a\u00020\u000b2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u001f"}, d2={"Ljetbrains/jetpass/oauth/interactive/LoginSubresource;", "", "()V", "certificateLogin", "Ljavax/ws/rs/core/Response;", "request", "Ljavax/servlet/http/HttpServletRequest;", "authUrl", "Ljetbrains/jetpass/oauth/interactive/AuthUrlInfo;", "getFederatedLand", "module", "", "getGuest", "info", "getMessages", "", "Ljetbrains/jetpass/rest/dto/ErrorJSON;", "token", "getSettings", "Ljetbrains/jetpass/oauth/interactive/LoginFormSettingsJSON;", "post", "username", "password", "rememberMe", "", "reCaptchaResponse", "postFederatedLand", "startFederated", "twoFactorAuthentication", "code", "session", "jetbrains.jetpass.oauth.interactive"})
public final class LoginSubresource {
    @GET
    @Path(value="/settings")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final LoginFormSettingsJSON getSettings(@Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        return AuthenticateUtilKt.getLoginFormSettings(request, info);
    }

    @POST
    @NotNull
    public final Response post(@FormParam(value="username") @NotNull String username, @FormParam(value="password") @NotNull String password, @FormParam(value="rememberMe") boolean rememberMe, @FormParam(value="g-recaptcha-response") @Nullable String reCaptchaResponse, @Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        return LoginActions.INSTANCE.login(request, username, password, rememberMe, reCaptchaResponse, authUrl);
    }

    @POST
    @Path(value="/2fa")
    @NotNull
    public final Response twoFactorAuthentication(@FormParam(value="code") @NotNull String code, @FormParam(value="session") @NotNull String session, @FormParam(value="rememberMe") boolean rememberMe, @Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        return LoginActions.INSTANCE.twoFactorAuthentication(request, code, session, rememberMe, authUrl);
    }

    @GET
    @Path(value="/messages")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final List<ErrorJSON> getMessages(@QueryParam(value="token") @NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        return LoginActions.INSTANCE.getMessages(token);
    }

    @GET
    @Path(value="/guest")
    @NotNull
    public final Response getGuest(@Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        return LoginActions.INSTANCE.loginGuest(request, info);
    }

    @GET
    @Path(value="/{module}/start")
    @NotNull
    public final Response startFederated(@PathParam(value="module") @NotNull String module, @QueryParam(value="rememberMe") boolean rememberMe, @Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        return FederatedAuthenticationUtil.INSTANCE.startFederatedAuthentication(module, request, info, rememberMe, false);
    }

    @GET
    @Path(value="/{module}/land")
    @NotNull
    public final Response getFederatedLand(@PathParam(value="module") @NotNull String module, @Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        return FederatedAuthenticationUtil.INSTANCE.landFederatedAuthentication(module, request, authUrl);
    }

    @POST
    @Path(value="/{module}/land")
    @NotNull
    public final Response postFederatedLand(@PathParam(value="module") @NotNull String module, @Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        return FederatedAuthenticationUtil.INSTANCE.landFederatedAuthentication(module, request, authUrl);
    }

    @POST
    @Path(value="/certificate")
    @NotNull
    public final Response certificateLogin(@Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        return LoginActions.INSTANCE.certificate(request, authUrl);
    }
}

