/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth.interactive;

import com.intellij.hub.auth.request.AuthRequestParameter;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BeanParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.auth.module.core.dnq.xd.XdCoreAuthModule;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.dnq.api.DataAccessExceptionUtilKt;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.oauth.interactive.AuthErrors;
import jetbrains.jetpass.oauth.interactive.AuthUrlInfo;
import jetbrains.jetpass.oauth.interactive.AuthenticateUtilKt;
import jetbrains.jetpass.oauth.interactive.GodMode;
import jetbrains.jetpass.oauth.interactive.RestorePasswordSubresource;
import jetbrains.jetpass.oauth2.server.AuthError;
import jetbrains.jetpass.oauth2.server.AuthErrorKt;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import jetbrains.jetpass.oauth2.server.UriBuilderUtilKt;
import jetbrains.jetpass.rest.api.resource.ResourceUtilKt;
import jetbrains.jetpass.service.api.FrontendURLProvider;
import jetbrains.jetpass.service.api.UrlDAO;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.PasswordRestoreException;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPasswordRestoreToken;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0007J\u001a\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0007J:\u0010\u001f\u001a\u00020\u00162\b\b\u0001\u0010 \u001a\u00020\u00182\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010!\u001a\u00020\"2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Ljetbrains/jetpass/oauth/interactive/RestorePasswordSubresource;", "", "()V", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "Lkotlin/properties/ReadOnlyProperty;", "urlDAO", "Ljetbrains/jetpass/service/api/UrlDAO;", "getUrlDAO", "()Ljetbrains/jetpass/service/api/UrlDAO;", "urlDAO$delegate", "urlProvider", "Ljetbrains/jetpass/service/api/FrontendURLProvider;", "getUrlProvider", "()Ljetbrains/jetpass/service/api/FrontendURLProvider;", "urlProvider$delegate", "assertPasswordRestoreIsEnabled", "", "checkCodeAndRedirect", "Ljavax/ws/rs/core/Response;", "code", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "authUrl", "Ljetbrains/jetpass/oauth/interactive/AuthUrlInfo;", "requestRestoreEmail", "email", "resetPassword", "password", "rememberMe", "", "jetbrains.jetpass.oauth.interactive"})
public final class RestorePasswordSubresource {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty daoContainer$delegate;
    private final ReadOnlyProperty urlDAO$delegate;
    private final ReadOnlyProperty urlProvider$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RestorePasswordSubresource.class), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RestorePasswordSubresource.class), "urlDAO", "getUrlDAO()Ljetbrains/jetpass/service/api/UrlDAO;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RestorePasswordSubresource.class), "urlProvider", "getUrlProvider()Ljetbrains/jetpass/service/api/FrontendURLProvider;"))};
    }

    private final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)this.daoContainer$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final UrlDAO getUrlDAO() {
        return (UrlDAO)this.urlDAO$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final FrontendURLProvider getUrlProvider() {
        return (FrontendURLProvider)this.urlProvider$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response requestRestoreEmail(@NotNull String email, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Object object = ResourceUtilKt.daoAction((Function0)((Function0)new Function0<Response>(this, email, request){
            final /* synthetic */ RestorePasswordSubresource this$0;
            final /* synthetic */ String $email;
            final /* synthetic */ HttpServletRequest $request;

            public final Response invoke() {
                T t = GodMode.INSTANCE.eval((Function0)new Function0<Response>(this){
                    final /* synthetic */ requestRestoreEmail.1 this$0;

                    public final Response invoke() {
                        Object object = DataAccessExceptionUtilKt.daoTransaction$default((JetPassDAOContainer)RestorePasswordSubresource.access$getDaoContainer$p(this.this$0.this$0), (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Response>(this){
                            final /* synthetic */ requestRestoreEmail.1 this$0;

                            public final Response invoke(@NotNull TransientStoreSession it) {
                                URI restoreURL;
                                String strippedEmail;
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                RestorePasswordSubresource.access$assertPasswordRestoreIsEnabled(this.this$0.this$0.this$0);
                                String string = strippedEmail = StringUtils.strip((String)this.this$0.this$0.$email, (String)"'\"");
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"strippedEmail");
                                XdPasswordRestoreToken token = XdPasswordRestoreToken.Companion.createToken(string);
                                String clientId = this.this$0.this$0.$request.getParameter("client_id");
                                XdService xdService = XdService.Companion.resolve(clientId);
                                if (xdService == null) {
                                    xdService = (XdService)XdRoots.INSTANCE.getRootService();
                                }
                                XdService dbService = xdService;
                                UriBuilder uriBuilder = UriBuilder.fromUri((URI)RestorePasswordSubresource.access$getUrlDAO$p(this.this$0.this$0.this$0).getPasswordRestoreUri(token.getCode()));
                                Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"UriBuilder.fromUri(urlDA\u2026rdRestoreUri(token.code))");
                                URI uRI = restoreURL = UriBuilderUtilKt.copyParams((UriBuilder)uriBuilder, (Map)OAuthUtilKt.getAuthParameters((HttpServletRequest)this.this$0.this$0.$request)).build(new Object[0]);
                                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"restoreURL");
                                token.sendCode(strippedEmail, dbService, uRI);
                                Response response = Response.noContent().build();
                                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.noContent().build()");
                                return response;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)1, null);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"daoContainer.daoTransact\u2026t().build()\n            }");
                        return (Response)object;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"GodMode.eval {\n         \u2026)\n            }\n        }");
                return (Response)t;
            }
            {
                this.this$0 = restorePasswordSubresource;
                this.$email = string;
                this.$request = httpServletRequest;
                super(0);
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"daoAction {\n        GodM\u2026        }\n        }\n    }");
        return (Response)object;
    }

    @POST
    @Path(value="/password")
    @NotNull
    public final Response resetPassword(@FormParam(value="password") @NotNull String password, @FormParam(value="code") @NotNull String code, @FormParam(value="rememberMe") boolean rememberMe, @Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        return GodMode.INSTANCE.eval("Password restore", this.getUrlProvider().getRestoreCodeUrl(code), request, (Function0<? extends Response>)((Function0)new Function0<Response>(this, code, password, authUrl, rememberMe){
            final /* synthetic */ RestorePasswordSubresource this$0;
            final /* synthetic */ String $code;
            final /* synthetic */ String $password;
            final /* synthetic */ AuthUrlInfo $authUrl;
            final /* synthetic */ boolean $rememberMe;

            @NotNull
            public final Response invoke() {
                return (Response)DataAccessExceptionUtilKt.daoTransaction$default((JetPassDAOContainer)RestorePasswordSubresource.access$getDaoContainer$p(this.this$0), (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Response>(this){
                    final /* synthetic */ resetPassword.1 this$0;

                    @NotNull
                    public final Response invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        XdPasswordRestoreToken token = XdPasswordRestoreToken.Companion.findToken(this.this$0.$code);
                        XdBaseUserDetails details = token.restorePassword(this.this$0.$password);
                        return AuthenticateUtilKt.success(details, this.this$0.$authUrl, this.this$0.$rememberMe);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null);
            }
            {
                this.this$0 = restorePasswordSubresource;
                this.$code = string;
                this.$password = string2;
                this.$authUrl = authUrlInfo;
                this.$rememberMe = bl;
                super(0);
            }
        }));
    }

    @GET
    @Path(value="{code:.+}")
    @NotNull
    public final Response checkCodeAndRedirect(@PathParam(value="code") @NotNull String code, @Context @NotNull HttpServletRequest request, @BeanParam @NotNull AuthUrlInfo authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Object object = DataAccessExceptionUtilKt.daoTransaction$default((JetPassDAOContainer)this.getDaoContainer(), (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Response>(this, code, request, authUrl){
            final /* synthetic */ RestorePasswordSubresource this$0;
            final /* synthetic */ String $code;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ AuthUrlInfo $authUrl;

            public final Response invoke(@NotNull TransientStoreSession it) {
                Response response;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                try {
                    XdPasswordRestoreToken.Companion.findToken(this.$code);
                    UriBuilder uriBuilder = UriBuilder.fromUri((URI)RestorePasswordSubresource.access$getUrlProvider$p(this.this$0).getRestoreCodeUrl(this.$code));
                    Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"UriBuilder.fromUri(urlPr\u2026.getRestoreCodeUrl(code))");
                    URI restoreUri = UriBuilderUtilKt.copyParams((UriBuilder)uriBuilder, (Map)OAuthUtilKt.getAuthParameters((HttpServletRequest)this.$request)).build(new Object[0]);
                    Response response2 = Response.seeOther((URI)restoreUri).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"Response.seeOther(restoreUri).build()");
                    response = response2;
                }
                catch (PasswordRestoreException ex) {
                    URI authUri = URI.create(this.$authUrl.getOAuth2AuthEndpoint());
                    AuthError authError2 = AuthErrors.INSTANCE.restorePasswordCodeInvalid();
                    URI uRI = authUri;
                    Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"authUri");
                    response = AuthErrorKt.redirectToUri$default((AuthError)authError2, (URI)AuthenticateUtilKt.withAuthDefaults(uRI), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"request_credentials", (Object)AuthRequestParameter.RequestCredentials.DEFAULT.name())), null, (int)4, null);
                }
                return response;
            }
            {
                this.this$0 = restorePasswordSubresource;
                this.$code = string;
                this.$request = httpServletRequest;
                this.$authUrl = authUrlInfo;
                super(1);
            }
        }), (int)1, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"daoContainer.daoTransact\u2026)\n            }\n        }");
        return (Response)object;
    }

    private final void assertPasswordRestoreIsEnabled() {
        if (!XdCoreAuthModule.Companion.getInstance().getPasswordRestoreEnabled()) {
            DataAccessException dataAccessException;
            DataAccessException $receiver = dataAccessException = new DataAccessException("Password restore is disabled");
            $receiver.setCode("hub-auth-password-restore-disabled");
            throw (Throwable)dataAccessException;
        }
    }

    public RestorePasswordSubresource() {
        ReadOnlyProperty readOnlyProperty;
        RestorePasswordSubresource restorePasswordSubresource = this;
        String name$iv = null;
        restorePasswordSubresource.daoContainer$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        restorePasswordSubresource = this;
        name$iv = null;
        restorePasswordSubresource.urlDAO$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        restorePasswordSubresource = this;
        name$iv = null;
        restorePasswordSubresource.urlProvider$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public static final /* synthetic */ JetPassDAOContainer access$getDaoContainer$p(RestorePasswordSubresource $this) {
        return $this.getDaoContainer();
    }

    public static final /* synthetic */ void access$assertPasswordRestoreIsEnabled(RestorePasswordSubresource $this) {
        $this.assertPasswordRestoreIsEnabled();
    }

    @NotNull
    public static final /* synthetic */ UrlDAO access$getUrlDAO$p(RestorePasswordSubresource $this) {
        return $this.getUrlDAO();
    }

    @NotNull
    public static final /* synthetic */ FrontendURLProvider access$getUrlProvider$p(RestorePasswordSubresource $this) {
        return $this.getUrlProvider();
    }
}

