/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.lucene;

import java.io.IOException;
import java.util.Collection;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.lucene.ExodusDirectory;
import jetbrains.exodus.lucene.ExodusDirectoryConfig;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.RAMDirectory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002*+B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0016\u0010%\u001a\u00020\u000e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120'H\u0016J\b\u0010(\u001a\u00020\u000eH\u0016J\b\u0010)\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ljetbrains/exodus/lucene/DebugExodusDirectory;", "Lorg/apache/lucene/store/Directory;", "env", "Ljetbrains/exodus/env/ContextualEnvironment;", "contentsStoreConfig", "Ljetbrains/exodus/env/StoreConfig;", "directoryConfig", "Ljetbrains/exodus/lucene/ExodusDirectoryConfig;", "(Ljetbrains/exodus/env/ContextualEnvironment;Ljetbrains/exodus/env/StoreConfig;Ljetbrains/exodus/lucene/ExodusDirectoryConfig;)V", "debugDirectory", "Lorg/apache/lucene/store/RAMDirectory;", "directory", "Ljetbrains/exodus/lucene/ExodusDirectory;", "close", "", "createOutput", "Lorg/apache/lucene/store/IndexOutput;", "name", "", "context", "Lorg/apache/lucene/store/IOContext;", "createTempOutput", "prefix", "suffix", "deleteFile", "fileLength", "", "listAll", "", "()[Ljava/lang/String;", "obtainLock", "Lorg/apache/lucene/store/Lock;", "openInput", "Lorg/apache/lucene/store/IndexInput;", "rename", "source", "dest", "sync", "names", "", "syncMetaData", "throwDebugMismatch", "DebugIndexInput", "DebugIndexOutput", "xodus-lucene-directory"})
public final class DebugExodusDirectory
extends Directory {
    private final ExodusDirectory directory;
    private final RAMDirectory debugDirectory;

    @NotNull
    public String[] listAll() {
        String[] stringArray = this.debugDirectory.listAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"debugDirectory.listAll()");
        return stringArray;
    }

    public void deleteFile(@NotNull String name) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.directory.deleteFile(name);
        this.debugDirectory.deleteFile(name);
    }

    public long fileLength(@NotNull String name) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        long result = this.directory.fileLength(name);
        if (result != this.debugDirectory.fileLength(name)) {
            this.throwDebugMismatch();
        }
        return result;
    }

    @NotNull
    public IndexOutput createOutput(@NotNull String name, @NotNull IOContext context) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new DebugIndexOutput(name, context);
    }

    @NotNull
    public IndexOutput createTempOutput(@NotNull String prefix, @NotNull String suffix, @NotNull IOContext context) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = IndexFileNames.segmentFileName((String)prefix, (String)(suffix + '_' + this.directory.nextTicks$xodus_lucene_directory()), (String)"tmp");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IndexFileNames.segmentFi\u2026ctory.nextTicks(), \"tmp\")");
        return this.createOutput(string, context);
    }

    public void sync(@NotNull Collection<String> names) throws IOException {
        Intrinsics.checkParameterIsNotNull(names, (String)"names");
        this.directory.sync(names);
        this.debugDirectory.sync(names);
    }

    public void rename(@NotNull String source, @NotNull String dest) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        this.directory.rename(source, dest);
        this.debugDirectory.rename(source, dest);
    }

    public void syncMetaData() throws IOException {
        this.directory.syncMetaData();
        this.debugDirectory.syncMetaData();
    }

    @NotNull
    public IndexInput openInput(@NotNull String name, @NotNull IOContext context) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new DebugIndexInput(this, name, context, 0L, 4, null);
    }

    @NotNull
    public Lock obtainLock(@NotNull String name) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Lock lock = this.debugDirectory.obtainLock(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)lock, (String)"debugDirectory.obtainLock(name)");
        return lock;
    }

    public void close() {
        this.directory.close();
        this.debugDirectory.close();
    }

    private final void throwDebugMismatch() {
        throw (Throwable)new RuntimeException("Debug directory mismatch");
    }

    @JvmOverloads
    public DebugExodusDirectory(@NotNull ContextualEnvironment env, @NotNull StoreConfig contentsStoreConfig, @NotNull ExodusDirectoryConfig directoryConfig) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)contentsStoreConfig, (String)"contentsStoreConfig");
        Intrinsics.checkParameterIsNotNull((Object)directoryConfig, (String)"directoryConfig");
        this.directory = new ExodusDirectory(env, contentsStoreConfig, directoryConfig);
        this.debugDirectory = new RAMDirectory();
    }

    @JvmOverloads
    public /* synthetic */ DebugExodusDirectory(ContextualEnvironment contextualEnvironment, StoreConfig storeConfig, ExodusDirectoryConfig exodusDirectoryConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            storeConfig = StoreConfig.WITH_DUPLICATES;
        }
        if ((n & 4) != 0) {
            exodusDirectoryConfig = new ExodusDirectoryConfig(0, 0, 3, null);
        }
        this(contextualEnvironment, storeConfig, exodusDirectoryConfig);
    }

    @JvmOverloads
    public DebugExodusDirectory(@NotNull ContextualEnvironment env, @NotNull StoreConfig contentsStoreConfig) {
        this(env, contentsStoreConfig, null, 4, null);
    }

    @JvmOverloads
    public DebugExodusDirectory(@NotNull ContextualEnvironment env) {
        this(env, null, null, 6, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/exodus/lucene/DebugExodusDirectory$DebugIndexOutput;", "Lorg/apache/lucene/store/IndexOutput;", "name", "", "context", "Lorg/apache/lucene/store/IOContext;", "(Ljetbrains/exodus/lucene/DebugExodusDirectory;Ljava/lang/String;Lorg/apache/lucene/store/IOContext;)V", "debugOutput", "output", "close", "", "getChecksum", "", "getFilePointer", "writeByte", "b", "", "writeBytes", "", "offset", "", "length", "xodus-lucene-directory"})
    private final class DebugIndexOutput
    extends IndexOutput {
        private final IndexOutput output;
        private final IndexOutput debugOutput;

        public void close() throws IOException {
            this.output.close();
            this.debugOutput.close();
        }

        public long getFilePointer() {
            long result = this.output.getFilePointer();
            if (result != this.debugOutput.getFilePointer()) {
                DebugExodusDirectory.this.throwDebugMismatch();
            }
            return result;
        }

        public long getChecksum() throws IOException {
            long result = this.output.getChecksum();
            if (result != this.debugOutput.getChecksum()) {
                DebugExodusDirectory.this.throwDebugMismatch();
            }
            return result;
        }

        public void writeByte(byte b) throws IOException {
            this.output.writeByte(b);
            this.debugOutput.writeByte(b);
            this.getFilePointer();
        }

        public void writeBytes(@NotNull byte[] b, int offset, int length) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            this.output.writeBytes(b, offset, length);
            this.debugOutput.writeBytes(b, offset, length);
            this.getFilePointer();
        }

        public DebugIndexOutput(@NotNull String name, IOContext context) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super("DebugIndexOutput[" + name + ']', name);
            this.output = DebugExodusDirectory.this.directory.createOutput(name, context);
            IndexOutput indexOutput = DebugExodusDirectory.this.debugDirectory.createOutput(name, context);
            Intrinsics.checkExpressionValueIsNotNull((Object)indexOutput, (String)"debugDirectory.createOutput(name, context)");
            this.debugOutput = indexOutput;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\u0001H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J \u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/exodus/lucene/DebugExodusDirectory$DebugIndexInput;", "Lorg/apache/lucene/store/IndexInput;", "name", "", "context", "Lorg/apache/lucene/store/IOContext;", "position", "", "(Ljetbrains/exodus/lucene/DebugExodusDirectory;Ljava/lang/String;Lorg/apache/lucene/store/IOContext;J)V", "debugInput", "kotlin.jvm.PlatformType", "input", "clone", "close", "", "getFilePointer", "length", "readByte", "", "readBytes", "b", "", "offset", "", "len", "seek", "pos", "slice", "sliceDescription", "xodus-lucene-directory"})
    private final class DebugIndexInput
    extends IndexInput {
        private IndexInput input;
        private IndexInput debugInput;
        private String name;
        final /* synthetic */ DebugExodusDirectory this$0;

        public void close() throws IOException {
            this.input.close();
            this.debugInput.close();
        }

        public long getFilePointer() {
            long result = this.input.getFilePointer();
            IndexInput indexInput = this.debugInput;
            Intrinsics.checkExpressionValueIsNotNull((Object)indexInput, (String)"debugInput");
            if (result != indexInput.getFilePointer()) {
                this.this$0.throwDebugMismatch();
            }
            return result;
        }

        public void seek(long pos) throws IOException {
            this.input.seek(pos);
            this.debugInput.seek(pos);
            long l = this.input.getFilePointer();
            IndexInput indexInput = this.debugInput;
            Intrinsics.checkExpressionValueIsNotNull((Object)indexInput, (String)"debugInput");
            if (l != indexInput.getFilePointer()) {
                this.this$0.throwDebugMismatch();
            }
        }

        public long length() {
            long result = this.input.length();
            if (result != this.debugInput.length()) {
                this.this$0.throwDebugMismatch();
            }
            return result;
        }

        public byte readByte() throws IOException {
            byte debugByte;
            byte result = this.input.readByte();
            if (result != (debugByte = this.debugInput.readByte())) {
                this.this$0.throwDebugMismatch();
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        public void readBytes(@NotNull byte[] b, int offset, int len) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            long before = this.getFilePointer();
            this.input.readBytes(b, offset, len);
            byte[] bytes = new byte[len];
            this.debugInput.readBytes(bytes, 0, len);
            long after = this.getFilePointer();
            int n = 0;
            int n2 = (int)(after - before);
            while (n < n2) {
                void i;
                if (bytes[i] != b[offset + i]) {
                    this.this$0.throwDebugMismatch();
                }
                ++i;
            }
        }

        @NotNull
        public IndexInput clone() {
            IndexInput indexInput = super.clone();
            if (indexInput == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.lucene.DebugExodusDirectory.DebugIndexInput");
            }
            DebugIndexInput result = (DebugIndexInput)indexInput;
            result.name = this.name;
            IndexInput indexInput2 = this.input.clone();
            Intrinsics.checkExpressionValueIsNotNull((Object)indexInput2, (String)"input.clone()");
            result.input = indexInput2;
            result.debugInput = this.debugInput.clone();
            return result;
        }

        @NotNull
        public IndexInput slice(@NotNull String sliceDescription, long offset, long length) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)sliceDescription, (String)"sliceDescription");
            IndexInput indexInput = super.clone();
            if (indexInput == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.lucene.DebugExodusDirectory.DebugIndexInput");
            }
            DebugIndexInput result = (DebugIndexInput)indexInput;
            result.name = this.name;
            IndexInput indexInput2 = this.input.slice(sliceDescription, offset, length);
            Intrinsics.checkExpressionValueIsNotNull((Object)indexInput2, (String)"input.slice(sliceDescription, offset, length)");
            result.input = indexInput2;
            result.debugInput = this.debugInput.slice(sliceDescription, offset, length);
            return result;
        }

        public DebugIndexInput(@NotNull DebugExodusDirectory $outer, @NotNull String name, IOContext context, long position) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.this$0 = $outer;
            super("DebugIndexInput[" + name + ']');
            this.name = name;
            this.input = $outer.directory.openInput(this.name, context);
            this.debugInput = $outer.debugDirectory.openInput(this.name, context);
            this.input = $outer.directory.openInput(this.name, context);
            this.debugInput = $outer.debugDirectory.openInput(this.name, context);
            if (position > 0L) {
                this.input.seek(position);
                this.debugInput.seek(position);
            }
        }

        public /* synthetic */ DebugIndexInput(DebugExodusDirectory debugExodusDirectory, String string, IOContext iOContext, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = 0L;
            }
            this(debugExodusDirectory, string, iOContext, l);
        }
    }
}

