/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.backend.rest;

import com.jetbrains.bundle.util.auth.Authenticator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthInterceptor
extends HandlerInterceptorAdapter {
    public static final String AUTH_PARAMETER = "bundleBackendToken";
    private final Authenticator myAuthenticator;

    public AuthInterceptor(Authenticator authenticator) {
        this.myAuthenticator = authenticator;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(request.getPathInfo().equals("/state") || request.getPathInfo().equals("/state/started") || request.getPathInfo().equals("/bundleBackendStatus"))) {
            String bundleBackendToken = request.getParameter(AUTH_PARAMETER);
            this.myAuthenticator.authenticate(bundleBackendToken);
        }
        return super.preHandle(request, response, handler);
    }
}

