/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.login.AuthAttempt;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.UuidJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="authAttempt")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=AuthAttemptJSON.class)
public class AuthAttemptJSON
extends UuidJSON
implements AuthAttempt {
    @XmlElement(name="externalUserDetails")
    private DetailsJSON externalUserDetails;
    @XmlElement(name="persistedUserDetails")
    private DetailsJSON persistedUserDetails;
    @XmlElement(name="similarUser")
    private UserJSON similarUser;
    @XmlElement(name="authModule")
    private AuthmoduleJSON authModule;

    public AuthAttemptJSON() {
    }

    public AuthAttemptJSON(@NotNull AuthAttempt that) {
        Object ref;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        if (that.getExternalUserDetails() != null) {
            ref = new DetailsJSON();
            ((DetailsJSON)ref).setId(that.getExternalUserDetails().getId());
            this.setExternalUserDetails((DetailsJSON)ref);
        }
        if (that.getPersistedUserDetails() != null) {
            ref = new DetailsJSON();
            ((DetailsJSON)ref).setId(that.getPersistedUserDetails().getId());
            this.setPersistedUserDetails((DetailsJSON)ref);
        }
        if (that.getSimilarUser() != null) {
            ref = new UserJSON();
            ((AuthorityHolderJSON)ref).setId(that.getSimilarUser().getId());
            this.setSimilarUser((UserJSON)ref);
        }
        if (that.getAuthModule() != null) {
            ref = new AuthmoduleJSON();
            ((AuthmoduleJSON)ref).setId(that.getAuthModule().getId());
            this.setAuthModule((AuthmoduleJSON)ref);
        }
    }

    @Nullable
    public DetailsJSON getExternalUserDetails() {
        return this.externalUserDetails;
    }

    @Nullable
    public DetailsJSON getPersistedUserDetails() {
        return this.persistedUserDetails;
    }

    @Nullable
    public UserJSON getSimilarUser() {
        return this.similarUser;
    }

    @Nullable
    public AuthmoduleJSON getAuthModule() {
        return this.authModule;
    }

    @XmlTransient
    public void setExternalUserDetails(@Nullable DetailsJSON externalUserDetails) {
        this.externalUserDetails = externalUserDetails;
    }

    @XmlTransient
    public void setPersistedUserDetails(@Nullable DetailsJSON persistedUserDetails) {
        this.persistedUserDetails = persistedUserDetails;
    }

    @XmlTransient
    public void setSimilarUser(@Nullable UserJSON similarUser) {
        this.similarUser = similarUser;
    }

    @XmlTransient
    public void setAuthModule(@Nullable AuthmoduleJSON authModule) {
        this.authModule = authModule;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthAttempt)) {
            return false;
        }
        AuthAttempt that = (AuthAttempt)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static AuthAttemptJSON wrap(@NotNull AuthAttempt that) {
        if (that instanceof AuthAttemptJSON) {
            return (AuthAttemptJSON)that;
        }
        return new AuthAttemptJSON(that);
    }
}

