/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.dashboard.Dashboard;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.DashboardPermissionJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.UuidJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="dashboard")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=DashboardJSON.class)
public class DashboardJSON
extends UuidJSON
implements Dashboard {
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="owner")
    private UserJSON owner;
    @XmlElement(name="data")
    @JsonRawValue
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String data;
    @XmlElement(name="permission")
    private String permission;
    @XmlElement(name="access")
    private String access;
    @XmlElement(name="permissions")
    private List<DashboardPermissionJSON> permissions;
    @XmlElement(name="favorite")
    private Boolean favorite;
    @XmlElement(name="ordinal")
    private Integer ordinal;

    public DashboardJSON() {
    }

    public DashboardJSON(@NotNull Dashboard that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getOwner() != null) {
            UserJSON ref = new UserJSON();
            ref.setId(that.getOwner().getId());
            this.setOwner(ref);
        }
        this.setData(that.getData());
        if (that.getPermissions() != null) {
            ArrayList<DashboardPermissionJSON> references = new ArrayList<DashboardPermissionJSON>();
            for (Alias it : that.getPermissions()) {
                DashboardPermissionJSON ref = new DashboardPermissionJSON();
                ref.setId(it.getId());
                references.add(ref);
            }
            this.setPermissions(references);
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public UserJSON getOwner() {
        return this.owner;
    }

    @Nullable
    public String getData() {
        return this.data;
    }

    @Nullable
    public String getPermission() {
        return this.permission;
    }

    public String getAccess() {
        return this.access;
    }

    @Nullable
    public Iterable<DashboardPermissionJSON> getPermissions() {
        return this.permissions;
    }

    @Nullable
    public Boolean isFavorite() {
        return this.favorite;
    }

    @Nullable
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setOwner(@Nullable UserJSON owner) {
        this.owner = owner;
    }

    @JsonProperty
    public void setData(@Nullable JsonNode data) {
        this.data = data != null ? data.toString() : "{}";
    }

    public void setData(@Nullable String data) {
        this.data = data;
    }

    @XmlTransient
    public void setPermission(@Nullable String permission) {
        this.permission = permission;
    }

    @XmlTransient
    public void setPermissions(@Nullable Iterable<DashboardPermissionJSON> permissions) {
        this.permissions = JsonUtils.iterableToList(permissions);
    }

    @XmlTransient
    public void setFavorite(@Nullable Boolean favorite) {
        this.favorite = favorite;
    }

    @XmlTransient
    public void setOrdinal(@Nullable Integer ordinal) {
        this.ordinal = ordinal;
    }

    @XmlTransient
    public void setAccess(String access) {
        this.access = access;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dashboard)) {
            return false;
        }
        Dashboard that = (Dashboard)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static DashboardJSON wrap(@NotNull Dashboard that) {
        if (that instanceof DashboardJSON) {
            return (DashboardJSON)that;
        }
        return new DashboardJSON(that);
    }
}

