/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.HeaderItem;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="headerItem")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class HeaderItemJSON
implements HeaderItem {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="homeUrl")
    private String homeUrl;
    @XmlElement(name="iconUrl")
    private String iconUrl;
    @XmlElement(name="applicationName")
    private String applicationName;
    @XmlElement(name="vendor")
    private String vendor;

    public HeaderItemJSON() {
    }

    public HeaderItemJSON(@NotNull HeaderItem that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        this.setHomeUrl(that.getHomeUrl());
        this.setIconUrl(that.getIconUrl());
        this.setApplicationName(that.getApplicationName());
        this.setVendor(that.getVendor());
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getHomeUrl() {
        return this.homeUrl;
    }

    @Nullable
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    @Nullable
    public String getVendor() {
        return this.vendor;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = JsonUtils.iterableToList(aliasIds);
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setHomeUrl(@Nullable String homeUrl) {
        this.homeUrl = homeUrl;
    }

    @XmlTransient
    public void setIconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @XmlTransient
    public void setApplicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
    }

    @XmlTransient
    public void setVendor(@Nullable String vendor) {
        this.vendor = vendor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeaderItem)) {
            return false;
        }
        HeaderItem that = (HeaderItem)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static HeaderItemJSON wrap(@NotNull HeaderItem that) {
        if (that instanceof HeaderItemJSON) {
            return (HeaderItemJSON)that;
        }
        return new HeaderItemJSON(that);
    }
}

