/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.InternalSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="internalSettings")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeName(value="internal")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=InternalSettingsJSON.class)
public class InternalSettingsJSON
extends SettingsJSON
implements InternalSettings {
    @XmlElement(name="tokenInterval")
    private Integer tokenInterval;
    @XmlElement(name="sessionInterval")
    private Integer sessionInterval;
    @XmlElement(name="rememberMeInterval")
    private Integer rememberMeInterval;
    @XmlElement(name="hashAnonymization")
    private Boolean hashAnonymization;
    @XmlElement(name="captchaPublicKey")
    private String captchaPublicKey;
    @XmlElement(name="captchaPrivateKey")
    private String captchaPrivateKey;
    @XmlElement(name="debugCategories")
    private List<String> debugCategories;

    public InternalSettingsJSON() {
    }

    public InternalSettingsJSON(@NotNull InternalSettings that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setTokenInterval(that.getTokenInterval());
        this.setSessionInterval(that.getSessionInterval());
        this.setRememberMeInterval(that.getRememberMeInterval());
        this.setHashAnonymization(that.isHashAnonymization());
        this.setCaptchaPublicKey(that.getCaptchaPublicKey());
        this.setCaptchaPrivateKey(that.getCaptchaPrivateKey());
    }

    public Integer getSessionInterval() {
        return this.sessionInterval;
    }

    public Integer getRememberMeInterval() {
        return this.rememberMeInterval;
    }

    public Boolean isHashAnonymization() {
        return this.hashAnonymization;
    }

    public Iterable<String> getDebugCategories() {
        return this.debugCategories;
    }

    @Nullable
    public String getCaptchaPublicKey() {
        return this.captchaPublicKey;
    }

    @Nullable
    public String getCaptchaPrivateKey() {
        return this.captchaPrivateKey;
    }

    @XmlTransient
    public void setSessionInterval(@Nullable Integer sessionInterval) {
        this.sessionInterval = sessionInterval;
    }

    @XmlTransient
    public void setRememberMeInterval(@Nullable Integer rememberMeInterval) {
        this.rememberMeInterval = rememberMeInterval;
    }

    @XmlTransient
    public void setHashAnonymization(Boolean hashAnonymization) {
        this.hashAnonymization = hashAnonymization;
    }

    @XmlTransient
    public void setCaptchaPublicKey(@Nullable String captchaPublicKey) {
        this.captchaPublicKey = captchaPublicKey;
    }

    @XmlTransient
    public void setCaptchaPrivateKey(@Nullable String captchaPrivateKey) {
        this.captchaPrivateKey = captchaPrivateKey;
    }

    public void setDebugCategories(@Nullable Iterable<String> debugCategories) {
        this.debugCategories = JsonUtils.iterableToList(debugCategories);
    }

    public Integer getTokenInterval() {
        return this.tokenInterval;
    }

    @XmlTransient
    public void setTokenInterval(Integer tokenInterval) {
        this.tokenInterval = tokenInterval;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalSettings)) {
            return false;
        }
        InternalSettings that = (InternalSettings)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static InternalSettingsJSON wrap(@NotNull InternalSettings that) {
        if (that instanceof InternalSettingsJSON) {
            return (InternalSettingsJSON)that;
        }
        return new InternalSettingsJSON(that);
    }
}

