/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.LicenseInfoJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="license")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeName(value="license")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=LicenseJSON.class)
public class LicenseJSON
extends SettingsJSON
implements LicenseSettings {
    @XmlElement(name="licenseKey")
    private String licenseKey;
    @XmlElement(name="licenseName")
    private String licenseName;
    @XmlElement(name="service")
    private ServiceJSON service;
    @XmlElement(name="users")
    private List<UserJSON> users;
    @XmlElement(name="autoJoinGroups")
    private List<UserGroupJSON> autoJoinGroups;
    @XmlElement(name="licenseInfo")
    private LicenseInfoJSON licenseInfo;
    @XmlElement(name="availableLicenses")
    private Integer availableLicenses;

    public LicenseJSON() {
    }

    public LicenseJSON(@NotNull LicenseSettings that) {
        AuthorityHolderJSON ref;
        ArrayList<UserJSON> references;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setLicenseKey(that.getLicenseKey());
        this.setLicenseName(that.getLicenseName());
        if (that.getService() != null) {
            ServiceJSON ref2 = new ServiceJSON();
            ref2.setId(that.getService().getId());
            this.setService(ref2);
        }
        if (that.getUsers() != null) {
            references = new ArrayList<UserJSON>();
            for (Alias it : that.getUsers()) {
                ref = new UserJSON();
                ref.setId(it.getId());
                references.add((UserJSON)ref);
            }
            this.setUsers(references);
        }
        if (that.getAutoJoinGroups() != null) {
            references = new ArrayList();
            for (Alias it : that.getAutoJoinGroups()) {
                ref = new UserGroupJSON();
                ref.setId(it.getId());
                references.add((UserJSON)ref);
            }
            this.setAutoJoinGroups(references);
        }
        if (that.getLicenseInfo() != null) {
            this.setLicenseInfo(new LicenseInfoJSON(that.getLicenseInfo()));
        }
        this.setAvailableLicenses(that.getAvailableLicenses());
    }

    @Nullable
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Nullable
    public String getLicenseName() {
        return this.licenseName;
    }

    @Nullable
    public ServiceJSON getService() {
        return this.service;
    }

    @Nullable
    public Iterable<UserJSON> getUsers() {
        return this.users;
    }

    @Nullable
    public Iterable<UserGroupJSON> getAutoJoinGroups() {
        return this.autoJoinGroups;
    }

    @Nullable
    public LicenseInfoJSON getLicenseInfo() {
        return this.licenseInfo;
    }

    @Nullable
    public Integer getAvailableLicenses() {
        return this.availableLicenses;
    }

    @XmlTransient
    public void setLicenseKey(@Nullable String licenseKey) {
        this.licenseKey = licenseKey;
    }

    @XmlTransient
    public void setLicenseName(@Nullable String licenseName) {
        this.licenseName = licenseName;
    }

    @XmlTransient
    public void setService(@Nullable ServiceJSON service) {
        this.service = service;
    }

    @XmlTransient
    public void setUsers(@Nullable Iterable<UserJSON> users) {
        this.users = JsonUtils.iterableToList(users);
    }

    @XmlTransient
    public void setAutoJoinGroups(@Nullable Iterable<UserGroupJSON> autoJoinGroups) {
        this.autoJoinGroups = JsonUtils.iterableToList(autoJoinGroups);
    }

    @XmlTransient
    public void setLicenseInfo(@Nullable LicenseInfoJSON licenseInfo) {
        this.licenseInfo = licenseInfo;
    }

    @XmlTransient
    public void setAvailableLicenses(@Nullable Integer availableLicenses) {
        this.availableLicenses = availableLicenses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LicenseSettings)) {
            return false;
        }
        LicenseSettings that = (LicenseSettings)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static LicenseJSON wrap(@NotNull LicenseSettings that) {
        if (that instanceof LicenseJSON) {
            return (LicenseJSON)that;
        }
        return new LicenseJSON(that);
    }
}

