/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.metrics.Metrics;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.DatabaseJSON;
import jetbrains.jetpass.rest.dto.MemoryJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="metrics")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MetricsJSON
implements Metrics {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="availableProcessors")
    private Integer availableProcessors;
    @XmlElement(name="memory")
    private MemoryJSON memory;
    @XmlElement(name="database")
    private DatabaseJSON database;
    @XmlElement(name="serverStartTime")
    private Long serverStartTime;
    @XmlElement(name="logsFolder")
    private String logsFolder;

    public MetricsJSON() {
    }

    public MetricsJSON(@NotNull Metrics that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setAvailableProcessors(that.getAvailableProcessors());
        if (that.getMemory() != null) {
            this.setMemory(new MemoryJSON(that.getMemory()));
        }
        if (that.getDatabase() != null) {
            this.setDatabase(new DatabaseJSON(that.getDatabase()));
        }
        this.setServerStartTime(that.getServerStartTime());
        this.setLogsFolder(that.getLogsFolder());
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Nullable
    public Integer getAvailableProcessors() {
        return this.availableProcessors;
    }

    @Nullable
    public MemoryJSON getMemory() {
        return this.memory;
    }

    @Nullable
    public DatabaseJSON getDatabase() {
        return this.database;
    }

    @Nullable
    public Long getServerStartTime() {
        return this.serverStartTime;
    }

    @NotNull
    public String getLogsFolder() {
        return this.logsFolder;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = JsonUtils.iterableToList(aliasIds);
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setAvailableProcessors(@Nullable Integer availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    @XmlTransient
    public void setMemory(@Nullable MemoryJSON memory) {
        this.memory = memory;
    }

    @XmlTransient
    public void setDatabase(@Nullable DatabaseJSON database) {
        this.database = database;
    }

    @XmlTransient
    public void setServerStartTime(@Nullable Long serverStartTime) {
        this.serverStartTime = serverStartTime;
    }

    public void setLogsFolder(String logsFolder) {
        this.logsFolder = logsFolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metrics)) {
            return false;
        }
        Metrics that = (Metrics)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static MetricsJSON wrap(@NotNull Metrics that) {
        if (that instanceof MetricsJSON) {
            return (MetricsJSON)that;
        }
        return new MetricsJSON(that);
    }
}

