/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.ProjectTeamMember;
import jetbrains.jetpass.api.authority.VCSUserName;
import jetbrains.jetpass.api.authority.auth.ApprovedScope;
import jetbrains.jetpass.api.authority.auth.PermanentToken;
import jetbrains.jetpass.api.authority.auth.RefreshToken;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ApprovedScopeJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.AvatarJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.PermanentTokenJSON;
import jetbrains.jetpass.rest.dto.ProfileJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.RefreshTokenJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.VcsUserNameJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="projectTeamMember")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ProjectTeamMemberJSON.class)
@JsonTypeName(value="projectTeamMember")
public class ProjectTeamMemberJSON
extends UserJSON
implements ProjectTeamMember {
    @XmlElement(name="teamOwnUser")
    private Boolean teamOwnUser;
    @XmlElement(name="teamGroups")
    private List<UserGroupJSON> teamGroups;

    public ProjectTeamMemberJSON() {
    }

    public ProjectTeamMemberJSON(@NotNull ProjectTeamMember that) {
        Object ref;
        ArrayList<UserGroupJSON> references;
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON((ProjectRole)it)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON((ProjectRole)it)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        this.setLogin(that.getLogin());
        this.setBanned(that.isBanned());
        this.setBanReason(that.getBanReason());
        this.setGuest(that.isGuest());
        if (that.getAvatar() != null) {
            this.setAvatar(new AvatarJSON(that.getAvatar()));
        }
        if (that.getProfile() != null) {
            this.setProfile(new ProfileJSON(that.getProfile()));
        }
        if (that.getGroups() != null) {
            references = new ArrayList<UserGroupJSON>();
            for (Alias it : that.getGroups()) {
                ref = new UserGroupJSON();
                ((AuthorityHolderJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setGroups(references);
        }
        if (that.getTransitiveGroups() != null) {
            references = new ArrayList();
            for (Alias it : that.getTransitiveGroups()) {
                ref = new UserGroupJSON();
                ((AuthorityHolderJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTransitiveGroups(references);
        }
        if (that.getTeams() != null) {
            references = new ArrayList();
            for (Alias it : that.getTeams()) {
                ref = new ProjectTeamJSON();
                ((AuthorityHolderJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTeams(references);
        }
        if (that.getTransitiveTeams() != null) {
            references = new ArrayList();
            for (Alias it : that.getTransitiveTeams()) {
                ref = new ProjectTeamJSON();
                ((AuthorityHolderJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTransitiveTeams(references);
        }
        if (that.getDetails() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getDetails()) {
                aggregated.add((AliasJSON)((Object)new DetailsJSON((UserDetails)it)));
            }
            this.setDetails(aggregated);
        }
        if (that.getVCSUserNames() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getVCSUserNames()) {
                aggregated.add((AliasJSON)((Object)new VcsUserNameJSON((VCSUserName)it)));
            }
            this.setVCSUserNames(aggregated);
        }
        if (that.getLicenses() != null) {
            references = new ArrayList();
            for (Alias it : that.getLicenses()) {
                ref = new LicenseJSON();
                ((SettingsJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setLicenses(references);
        }
        this.setCreationTime(that.getCreationTime());
        this.setLastAccessTime(that.getLastAccessTime());
        if (that.getRefreshTokens() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getRefreshTokens()) {
                aggregated.add((AliasJSON)((Object)new RefreshTokenJSON((RefreshToken)it)));
            }
            this.setRefreshTokens(aggregated);
        }
        if (that.getPermanentTokens() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getPermanentTokens()) {
                aggregated.add((AliasJSON)((Object)new PermanentTokenJSON((PermanentToken)it)));
            }
            this.setPermanentTokens(aggregated);
        }
        if (that.getApprovedScopes() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getApprovedScopes()) {
                aggregated.add((AliasJSON)((Object)new ApprovedScopeJSON((ApprovedScope)it)));
            }
            this.setApprovedScopes(aggregated);
        }
        if (that.getFavoriteProjects() != null) {
            references = new ArrayList();
            for (Alias it : that.getFavoriteProjects()) {
                ref = new ProjectJSON();
                ((ProjectJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setFavoriteProjects(references);
        }
        this.setTeamOwnUser(that.isTeamOwnUser());
        if (that.getTeamGroups() != null) {
            references = new ArrayList();
            for (Alias it : that.getTeamGroups()) {
                ref = new UserGroupJSON();
                ((AuthorityHolderJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTeamGroups(references);
        }
    }

    @Nullable
    public Boolean isTeamOwnUser() {
        return this.teamOwnUser;
    }

    @Nullable
    public Iterable<UserGroupJSON> getTeamGroups() {
        return this.teamGroups;
    }

    @XmlTransient
    public void setTeamOwnUser(@Nullable Boolean teamOwnUser) {
        this.teamOwnUser = teamOwnUser;
    }

    @XmlTransient
    public void setTeamGroups(@Nullable Iterable<UserGroupJSON> teamGroups) {
        this.teamGroups = JsonUtils.iterableToList(teamGroups);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectTeamMember)) {
            return false;
        }
        ProjectTeamMember that = (ProjectTeamMember)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ProjectTeamMemberJSON wrap(@NotNull ProjectTeamMember that) {
        if (that instanceof ProjectTeamMemberJSON) {
            return (ProjectTeamMemberJSON)that;
        }
        return new ProjectTeamMemberJSON(that);
    }
}

