/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="role")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoleJSON
implements Role {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="key")
    private String key;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="teamRole")
    @Deprecated
    private Boolean teamRole;
    @XmlElement(name="permissions")
    private List<PermissionJSON> permissions;

    public RoleJSON() {
    }

    public RoleJSON(@NotNull Role that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setKey(that.getKey());
        this.setName(that.getName());
        this.setDescription(that.getDescription());
        this.setTeamRole(that.isTeamRole());
        if (that.getPermissions() != null) {
            ArrayList<PermissionJSON> references = new ArrayList<PermissionJSON>();
            for (Alias it : that.getPermissions()) {
                PermissionJSON ref = new PermissionJSON();
                ref.setId(it.getId());
                references.add(ref);
            }
            this.setPermissions(references);
        }
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Deprecated
    @Nullable
    public Boolean isTeamRole() {
        return this.teamRole;
    }

    @Nullable
    public Iterable<PermissionJSON> getPermissions() {
        return this.permissions;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = JsonUtils.iterableToList(aliasIds);
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setKey(@Nullable String key) {
        this.key = key;
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Deprecated
    @XmlTransient
    public void setTeamRole(@Nullable Boolean teamRole) {
        this.teamRole = teamRole;
    }

    @XmlTransient
    public void setPermissions(@Nullable Iterable<PermissionJSON> permissions) {
        this.permissions = JsonUtils.iterableToList(permissions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role that = (Role)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static RoleJSON wrap(@NotNull Role that) {
        if (that instanceof RoleJSON) {
            return (RoleJSON)that;
        }
        return new RoleJSON(that);
    }
}

