/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.UntrustedRedirectURI;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.UntrustedRedirectURIJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="service")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ServiceJSON.class)
@JsonTypeName(value="service")
public class ServiceJSON
extends AuthorityHolderJSON
implements Service {
    @XmlElement(name="key")
    private String key;
    @XmlElement(name="homeUrl")
    private String homeUrl;
    @XmlElement(name="baseUrls")
    private List<String> baseUrls;
    @XmlElement(name="userUriPattern")
    private String userUriPattern;
    @XmlElement(name="groupUriPattern")
    private String groupUriPattern;
    @XmlElement(name="redirectUris")
    private List<String> redirectUris;
    @XmlElement(name="untrustedRedirectUris")
    private List<UntrustedRedirectURIJSON> untrustedRedirectUris;
    @XmlElement(name="applicationName")
    private String applicationName;
    @XmlElement(name="vendor")
    private String vendor;
    @XmlElement(name="releaseDate")
    private Calendar releaseDate;
    @XmlElement(name="version")
    private String version;
    @XmlElement(name="iconUrl")
    private String iconUrl;
    @XmlElement(name="resources")
    private List<ResourceJSON> resources;
    @XmlElement(name="permissions")
    private List<PermissionJSON> permissions;
    @XmlElement(name="defaultRoles")
    private List<RoleJSON> defaultRoles;
    @XmlElement(name="headerVisibleGroups")
    private List<UserGroupJSON> headerVisibleGroups;
    @XmlElement(name="viewers")
    private List<AuthorityHolderJSON> viewers;
    @XmlElement(name="licenseSettings")
    private LicenseJSON licenseSettings;
    @XmlElement(name="verified")
    @Deprecated
    private Boolean verified;
    @XmlElement(name="trusted")
    private Boolean trusted;
    @XmlElement(name="secret")
    private String secret;

    public ServiceJSON() {
    }

    public ServiceJSON(@NotNull Service that) {
        AuthorityHolderJSON ref;
        ArrayList<AuthorityHolderJSON> references;
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON((ProjectRole)it)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON((ProjectRole)it)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        this.setKey(that.getKey());
        this.setHomeUrl(that.getHomeUrl());
        this.setBaseUrls(that.getBaseUrls());
        this.setUserUriPattern(that.getUserUriPattern());
        this.setGroupUriPattern(that.getGroupUriPattern());
        this.setRedirectUris(that.getRedirectUris());
        if (that.getUntrustedRedirectUris() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getUntrustedRedirectUris()) {
                aggregated.add((AliasJSON)((Object)new UntrustedRedirectURIJSON((UntrustedRedirectURI)it)));
            }
            this.setUntrustedRedirectUris(aggregated);
        }
        this.setApplicationName(that.getApplicationName());
        this.setVendor(that.getVendor());
        this.setReleaseDate(that.getReleaseDate());
        this.setVersion(that.getVersion());
        this.setIconUrl(that.getIconUrl());
        if (that.getResources() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getResources()) {
                aggregated.add((AliasJSON)((Object)new ResourceJSON((Resource)it)));
            }
            this.setResources(aggregated);
        }
        if (that.getPermissions() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getPermissions()) {
                aggregated.add((AliasJSON)((Object)new PermissionJSON((Permission)it)));
            }
            this.setPermissions(aggregated);
        }
        if (that.getDefaultRoles() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getDefaultRoles()) {
                aggregated.add((AliasJSON)((Object)new RoleJSON((Role)it)));
            }
            this.setDefaultRoles(aggregated);
        }
        if (that.getHeaderVisibleGroups() != null) {
            references = new ArrayList<AuthorityHolderJSON>();
            for (Alias it : that.getHeaderVisibleGroups()) {
                ref = new UserGroupJSON();
                ref.setId(it.getId());
                references.add(ref);
            }
            this.setHeaderVisibleGroups(references);
        }
        if (that.getViewers() != null) {
            references = new ArrayList();
            for (Alias it : that.getViewers()) {
                ref = new AuthorityHolderJSON();
                ref.setId(it.getId());
                references.add(ref);
            }
            this.setViewers(references);
        }
        if (that.getLicenseSettings() != null) {
            LicenseJSON ref2 = new LicenseJSON();
            ref2.setId(that.getLicenseSettings().getId());
            this.setLicenseSettings(ref2);
        }
        this.setVerified(that.isVerified());
        this.setTrusted(that.isTrusted());
        this.setSecret(that.getSecret());
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getHomeUrl() {
        return this.homeUrl;
    }

    @Nullable
    public Iterable<String> getBaseUrls() {
        return this.baseUrls;
    }

    @Nullable
    public String getUserUriPattern() {
        return this.userUriPattern;
    }

    @Nullable
    public String getGroupUriPattern() {
        return this.groupUriPattern;
    }

    @Nullable
    public Iterable<String> getRedirectUris() {
        return this.redirectUris;
    }

    @Nullable
    public Iterable<UntrustedRedirectURIJSON> getUntrustedRedirectUris() {
        return this.untrustedRedirectUris;
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    @Nullable
    public String getVendor() {
        return this.vendor;
    }

    @Nullable
    public Calendar getReleaseDate() {
        return this.releaseDate;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Nullable
    public Iterable<ResourceJSON> getResources() {
        return this.resources;
    }

    @Nullable
    public Iterable<PermissionJSON> getPermissions() {
        return this.permissions;
    }

    @Nullable
    public Iterable<RoleJSON> getDefaultRoles() {
        return this.defaultRoles;
    }

    @Nullable
    public Iterable<UserGroupJSON> getHeaderVisibleGroups() {
        return this.headerVisibleGroups;
    }

    @Nullable
    public Iterable<AuthorityHolderJSON> getViewers() {
        return this.viewers;
    }

    @Nullable
    public LicenseJSON getLicenseSettings() {
        return this.licenseSettings;
    }

    @Deprecated
    @Nullable
    public Boolean isVerified() {
        return this.verified;
    }

    @Nullable
    public Boolean isTrusted() {
        return this.trusted;
    }

    @Nullable
    public String getSecret() {
        return this.secret;
    }

    @XmlTransient
    public void setKey(@Nullable String key) {
        this.key = key;
    }

    @XmlTransient
    public void setHomeUrl(@Nullable String homeUrl) {
        this.homeUrl = homeUrl;
    }

    @XmlTransient
    public void setBaseUrls(@Nullable Iterable<String> baseUrls) {
        this.baseUrls = JsonUtils.iterableToList(baseUrls);
    }

    @XmlTransient
    public void setUserUriPattern(@Nullable String userUriPattern) {
        this.userUriPattern = userUriPattern;
    }

    @XmlTransient
    public void setGroupUriPattern(@Nullable String groupUriPattern) {
        this.groupUriPattern = groupUriPattern;
    }

    @XmlTransient
    public void setRedirectUris(@Nullable Iterable<String> redirectUris) {
        this.redirectUris = JsonUtils.iterableToList(redirectUris);
    }

    @XmlTransient
    public void setUntrustedRedirectUris(@Nullable Iterable<UntrustedRedirectURIJSON> untrustedRedirectUris) {
        this.untrustedRedirectUris = JsonUtils.iterableToList(untrustedRedirectUris);
    }

    @XmlTransient
    public void setApplicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
    }

    @XmlTransient
    public void setVendor(@Nullable String vendor) {
        this.vendor = vendor;
    }

    @XmlTransient
    public void setReleaseDate(@Nullable Calendar releaseDate) {
        this.releaseDate = releaseDate;
    }

    @XmlTransient
    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    @XmlTransient
    public void setIconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @XmlTransient
    public void setResources(@Nullable Iterable<ResourceJSON> resources) {
        this.resources = JsonUtils.iterableToList(resources);
    }

    @XmlTransient
    public void setPermissions(@Nullable Iterable<PermissionJSON> permissions) {
        this.permissions = JsonUtils.iterableToList(permissions);
    }

    @XmlTransient
    public void setDefaultRoles(@Nullable Iterable<RoleJSON> defaultRoles) {
        this.defaultRoles = JsonUtils.iterableToList(defaultRoles);
    }

    @XmlTransient
    public void setHeaderVisibleGroups(@Nullable Iterable<UserGroupJSON> headerVisibleGroups) {
        this.headerVisibleGroups = JsonUtils.iterableToList(headerVisibleGroups);
    }

    @XmlTransient
    public void setViewers(@Nullable Iterable<AuthorityHolderJSON> viewers) {
        this.viewers = JsonUtils.iterableToList(viewers);
    }

    @XmlTransient
    public void setLicenseSettings(@Nullable LicenseJSON licenseSettings) {
        this.licenseSettings = licenseSettings;
    }

    @Deprecated
    @XmlTransient
    public void setVerified(@Nullable Boolean verified) {
        this.verified = verified;
    }

    @XmlTransient
    public void setTrusted(@Nullable Boolean trusted) {
        this.trusted = trusted;
    }

    @XmlTransient
    public void setSecret(@Nullable String secret) {
        this.secret = secret;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Service)) {
            return false;
        }
        Service that = (Service)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ServiceJSON wrap(@NotNull Service that) {
        if (that instanceof ServiceJSON) {
            return (ServiceJSON)that;
        }
        return new ServiceJSON(that);
    }
}

