/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.feature.SystemFeature;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.HubFeatureJSON;
import org.jetbrains.annotations.NotNull;

@XmlRootElement(name="systemFeature")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=SystemFeatureJSON.class)
public class SystemFeatureJSON
extends HubFeatureJSON
implements SystemFeature {
    public SystemFeatureJSON() {
    }

    public SystemFeatureJSON(@NotNull SystemFeature that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setKey(that.getKey());
        this.setName(that.getName());
        this.setDescription(that.getDescription());
        this.setRestartRequired(that.isRestartRequired());
        this.setEnabled(that.isEnabled());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemFeature)) {
            return false;
        }
        SystemFeature that = (SystemFeature)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static SystemFeatureJSON wrap(@NotNull SystemFeature that) {
        if (that instanceof SystemFeatureJSON) {
            return (SystemFeatureJSON)that;
        }
        return new SystemFeatureJSON(that);
    }
}

