/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.security.Team;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="team")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TeamJSON
implements Team {
    @XmlElement(name="role")
    private RoleJSON role;
    @XmlElement(name="users")
    private List<UserJSON> users;
    @XmlElement(name="usersTotal")
    private Integer usersTotal;
    @XmlElement(name="groups")
    private List<UserGroupJSON> groups;
    @XmlElement(name="groupsTotal")
    private Integer groupsTotal;

    public TeamJSON() {
    }

    public TeamJSON(@NotNull Team that) {
        AuthorityHolderJSON ref;
        ArrayList<UserJSON> references;
        if (that.getRole() != null) {
            RoleJSON ref2 = new RoleJSON();
            ref2.setId(that.getRole().getId());
            this.setRole(ref2);
        }
        if (that.getUsers() != null) {
            references = new ArrayList<UserJSON>();
            for (User it : that.getUsers()) {
                ref = new UserJSON();
                ref.setId(it.getId());
                references.add((UserJSON)ref);
            }
            this.setUsers(references);
        }
        this.setUsersTotal(that.getUsersTotal());
        if (that.getGroups() != null) {
            references = new ArrayList();
            for (User it : that.getGroups()) {
                ref = new UserGroupJSON();
                ref.setId(it.getId());
                references.add((UserJSON)ref);
            }
            this.setGroups(references);
        }
        this.setGroupsTotal(that.getGroupsTotal());
    }

    @Nullable
    public RoleJSON getRole() {
        return this.role;
    }

    @Nullable
    public Iterable<UserJSON> getUsers() {
        return this.users;
    }

    @Nullable
    public Integer getUsersTotal() {
        return this.usersTotal;
    }

    @Nullable
    public Iterable<UserGroupJSON> getGroups() {
        return this.groups;
    }

    @Nullable
    public Integer getGroupsTotal() {
        return this.groupsTotal;
    }

    @XmlTransient
    public void setRole(@Nullable RoleJSON role) {
        this.role = role;
    }

    @XmlTransient
    public void setUsers(@Nullable Iterable<UserJSON> users) {
        this.users = JsonUtils.iterableToList(users);
    }

    @XmlTransient
    public void setUsersTotal(@Nullable Integer usersTotal) {
        this.usersTotal = usersTotal;
    }

    @XmlTransient
    public void setGroups(@Nullable Iterable<UserGroupJSON> groups) {
        this.groups = JsonUtils.iterableToList(groups);
    }

    @XmlTransient
    public void setGroupsTotal(@Nullable Integer groupsTotal) {
        this.groupsTotal = groupsTotal;
    }

    @NotNull
    public static TeamJSON wrap(@NotNull Team that) {
        if (that instanceof TeamJSON) {
            return (TeamJSON)that;
        }
        return new TeamJSON(that);
    }
}

