/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.dashboard.UserDashboardPermission;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.DashboardPermissionJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="userDashboardPermission")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=UserDashboardPermissionJSON.class)
public class UserDashboardPermissionJSON
extends DashboardPermissionJSON
implements UserDashboardPermission {
    @XmlElement(name="user")
    private UserJSON user;

    public UserDashboardPermissionJSON() {
    }

    public UserDashboardPermissionJSON(@NotNull UserDashboardPermission that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setPermission(that.getPermission());
        if (that.getUser() != null) {
            UserJSON ref = new UserJSON();
            ref.setId(that.getUser().getId());
            this.setUser(ref);
        }
    }

    @Nullable
    public UserJSON getUser() {
        return this.user;
    }

    @XmlTransient
    public void setUser(@Nullable UserJSON user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserDashboardPermission)) {
            return false;
        }
        UserDashboardPermission that = (UserDashboardPermission)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static UserDashboardPermissionJSON wrap(@NotNull UserDashboardPermission that) {
        if (that instanceof UserDashboardPermissionJSON) {
            return (UserDashboardPermissionJSON)that;
        }
        return new UserDashboardPermissionJSON(that);
    }
}

