/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="userGroup")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=UserGroupJSON.class)
@JsonTypeName(value="userGroup")
public class UserGroupJSON
extends AuthorityHolderJSON
implements UserGroup {
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="iconUrl")
    private String iconUrl;
    @XmlElement(name="autoJoin")
    private Boolean autoJoin;
    @XmlElement(name="requiredTwoFactorAuthentication")
    private Boolean requiredTwoFactorAuthentication;
    @XmlElement(name="users")
    private List<UserJSON> users;
    @XmlElement(name="ownUsers")
    private List<UserJSON> ownUsers;
    @XmlElement(name="userCount")
    private Integer userCount;
    @XmlElement(name="parent")
    private UserGroupJSON parent;
    @XmlElement(name="subgroups")
    private List<UserGroupJSON> subgroups;
    @XmlElement(name="teams")
    private List<ProjectTeamJSON> teams;
    @XmlElement(name="project")
    private ProjectJSON project;
    @XmlElement(name="allUsers")
    private Boolean allUsers;
    @XmlElement(name="implicit")
    private Boolean implicit;
    @XmlElement(name="queriedSingleton")
    private Boolean queriedSingleton;

    public UserGroupJSON() {
    }

    public UserGroupJSON(@NotNull UserGroup that) {
        Object ref;
        AuthorityHolderJSON ref2;
        ArrayList<UserJSON> references;
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON((ProjectRole)it)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON((ProjectRole)it)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        this.setDescription(that.getDescription());
        this.setIconUrl(that.getIconUrl());
        this.setAutoJoin(that.isAutoJoin());
        this.setRequiredTwoFactorAuthentication(that.isRequiredTwoFactorAuthentication());
        if (that.getUsers() != null) {
            references = new ArrayList<UserJSON>();
            for (Alias it : that.getUsers()) {
                ref2 = new UserJSON();
                ref2.setId(it.getId());
                references.add((UserJSON)ref2);
            }
            this.setUsers(references);
        }
        if (that.getOwnUsers() != null) {
            references = new ArrayList();
            for (Alias it : that.getOwnUsers()) {
                ref2 = new UserJSON();
                ref2.setId(it.getId());
                references.add((UserJSON)ref2);
            }
            this.setOwnUsers(references);
        }
        this.setUserCount(that.getUserCount());
        if (that.getParent() != null) {
            ref = new UserGroupJSON();
            ((AuthorityHolderJSON)ref).setId(that.getParent().getId());
            this.setParent((UserGroupJSON)ref);
        }
        if (that.getSubgroups() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getSubgroups()) {
                aggregated.add((AliasJSON)((Object)new UserGroupJSON((UserGroup)it)));
            }
            this.setSubgroups(aggregated);
        }
        if (that.getTeams() != null) {
            references = new ArrayList();
            for (Alias it : that.getTeams()) {
                ref2 = new ProjectTeamJSON();
                ref2.setId(it.getId());
                references.add((UserJSON)ref2);
            }
            this.setTeams(references);
        }
        if (that.getProject() != null) {
            ref = new ProjectJSON();
            ((ProjectJSON)ref).setId(that.getProject().getId());
            this.setProject((ProjectJSON)ref);
        }
        this.setAllUsers(that.isAllUsers());
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Nullable
    public Boolean isAutoJoin() {
        return this.autoJoin;
    }

    public Boolean isRequiredTwoFactorAuthentication() {
        return this.requiredTwoFactorAuthentication;
    }

    @Nullable
    public Iterable<UserJSON> getUsers() {
        return this.users;
    }

    @Nullable
    public Iterable<UserJSON> getOwnUsers() {
        return this.ownUsers;
    }

    @Nullable
    public Integer getUserCount() {
        return this.userCount;
    }

    @Nullable
    public UserGroupJSON getParent() {
        return this.parent;
    }

    @Nullable
    public Iterable<UserGroupJSON> getSubgroups() {
        return this.subgroups;
    }

    @Nullable
    public Iterable<ProjectTeamJSON> getTeams() {
        return this.teams;
    }

    @Nullable
    public ProjectJSON getProject() {
        return this.project;
    }

    @Nullable
    public Boolean isAllUsers() {
        return this.allUsers;
    }

    @Nullable
    public Boolean isImplicit() {
        return this.implicit;
    }

    @Nullable
    public Boolean isQueriedSingleton() {
        return this.queriedSingleton;
    }

    @XmlTransient
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @XmlTransient
    public void setIconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @XmlTransient
    public void setAutoJoin(@Nullable Boolean autoJoin) {
        this.autoJoin = autoJoin;
    }

    @XmlTransient
    public void setRequiredTwoFactorAuthentication(Boolean requiredTwoFactorAuthentication) {
        this.requiredTwoFactorAuthentication = requiredTwoFactorAuthentication;
    }

    @XmlTransient
    public void setUsers(@Nullable Iterable<UserJSON> users) {
        this.users = JsonUtils.iterableToList(users);
    }

    @XmlTransient
    public void setOwnUsers(@Nullable Iterable<UserJSON> ownUsers) {
        this.ownUsers = JsonUtils.iterableToList(ownUsers);
    }

    @XmlTransient
    public void setUserCount(@Nullable Integer userCount) {
        this.userCount = userCount;
    }

    @XmlTransient
    public void setParent(@Nullable UserGroupJSON parent) {
        this.parent = parent;
    }

    @XmlTransient
    public void setSubgroups(@Nullable Iterable<UserGroupJSON> subgroups) {
        this.subgroups = JsonUtils.iterableToList(subgroups);
    }

    @XmlTransient
    public void setTeams(@Nullable Iterable<ProjectTeamJSON> teams) {
        this.teams = JsonUtils.iterableToList(teams);
    }

    @XmlTransient
    public void setProject(@Nullable ProjectJSON project) {
        this.project = project;
    }

    @XmlTransient
    public void setAllUsers(@Nullable Boolean allUsers) {
        this.allUsers = allUsers;
    }

    @XmlTransient
    public void setImplicit(@Nullable Boolean implicit) {
        this.implicit = implicit;
    }

    @XmlTransient
    public void setQueriedSingleton(@Nullable Boolean queriedSingleton) {
        this.queriedSingleton = queriedSingleton;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserGroup)) {
            return false;
        }
        UserGroup that = (UserGroup)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static UserGroupJSON wrap(@NotNull UserGroup that) {
        if (that instanceof UserGroupJSON) {
            return (UserGroupJSON)that;
        }
        return new UserGroupJSON(that);
    }
}

