/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.VCSUserName;
import jetbrains.jetpass.api.authority.auth.ApprovedScope;
import jetbrains.jetpass.api.authority.auth.PermanentToken;
import jetbrains.jetpass.api.authority.auth.RefreshToken;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.authority.totp.ApplicationPassword;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ApplicationPasswordJSON;
import jetbrains.jetpass.rest.dto.ApprovedScopeJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.AvatarJSON;
import jetbrains.jetpass.rest.dto.ContactJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.EndUserAgreementConsentJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.PermanentTokenJSON;
import jetbrains.jetpass.rest.dto.ProfileJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.RefreshTokenJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.SshPublicKeyJSON;
import jetbrains.jetpass.rest.dto.TwoFactorAuthenticationJSON;
import jetbrains.jetpass.rest.dto.TwoFactorAuthenticationSecretJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.VcsUserNameJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="user")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=UserJSON.class)
@JsonTypeName(value="user")
public class UserJSON
extends AuthorityHolderJSON
implements User {
    @XmlElement(name="login")
    private String login;
    @XmlElement(name="banned")
    private Boolean banned;
    @XmlElement(name="banReason")
    private String banReason;
    @XmlElement(name="guest")
    private Boolean guest;
    @XmlElement(name="avatar")
    private AvatarJSON avatar;
    @XmlElement(name="profile")
    private ProfileJSON profile;
    @XmlElement(name="contacts")
    private List<ContactJSON> contacts;
    @XmlElement(name="groups")
    private List<UserGroupJSON> groups;
    @XmlElement(name="transitiveGroups")
    private List<UserGroupJSON> transitiveGroups;
    @XmlElement(name="teams")
    private List<ProjectTeamJSON> teams;
    @XmlElement(name="transitiveTeams")
    private List<ProjectTeamJSON> transitiveTeams;
    @XmlElement(name="details")
    private List<DetailsJSON> details;
    @XmlElement(name="VCSUserNames")
    private List<VcsUserNameJSON> VCSUserNames;
    @XmlElement(name="sshPublicKeys")
    private List<SshPublicKeyJSON> sshPublicKeys;
    @XmlElement(name="licenses")
    private List<LicenseJSON> licenses;
    @XmlElement(name="creationTime")
    private Calendar creationTime;
    @XmlElement(name="lastAccessTime")
    private Calendar lastAccessTime;
    @XmlElement(name="refreshTokens")
    private List<RefreshTokenJSON> refreshTokens;
    @XmlElement(name="permanentTokens")
    private List<PermanentTokenJSON> permanentTokens;
    @XmlElement(name="approvedScopes")
    private List<ApprovedScopeJSON> approvedScopes;
    @XmlElement(name="applicationPasswords")
    private List<ApplicationPasswordJSON> applicationPasswords;
    @XmlElement(name="favoriteProjects")
    private List<ProjectJSON> favoriteProjects;
    @XmlElement(name="endUserAgreementConsent")
    private EndUserAgreementConsentJSON endUserAgreementConsent;
    @XmlElement(name="eraseTimestamp")
    private Calendar eraseTimestamp;
    @XmlElement(name="twoFactorAuthentication")
    private TwoFactorAuthenticationJSON twoFactorAuthentication;
    @XmlElement(name="requiredTwoFactorAuthentication")
    private Boolean requiredTwoFactorAuthentication;
    @XmlElement(name="pendingTwoFactorAuthentication")
    private TwoFactorAuthenticationSecretJSON pendingTwoFactorAuthentication;

    public UserJSON() {
    }

    public UserJSON(@NotNull User that) {
        Object ref;
        ArrayList<UserGroupJSON> references;
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON((ProjectRole)it)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON((ProjectRole)it)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
        this.setLogin(that.getLogin());
        this.setBanned(that.isBanned());
        this.setBanReason(that.getBanReason());
        this.setGuest(that.isGuest());
        if (that.getAvatar() != null) {
            this.setAvatar(new AvatarJSON(that.getAvatar()));
        }
        if (that.getProfile() != null) {
            this.setProfile(new ProfileJSON(that.getProfile()));
        }
        if (that.getGroups() != null) {
            references = new ArrayList<UserGroupJSON>();
            for (Alias it : that.getGroups()) {
                ref = new UserGroupJSON();
                ((AuthorityHolderJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setGroups(references);
        }
        if (that.getTransitiveGroups() != null) {
            references = new ArrayList();
            for (Alias it : that.getTransitiveGroups()) {
                ref = new UserGroupJSON();
                ((AuthorityHolderJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTransitiveGroups(references);
        }
        if (that.getTeams() != null) {
            references = new ArrayList();
            for (Alias it : that.getTeams()) {
                ref = new ProjectTeamJSON();
                ((AuthorityHolderJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTeams(references);
        }
        if (that.getTransitiveTeams() != null) {
            references = new ArrayList();
            for (Alias it : that.getTransitiveTeams()) {
                ref = new ProjectTeamJSON();
                ((AuthorityHolderJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setTransitiveTeams(references);
        }
        if (that.getDetails() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getDetails()) {
                aggregated.add((AliasJSON)((Object)new DetailsJSON((UserDetails)it)));
            }
            this.setDetails(aggregated);
        }
        if (that.getVCSUserNames() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getVCSUserNames()) {
                aggregated.add((AliasJSON)((Object)new VcsUserNameJSON((VCSUserName)it)));
            }
            this.setVCSUserNames(aggregated);
        }
        if (that.getLicenses() != null) {
            references = new ArrayList();
            for (Alias it : that.getLicenses()) {
                ref = new LicenseJSON();
                ((SettingsJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setLicenses(references);
        }
        this.setCreationTime(that.getCreationTime());
        this.setLastAccessTime(that.getLastAccessTime());
        if (that.getRefreshTokens() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getRefreshTokens()) {
                aggregated.add((AliasJSON)((Object)new RefreshTokenJSON((RefreshToken)it)));
            }
            this.setRefreshTokens(aggregated);
        }
        if (that.getPermanentTokens() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getPermanentTokens()) {
                aggregated.add((AliasJSON)((Object)new PermanentTokenJSON((PermanentToken)it)));
            }
            this.setPermanentTokens(aggregated);
        }
        if (that.getApprovedScopes() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getApprovedScopes()) {
                aggregated.add((AliasJSON)((Object)new ApprovedScopeJSON((ApprovedScope)it)));
            }
            this.setApprovedScopes(aggregated);
        }
        if (that.getApplicationPasswords() != null) {
            aggregated = new ArrayList();
            for (Alias it : that.getApplicationPasswords()) {
                aggregated.add((AliasJSON)((Object)new ApplicationPasswordJSON((ApplicationPassword)it)));
            }
            this.setApplicationPasswords(aggregated);
        }
        if (that.getFavoriteProjects() != null) {
            references = new ArrayList();
            for (Alias it : that.getFavoriteProjects()) {
                ref = new ProjectJSON();
                ((ProjectJSON)ref).setId(it.getId());
                references.add((UserGroupJSON)ref);
            }
            this.setFavoriteProjects(references);
        }
        if (that.getEndUserAgreementConsent() != null) {
            this.setEndUserAgreementConsent(EndUserAgreementConsentJSON.wrap(that.getEndUserAgreementConsent()));
        }
        if (that.getEraseTimestamp() != null) {
            this.setEraseTimestamp(that.getEraseTimestamp());
        }
        if (that.getTwoFactorAuthentication() != null) {
            this.setTwoFactorAuthentication(TwoFactorAuthenticationJSON.wrap(that.getTwoFactorAuthentication()));
        }
        this.requiredTwoFactorAuthentication = that.isRequiredTwoFactorAuthentication();
        if (that.getPendingTwoFactorAuthentication() != null) {
            this.setPendingTwoFactorAuthentication(TwoFactorAuthenticationSecretJSON.wrap(that.getPendingTwoFactorAuthentication()));
        }
    }

    @Nullable
    public String getLogin() {
        return this.login;
    }

    @Nullable
    public Boolean isBanned() {
        return this.banned;
    }

    @Nullable
    public String getBanReason() {
        return this.banReason;
    }

    @Nullable
    public Boolean isGuest() {
        return this.guest;
    }

    @Nullable
    public AvatarJSON getAvatar() {
        return this.avatar;
    }

    @Nullable
    public ProfileJSON getProfile() {
        return this.profile;
    }

    @Nullable
    public Iterable<ContactJSON> getContacts() {
        return this.contacts;
    }

    @Nullable
    public Iterable<UserGroupJSON> getGroups() {
        return this.groups;
    }

    public Iterable<UserGroupJSON> getTransitiveGroups() {
        return this.transitiveGroups;
    }

    @Nullable
    public Iterable<ProjectTeamJSON> getTeams() {
        return this.teams;
    }

    @Nullable
    public Iterable<ProjectTeamJSON> getTransitiveTeams() {
        return this.transitiveTeams;
    }

    @Nullable
    public Iterable<DetailsJSON> getDetails() {
        return this.details;
    }

    @Nullable
    public Iterable<VcsUserNameJSON> getVCSUserNames() {
        return this.VCSUserNames;
    }

    @Nullable
    public Iterable<SshPublicKeyJSON> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    @Nullable
    public Iterable<LicenseJSON> getLicenses() {
        return this.licenses;
    }

    @Nullable
    public Calendar getCreationTime() {
        return this.creationTime;
    }

    @Nullable
    public Calendar getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Nullable
    public Iterable<RefreshTokenJSON> getRefreshTokens() {
        return this.refreshTokens;
    }

    @Nullable
    public Iterable<PermanentTokenJSON> getPermanentTokens() {
        return this.permanentTokens;
    }

    @Nullable
    public Iterable<ApprovedScopeJSON> getApprovedScopes() {
        return this.approvedScopes;
    }

    public List<ApplicationPasswordJSON> getApplicationPasswords() {
        return this.applicationPasswords;
    }

    @Nullable
    public Iterable<ProjectJSON> getFavoriteProjects() {
        return this.favoriteProjects;
    }

    public EndUserAgreementConsentJSON getEndUserAgreementConsent() {
        return this.endUserAgreementConsent;
    }

    @Nullable
    public Calendar getEraseTimestamp() {
        return this.eraseTimestamp;
    }

    public TwoFactorAuthenticationJSON getTwoFactorAuthentication() {
        return this.twoFactorAuthentication;
    }

    public Boolean isRequiredTwoFactorAuthentication() {
        return this.requiredTwoFactorAuthentication;
    }

    @Nullable
    public TwoFactorAuthenticationSecretJSON getPendingTwoFactorAuthentication() {
        return this.pendingTwoFactorAuthentication;
    }

    @XmlTransient
    public void setLogin(@Nullable String login) {
        this.login = login;
    }

    @XmlTransient
    public void setBanned(@Nullable Boolean banned) {
        this.banned = banned;
    }

    @XmlTransient
    public void setBanReason(@Nullable String banReason) {
        this.banReason = banReason;
    }

    @XmlTransient
    public void setGuest(@Nullable Boolean guest) {
        this.guest = guest;
    }

    @XmlTransient
    public void setAvatar(@Nullable AvatarJSON avatar) {
        this.avatar = avatar;
    }

    @XmlTransient
    public void setProfile(@Nullable ProfileJSON profile) {
        this.profile = profile;
    }

    @XmlTransient
    public void setContacts(@Nullable Iterable<ContactJSON> contacts) {
        this.contacts = JsonUtils.iterableToList(contacts);
    }

    @XmlTransient
    public void setGroups(@Nullable Iterable<UserGroupJSON> groups) {
        this.groups = JsonUtils.iterableToList(groups);
    }

    @XmlTransient
    public void setTransitiveGroups(@Nullable Iterable<UserGroupJSON> groups) {
        this.transitiveGroups = JsonUtils.iterableToList(groups);
    }

    @XmlTransient
    public void setTeams(@Nullable Iterable<ProjectTeamJSON> teams) {
        this.teams = JsonUtils.iterableToList(teams);
    }

    @XmlTransient
    public void setTransitiveTeams(@Nullable Iterable<ProjectTeamJSON> transitiveTeams) {
        this.transitiveTeams = JsonUtils.iterableToList(transitiveTeams);
    }

    @XmlTransient
    public void setDetails(@Nullable Iterable<DetailsJSON> details) {
        this.details = JsonUtils.iterableToList(details);
    }

    @XmlTransient
    public void setVCSUserNames(@Nullable Iterable<VcsUserNameJSON> VCSUserNames) {
        this.VCSUserNames = JsonUtils.iterableToList(VCSUserNames);
    }

    @XmlTransient
    public void setSshPublicKeys(@Nullable Iterable<SshPublicKeyJSON> sshPublicKeys) {
        this.sshPublicKeys = JsonUtils.iterableToList(sshPublicKeys);
    }

    @XmlTransient
    public void setLicenses(@Nullable Iterable<LicenseJSON> licenses) {
        this.licenses = JsonUtils.iterableToList(licenses);
    }

    @XmlTransient
    public void setCreationTime(@Nullable Calendar creationTime) {
        this.creationTime = creationTime;
    }

    @XmlTransient
    public void setLastAccessTime(@Nullable Calendar lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @XmlTransient
    public void setRefreshTokens(@Nullable Iterable<RefreshTokenJSON> refreshTokens) {
        this.refreshTokens = JsonUtils.iterableToList(refreshTokens);
    }

    @XmlTransient
    public void setPermanentTokens(@Nullable Iterable<PermanentTokenJSON> permanentTokens) {
        this.permanentTokens = JsonUtils.iterableToList(permanentTokens);
    }

    @XmlTransient
    public void setApprovedScopes(@Nullable Iterable<ApprovedScopeJSON> approvedScopes) {
        this.approvedScopes = JsonUtils.iterableToList(approvedScopes);
    }

    @XmlTransient
    public void setApplicationPasswords(@Nullable Iterable<ApplicationPasswordJSON> applicationPasswords) {
        this.applicationPasswords = JsonUtils.iterableToList(applicationPasswords);
    }

    @XmlTransient
    public void setFavoriteProjects(@Nullable Iterable<ProjectJSON> favoriteProjects) {
        this.favoriteProjects = JsonUtils.iterableToList(favoriteProjects);
    }

    @XmlTransient
    public void setEndUserAgreementConsent(EndUserAgreementConsentJSON endUserAgreementConsent) {
        this.endUserAgreementConsent = endUserAgreementConsent;
    }

    @XmlTransient
    public void setEraseTimestamp(Calendar eraseTimestamp) {
        this.eraseTimestamp = eraseTimestamp;
    }

    @XmlTransient
    public void setTwoFactorAuthentication(TwoFactorAuthenticationJSON twoFactorAuthentication) {
        this.twoFactorAuthentication = twoFactorAuthentication;
    }

    @XmlTransient
    public void setRequiredTwoFactorAuthentication(Boolean require) {
        this.requiredTwoFactorAuthentication = require;
    }

    @XmlTransient
    public void setPendingTwoFactorAuthentication(TwoFactorAuthenticationSecretJSON pendingTwoFactorAuthentication) {
        this.pendingTwoFactorAuthentication = pendingTwoFactorAuthentication;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User that = (User)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static UserJSON wrap(@NotNull User that) {
        if (that instanceof UserJSON) {
            return (UserJSON)that;
        }
        return new UserJSON(that);
    }
}

