/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.widget.Widget;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.UuidJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="widget")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=WidgetJSON.class)
public class WidgetJSON
extends UuidJSON
implements Widget {
    @XmlElement(name="key")
    private String key;
    @XmlElement(name="version")
    private String version;
    @XmlElement(name="installedVersion")
    private String installedVersion;
    @XmlElement(name="latestVersion")
    private String latestVersion;
    @XmlElement(name="installedFromRepository")
    private Boolean installedFromRepository;
    @XmlElement(name="archiveId")
    private String archiveId;
    @XmlElement(name="manifest")
    @JsonRawValue
    private String manifest;
    @XmlElement(name="owner")
    private UserJSON owner;
    @XmlElement(name="disabled")
    private Boolean disabled;
    @XmlElement(name="applicationNames")
    private List<String> applicationNames;
    @XmlElement(name="accessibleServices")
    private List<ServiceJSON> accessibleServices;
    @XmlElement(name="capabilities")
    private List<String> capabilities;
    @XmlElement(name="repositoryUrl")
    private String repositoryUrl;
    @XmlElement(name="repositoryIconUrl")
    private String repositoryIconUrl;

    public WidgetJSON() {
    }

    public WidgetJSON(@NotNull Widget that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias it : that.getAliases()) {
                aggregated.add(new AliasJSON(it));
            }
            this.setAliases(aggregated);
        }
        this.setKey(that.getKey());
        this.setVersion(that.getVersion());
        this.setInstalledVersion(that.getInstalledVersion());
        this.setLatestVersion(that.getLatestVersion());
        this.setArchiveId(that.getArchiveId());
        this.setManifest(that.getManifest());
        if (that.getOwner() != null) {
            UserJSON ref = new UserJSON();
            ref.setId(that.getOwner().getId());
            this.setOwner(ref);
        }
        this.setDisabled(that.isDisabled());
        this.setApplicationNames(that.getApplicationNames());
        if (that.getAccessibleServices() != null) {
            ArrayList<ServiceJSON> references = new ArrayList<ServiceJSON>();
            for (Alias it : that.getAccessibleServices()) {
                ServiceJSON ref = new ServiceJSON();
                ref.setId(it.getId());
                references.add(ref);
            }
            this.setAccessibleServices(references);
        }
        if (that.getCapabilities() != null) {
            ArrayList<String> capabilities = new ArrayList<String>();
            for (String item : that.getCapabilities()) {
                capabilities.add(item);
            }
            this.setCapabilities(capabilities);
        }
        this.setRepositoryUrl(that.getRepositoryUrl());
        this.setRepositoryIconUrl(that.getRepositoryIconUrl());
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getInstalledVersion() {
        return this.installedVersion;
    }

    @Nullable
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Nullable
    public Boolean isInstalledFromRepository() {
        return this.installedFromRepository;
    }

    @Nullable
    public String getArchiveId() {
        return this.archiveId;
    }

    @Nullable
    public String getManifest() {
        return this.manifest;
    }

    @Nullable
    public UserJSON getOwner() {
        return this.owner;
    }

    @Nullable
    public Boolean isDisabled() {
        return this.disabled;
    }

    @Nullable
    public Iterable<String> getApplicationNames() {
        return this.applicationNames;
    }

    @Nullable
    public Iterable<ServiceJSON> getAccessibleServices() {
        return this.accessibleServices;
    }

    @Nullable
    public List<String> getCapabilities() {
        return this.capabilities;
    }

    @Nullable
    public String getRepositoryIconUrl() {
        return this.repositoryIconUrl;
    }

    @XmlTransient
    public void setKey(@Nullable String key) {
        this.key = key;
    }

    @XmlTransient
    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    @XmlTransient
    public void setInstalledVersion(@Nullable String installedVersion) {
        this.installedVersion = installedVersion;
    }

    @XmlTransient
    public void setLatestVersion(@Nullable String latestVersion) {
        this.latestVersion = latestVersion;
    }

    @XmlTransient
    public void setInstalledFromRepository(@Nullable Boolean installedFromRepository) {
        this.installedFromRepository = installedFromRepository;
    }

    @XmlTransient
    public void setArchiveId(@Nullable String archiveId) {
        this.archiveId = archiveId;
    }

    @JsonProperty
    public void setManifest(@Nullable JsonNode manifest) {
        this.manifest = manifest != null ? manifest.toString() : "{}";
    }

    public void setManifest(@Nullable String manifest) {
        this.manifest = manifest;
    }

    @XmlTransient
    public void setOwner(@Nullable UserJSON owner) {
        this.owner = owner;
    }

    @XmlTransient
    public void setDisabled(@Nullable Boolean disabled) {
        this.disabled = disabled;
    }

    @XmlTransient
    public void setApplicationNames(@Nullable Iterable<String> applicationNames) {
        this.applicationNames = JsonUtils.iterableToList(applicationNames);
    }

    @XmlTransient
    public void setAccessibleServices(@Nullable Iterable<ServiceJSON> accessibleServices) {
        this.accessibleServices = JsonUtils.iterableToList(accessibleServices);
    }

    @XmlTransient
    public void setCapabilities(@Nullable Iterable<String> capabilities) {
        this.capabilities = JsonUtils.iterableToList(capabilities);
    }

    @XmlTransient
    public void setRepositoryIconUrl(String repositoryIconUrl) {
        this.repositoryIconUrl = repositoryIconUrl;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @XmlTransient
    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Widget)) {
            return false;
        }
        Widget that = (Widget)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static WidgetJSON wrap(@NotNull Widget that) {
        if (that instanceof WidgetJSON) {
            return (WidgetJSON)that;
        }
        return new WidgetJSON(that);
    }
}

