/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.MetricsFilter;
import software.amazon.awssdk.services.s3.transform.MetricsAndOperatorUnmarshaller;
import software.amazon.awssdk.services.s3.transform.TagUnmarshaller;

public class MetricsFilterUnmarshaller
implements Unmarshaller<MetricsFilter, StaxUnmarshallerContext> {
    private static final MetricsFilterUnmarshaller INSTANCE = new MetricsFilterUnmarshaller();

    public MetricsFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MetricsFilter.Builder metricsFilter = MetricsFilter.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Prefix", targetDepth)) {
                    metricsFilter.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tag", targetDepth)) {
                    metricsFilter.tag(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("And", targetDepth)) continue;
                metricsFilter.and(MetricsAndOperatorUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MetricsFilter)metricsFilter.build();
    }

    public static MetricsFilterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

