/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.FilterRule;
import software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration;
import software.amazon.awssdk.services.s3.model.NotificationConfiguration;
import software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.QueueConfiguration;
import software.amazon.awssdk.services.s3.model.S3KeyFilter;
import software.amazon.awssdk.services.s3.model.TopicConfiguration;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class PutBucketNotificationConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketNotificationConfigurationRequest>, PutBucketNotificationConfigurationRequest> {
    public Request<PutBucketNotificationConfigurationRequest> marshall(PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) {
        if (putBucketNotificationConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketNotificationConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{Bucket}?notification";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketNotificationConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            NotificationConfiguration notificationConfiguration = putBucketNotificationConfigurationRequest.notificationConfiguration();
            if (notificationConfiguration != null) {
                List<LambdaFunctionConfiguration> list;
                List<QueueConfiguration> notificationConfigurationQueueConfigurationsList;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("NotificationConfiguration");
                List<TopicConfiguration> notificationConfigurationTopicConfigurationsList = notificationConfiguration.topicConfigurations();
                if (!notificationConfigurationTopicConfigurationsList.isEmpty() || !(notificationConfigurationTopicConfigurationsList instanceof SdkAutoConstructList)) {
                    for (TopicConfiguration topicConfiguration : notificationConfigurationTopicConfigurationsList) {
                        NotificationConfigurationFilter filter;
                        List<String> topicConfigurationEventsList;
                        xmlWriter.startElement("TopicConfiguration");
                        if (topicConfiguration.id() != null) {
                            xmlWriter.startElement("Id").value(topicConfiguration.id()).endElement();
                        }
                        if (topicConfiguration.topicArn() != null) {
                            xmlWriter.startElement("Topic").value(topicConfiguration.topicArn()).endElement();
                        }
                        if (!(topicConfigurationEventsList = topicConfiguration.eventsAsStrings()).isEmpty() || !(topicConfigurationEventsList instanceof SdkAutoConstructList)) {
                            for (String topicConfigurationEventsListValue : topicConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(topicConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if ((filter = topicConfiguration.filter()) != null) {
                            xmlWriter.startElement("Filter");
                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");
                                List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (!s3KeyFilterFilterRulesList.isEmpty() || !(s3KeyFilterFilterRulesList instanceof SdkAutoConstructList)) {
                                    for (FilterRule filterRule : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");
                                        if (filterRule.nameAsString() != null) {
                                            xmlWriter.startElement("Name").value(filterRule.nameAsString()).endElement();
                                        }
                                        if (filterRule.value() != null) {
                                            xmlWriter.startElement("Value").value(filterRule.value()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                if (!(notificationConfigurationQueueConfigurationsList = notificationConfiguration.queueConfigurations()).isEmpty() || !(notificationConfigurationQueueConfigurationsList instanceof SdkAutoConstructList)) {
                    for (QueueConfiguration notificationConfigurationQueueConfigurationsListValue : notificationConfigurationQueueConfigurationsList) {
                        NotificationConfigurationFilter filter;
                        List<String> queueConfigurationEventsList;
                        xmlWriter.startElement("QueueConfiguration");
                        if (notificationConfigurationQueueConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id").value(notificationConfigurationQueueConfigurationsListValue.id()).endElement();
                        }
                        if (notificationConfigurationQueueConfigurationsListValue.queueArn() != null) {
                            xmlWriter.startElement("Queue").value(notificationConfigurationQueueConfigurationsListValue.queueArn()).endElement();
                        }
                        if (!(queueConfigurationEventsList = notificationConfigurationQueueConfigurationsListValue.eventsAsStrings()).isEmpty() || !(queueConfigurationEventsList instanceof SdkAutoConstructList)) {
                            for (String queueConfigurationEventsListValue : queueConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(queueConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if ((filter = notificationConfigurationQueueConfigurationsListValue.filter()) != null) {
                            xmlWriter.startElement("Filter");
                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");
                                List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (!s3KeyFilterFilterRulesList.isEmpty() || !(s3KeyFilterFilterRulesList instanceof SdkAutoConstructList)) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");
                                        if (s3KeyFilterFilterRulesListValue.nameAsString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameAsString()).endElement();
                                        }
                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                if (!(list = notificationConfiguration.lambdaFunctionConfigurations()).isEmpty() || !(list instanceof SdkAutoConstructList)) {
                    for (LambdaFunctionConfiguration notificationConfigurationLambdaFunctionConfigurationsListValue : list) {
                        NotificationConfigurationFilter filter;
                        List<String> lambdaFunctionConfigurationEventsList;
                        xmlWriter.startElement("CloudFunctionConfiguration");
                        if (notificationConfigurationLambdaFunctionConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id").value(notificationConfigurationLambdaFunctionConfigurationsListValue.id()).endElement();
                        }
                        if (notificationConfigurationLambdaFunctionConfigurationsListValue.lambdaFunctionArn() != null) {
                            xmlWriter.startElement("CloudFunction").value(notificationConfigurationLambdaFunctionConfigurationsListValue.lambdaFunctionArn()).endElement();
                        }
                        if (!(lambdaFunctionConfigurationEventsList = notificationConfigurationLambdaFunctionConfigurationsListValue.eventsAsStrings()).isEmpty() || !(lambdaFunctionConfigurationEventsList instanceof SdkAutoConstructList)) {
                            for (String lambdaFunctionConfigurationEventsListValue : lambdaFunctionConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(lambdaFunctionConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if ((filter = notificationConfigurationLambdaFunctionConfigurationsListValue.filter()) != null) {
                            xmlWriter.startElement("Filter");
                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");
                                List<FilterRule> list2 = key.filterRules();
                                if (!list2.isEmpty() || !(list2 instanceof SdkAutoConstructList)) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : list2) {
                                        xmlWriter.startElement("FilterRule");
                                        if (s3KeyFilterFilterRulesListValue.nameAsString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameAsString()).endElement();
                                        }
                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

