/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.runtime;

import java.io.IOException;
import java.util.Locale;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.LocaleEntry;
import jetbrains.mps.internationalization.runtime.LocaleUtil;
import jetbrains.mps.internationalization.runtime.LocalizationResourceManager;
import jetbrains.mps.internationalization.runtime.Messages;
import jetbrains.mps.internationalization.runtime.MessagesContainer;
import jetbrains.mps.webr.stateless.template.runtime.TemplateBuilderContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import webr.framework.textBuilder.TBuilderContext;

public class Localizer {
    protected static Log log = LogFactory.getLog(Localizer.class);
    private Locale locale = LocaleUtil.DEFAULT_LOCALE;
    private MessagesContainer myMessagesContainer;
    private LocalizationResourceManager myResourceManager;

    public void setLocale(Locale locale) {
        if (locale == null || locale.equals(this.locale)) {
            return;
        }
        this.getResourceManager().reload();
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Iterable<LocaleEntry> getSupportedLocales() {
        return this.getMessagesContainer().getLocales().getSupportedLocales();
    }

    public Iterable<LocaleEntry> getCustomLocales() {
        return this.getMessagesContainer().getLocales().getCustomLocales();
    }

    public Iterable<LocaleEntry> getBundledLocales() {
        return this.getMessagesContainer().getLocales().getBundledLocales();
    }

    public LocaleEntry byLocaleId(final String name) {
        return (LocaleEntry)Sequence.fromIterable(this.getSupportedLocales()).findFirst((_FunctionTypes._return_P1_E0)new IWhereFilter<LocaleEntry>(){

            public boolean accept(LocaleEntry it) {
                return it.getLocale().toString().equals(name);
            }
        });
    }

    @NotNull
    public String localizedMsg(String id, Object ... params) {
        String message = this.getCurrentMessages().getMessage(id, params);
        if (message != null) {
            return message;
        }
        return this.getDefaultMsg(id, params);
    }

    @NotNull
    public String getMsgInLocale(String id, Locale locale, Object ... params) {
        String message = this.getMessages(locale).getMessage(id, params);
        if (message == null) {
            message = this.getDefaultMsg(id, params);
        }
        return message;
    }

    @NotNull
    public String getDefaultMsg(String id, Object ... params) {
        String message = this.getDefaultMessages().getMessage(id, params);
        if (message == null) {
            throw new RuntimeException("No localized entry with id '" + id + "'.");
        }
        return message;
    }

    public void localizedMsgForTemplateContent(String id, TBuilderContext builderContext, Object ... params) {
        if (!this.getCurrentMessages().getMessageForTemplateContent(id, builderContext, params) && !this.getDefaultMessages().getMessageForTemplateContent(id, builderContext, params) && log.isErrorEnabled()) {
            log.error((Object)("No localized entry with id '" + id + "'."), new Throwable());
        }
    }

    public void localizedMsgForStatelessTemplateContent(String id, TemplateBuilderContext builderContext, Object ... params) {
        if (!this.getCurrentMessages().getMessageForStatelessTemplateContent(id, builderContext, params) && !this.getDefaultMessages().getMessageForStatelessTemplateContent(id, builderContext, params) && log.isErrorEnabled()) {
            log.error((Object)("No localized entry with id '" + id + "'."), new Throwable());
        }
    }

    public void reload() {
        try {
            this.getMessagesContainer().reload();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot reload translations", e);
        }
    }

    @NotNull
    private Messages getMessages(Locale locale) {
        Messages result = this.getMessagesContainer().getMessages(locale);
        if (result == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Missing messages container for locale: " + locale));
            }
            return this.getMessagesContainer().getMessages(LocaleUtil.DEFAULT_LOCALE);
        }
        return result;
    }

    private Messages getCurrentMessages() {
        return this.getMessages(this.getLocale());
    }

    @NotNull
    private Messages getDefaultMessages() {
        return this.getMessages(LocaleUtil.DEFAULT_LOCALE);
    }

    public MessagesContainer getMessagesContainer() {
        return this.myMessagesContainer;
    }

    public void setMessagesContainer(MessagesContainer value) {
        this.myMessagesContainer = value;
    }

    public LocalizationResourceManager getResourceManager() {
        return this.myResourceManager;
    }

    public void setResourceManager(LocalizationResourceManager value) {
        this.myResourceManager = value;
    }
}

