/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.BindingUtils;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class LongBinding
extends ComparableBinding {
    public static final LongBinding BINDING = new LongBinding();

    private LongBinding() {
    }

    @Override
    public Long readObject(@NotNull ByteArrayInputStream stream) {
        return BindingUtils.readLong(stream);
    }

    @Override
    public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable object) {
        output.writeUnsignedLong((long)((Long)object ^ Long.MIN_VALUE));
    }

    public static long entryToLong(@NotNull ByteIterable entry) {
        return (Long)BINDING.entryToObject(entry);
    }

    public static ArrayByteIterable longToEntry(long object) {
        return BINDING.objectToEntry(Long.valueOf(object));
    }

    public static long compressedEntryToLong(@NotNull ByteIterable entry) {
        return LongBinding.readCompressed(entry.iterator());
    }

    public static ArrayByteIterable longToCompressedEntry(long object) {
        if (object < 0L) {
            throw new IllegalArgumentException();
        }
        LightOutputStream output = new LightOutputStream(4);
        LongBinding.writeCompressed(output, object);
        return output.asArrayByteIterable();
    }

    public static long compressedEntryToSignedLong(@NotNull ByteIterable entry) {
        long result = LongBinding.compressedEntryToLong(entry);
        return result >> 1 ^ (result & 1L) << 63 >> 63;
    }

    public static ArrayByteIterable signedLongToCompressedEntry(long object) {
        return LongBinding.longToCompressedEntry(object << 1 ^ object >> 63);
    }

    public static void writeUnsignedLong(long l, int bytesPerLong, @NotNull LightOutputStream output) {
        int bits = bytesPerLong << 3;
        while (bits > 0) {
            output.write((int)(l >> (bits -= 8) & 0xFFL));
        }
    }

    public static long entryToUnsignedLong(@NotNull ByteIterator bi, int length) {
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result = (result << 8) + (long)(bi.next() & 0xFF);
        }
        return result;
    }

    public static long entryToUnsignedLong(@NotNull byte[] bytes, int offset, int length) {
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result = (result << 8) + (long)(bytes[offset + i] & 0xFF);
        }
        return result;
    }

    public static long readCompressed(@NotNull ByteIterator iterator) {
        int firstByte = iterator.next() & 0xFF;
        long result = firstByte & 0xF;
        int byteLen = firstByte >> 4;
        while (--byteLen >= 0) {
            result = (result << 8) + (long)(iterator.next() & 0xFF);
        }
        return result;
    }

    public static void writeCompressed(@NotNull LightOutputStream output, long l) {
        LongBinding.writeCompressed(output, l, new int[8]);
    }

    public static void writeCompressed(@NotNull LightOutputStream output, long l, int[] bytes) {
        int upperByte;
        int byteLen;
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (int)(l & 0xFFL);
            l >>= 8;
        }
        for (byteLen = 8; byteLen > 0 && bytes[byteLen - 1] == 0; --byteLen) {
        }
        int firstByte = byteLen << 4;
        if (byteLen > 0 && (upperByte = bytes[byteLen - 1]) < 16) {
            firstByte = ((firstByte >> 4) - 1 << 4) + upperByte;
            --byteLen;
        }
        output.write(firstByte);
        while (--byteLen >= 0) {
            output.write(bytes[byteLen]);
        }
    }
}

