/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.hub.service;

import com.jetbrains.bundle.api.clientcert.ClientCertificateAuthSettingsService;
import com.jetbrains.bundle.api.properties.BundlePropertiesService;
import com.jetbrains.hub.service.HubInternalProperties;
import com.jetbrains.hub.service.updaters.BackupDirectoryUpdaterKt;
import com.jetbrains.hub.service.updaters.BaseUrlUpdaterKt;
import com.jetbrains.hub.service.updaters.ClientCertificateSettingsUpdaterKt;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.contract.callbacks.impl.log4j.AfterStartCallback;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import jetbrains.exodus.entitystore.EventsMultiplexer;
import jetbrains.jetpass.spring.SpringUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0014J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u0010*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\f\u0010\u0015\u001a\u00020\u0011*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\n*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\n*\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\n*\u00020\u00182\u0006\u0010\u001c\u001a\u00020\rH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/hub/service/HubAfterStartCallback;", "Lcom/jetbrains/service/util/contract/callbacks/impl/log4j/AfterStartCallback;", "()V", "eventsMultiplexer", "Ljetbrains/exodus/entitystore/EventsMultiplexer;", "getEventsMultiplexer", "()Ljetbrains/exodus/entitystore/EventsMultiplexer;", "eventsMultiplexer$delegate", "Lkotlin/properties/ReadOnlyProperty;", "doPerform", "", "parameters", "", "", "", "isHubProduct", "", "Ljava/util/Properties;", "isInTheSameProcess", "Lcom/jetbrains/service/util/properties/impl/PropertiesBasedConfigurationHelper;", "properties", "loadPropertiesSafe", "Ljava/io/File;", "subscribeOnBackupSettingsChange", "Lcom/jetbrains/bundle/api/properties/BundlePropertiesService;", "subscribeOnClientCertificateAuthModuleChange", "Lcom/jetbrains/bundle/api/clientcert/ClientCertificateAuthSettingsService;", "subscribeOnServiceHomeUrlSettingChange", "hubContext", "jetbrains.jetpass.ring.bundle.callbacks"})
public final class HubAfterStartCallback
extends AfterStartCallback {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty eventsMultiplexer$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HubAfterStartCallback.class), "eventsMultiplexer", "getEventsMultiplexer()Ljetbrains/exodus/entitystore/EventsMultiplexer;"))};
    }

    private final EventsMultiplexer getEventsMultiplexer() {
        return (EventsMultiplexer)this.eventsMultiplexer$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    protected void doPerform(@NotNull Map<String, ? extends Object> parameters) {
        PropertiesBasedConfigurationHelper helper;
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        File configFile = new File(this.getServiceConfigDirectory(parameters), "service-config.properties");
        Properties properties = this.loadPropertiesSafe(configFile);
        boolean isHubProduct = this.isHubProduct(properties);
        PropertiesBasedConfigurationHelper propertiesBasedConfigurationHelper = helper = PropertiesBasedConfigurationHelper.getHelper();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertiesBasedConfigurationHelper, (String)"helper");
        boolean isHubSharesProcessWithBundle = this.isInTheSameProcess(propertiesBasedConfigurationHelper, properties);
        if (isHubSharesProcessWithBundle) {
            Object bundleAPI = parameters.get("jetbrains.bundle.service");
            if (isHubProduct) {
                if (bundleAPI instanceof BundlePropertiesService) {
                    String hubContext = helper.getServiceSubContext((Object)properties, "hub");
                    BundlePropertiesService bundlePropertiesService = (BundlePropertiesService)bundleAPI;
                    String string = hubContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hubContext");
                    this.subscribeOnServiceHomeUrlSettingChange(bundlePropertiesService, string);
                    this.subscribeOnBackupSettingsChange((BundlePropertiesService)bundleAPI);
                } else {
                    this.getLogger().warn("Cannot find a Ring Bundle API facade instance. Setting changes will not be synchronized");
                }
            }
            if (bundleAPI instanceof ClientCertificateAuthSettingsService) {
                this.subscribeOnClientCertificateAuthModuleChange((ClientCertificateAuthSettingsService)bundleAPI);
            } else {
                String contractName = ClientCertificateAuthSettingsService.class.getSimpleName();
                this.getLogger().warn("Bundle API doesn't implement " + contractName + " interface. Client certificate data will not be synchronized");
            }
        } else {
            this.getLogger().warn("Hub is running in a separate process. Setting changes will not be synchronized");
        }
    }

    private final void subscribeOnServiceHomeUrlSettingChange(@NotNull BundlePropertiesService $receiver, String hubContext) {
        BaseUrlUpdaterKt.updateBaseUrlOnServiceHomeUrlSettingChange(this.getEventsMultiplexer(), $receiver, hubContext);
    }

    private final void subscribeOnBackupSettingsChange(@NotNull BundlePropertiesService $receiver) {
        BackupDirectoryUpdaterKt.updateBackupDirectoryOnBackupSettingsChange(this.getEventsMultiplexer(), $receiver);
    }

    private final void subscribeOnClientCertificateAuthModuleChange(@NotNull ClientCertificateAuthSettingsService $receiver) {
        ClientCertificateSettingsUpdaterKt.updateTrustedIssuersOnClientCertificateModuleChange(this.getEventsMultiplexer(), $receiver);
    }

    private final Properties loadPropertiesSafe(@NotNull File $receiver) {
        Properties properties = ConfiguratorUtils.loadPropertiesFile((File)$receiver);
        HubInternalProperties.ADMIN_PASSWORD.removeServletParameter(properties);
        properties.remove(BundleProperty.ROOT_PASSWORD.getPrefixedName());
        ConfiguratorUtils.savePropertiesFile((File)$receiver, (Properties)properties);
        Properties properties2 = properties;
        Intrinsics.checkExpressionValueIsNotNull((Object)properties2, (String)"properties");
        return properties2;
    }

    private final boolean isHubProduct(@NotNull Properties $receiver) {
        String productName;
        Object object = $receiver.get("bundle.product.name");
        if (!(object instanceof String)) {
            object = null;
        }
        String string = productName = (String)object;
        return string != null && StringsKt.equals((String)string, (String)"Hub", (boolean)true);
    }

    private final boolean isInTheSameProcess(@NotNull PropertiesBasedConfigurationHelper $receiver, Properties properties) {
        return $receiver.getServiceProperty((Object)properties, "bundledin") != null;
    }

    public HubAfterStartCallback() {
        ReadOnlyProperty readOnlyProperty;
        HubAfterStartCallback hubAfterStartCallback = this;
        String name$iv = null;
        hubAfterStartCallback.eventsMultiplexer$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }
}

