/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.hub.service;

import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.contract.callbacks.impl.log4j.BeforeStartCallback;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class HubBeforeStartCallback
extends BeforeStartCallback {
    protected void doPerform(@NotNull Map<String, Object> parameters) {
        HubBeforeStartCallback.doBeforeStart();
    }

    static void doBeforeStart() {
        if (System.getProperty("jetbrains.jetpass.check.for.update.disable") == null) {
            System.setProperty("jetbrains.jetpass.check.for.update.disable", "true");
        }
        if (System.getProperty("exodus.memoryUsagePercentage") == null) {
            System.setProperty("exodus.memoryUsagePercentage", "10");
        }
        HubBeforeStartCallback.assertHasEnoughRandomBits();
    }

    private static void assertHasEnoughRandomBits() {
        ExecutorService ex = Executors.newSingleThreadExecutor();
        Future<?> f = ex.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    SecureRandom.getInstance("SHA1PRNG").nextInt();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            f.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new StatusException("Operation system does not have enough random bits for the application to start");
        }
        finally {
            ex.shutdown();
        }
    }
}

