/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.hub.service;

import com.jetbrains.hub.service.HubInternalProperties;
import com.jetbrains.service.util.BundleEnvironmentProperty;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.Version;
import com.jetbrains.service.util.contract.service.ConfigurableServiceBase;
import com.jetbrains.service.util.contract.service.context.CommonContextProvider;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class HubConfigurableService
extends ConfigurableServiceBase {
    private static final String MINIMAL_BUNDLE_VERSION = "0.7.142";

    @NotNull
    protected String getServiceCookieName() {
        return "HUBSESSIONID";
    }

    protected void configure(@NotNull Properties properties, @NotNull CommonContextProvider contextProvider) {
        String hostServiceId;
        super.configure(properties, contextProvider);
        this.assertBundleVersion(properties);
        String installationType = this.getMandatoryProperty(BundleEnvironmentProperty.INSTALLATION_TYPE.getPrefixedName(), properties);
        HubInternalProperties.INSTALLATION_TYPE.setNewServletParameter(installationType, properties);
        boolean newInstallation = !this.isExistingInstallation(properties);
        HubInternalProperties.ADMIN_UID.setNewServletParameter(this.getMandatoryProperty("hub-admin-uuid", properties), properties);
        if (newInstallation) {
            String bundleLocale = properties.getProperty(BundleProperty.LOCALE.getPrefixedName());
            if (bundleLocale != null) {
                HubInternalProperties.LOCALE.setNewServletParameter(bundleLocale, properties);
            }
        } else {
            HubInternalProperties.LOCALE.removeServletParameter(properties);
        }
        HubInternalProperties.DB_LOCATION.setNewServletParameter(this.getMandatoryProperty(ServiceProperties.DATA_DIR_PROPERTY, properties), properties);
        String backupsDir = this.isHubBundle(properties) ? properties.getProperty(BundleProperty.BACKUPS_DIR.getPrefixedName()) : properties.getProperty(ServiceProperties.BACKUPS_DIR_PROPERTY);
        HubInternalProperties.DB_BACKUP_LOCATION.setNewServletParameter(backupsDir, properties);
        if (!this.isYouTrackBundle(properties) || newInstallation || PropertiesBasedConfigurationHelper.getHelper().isProductUpgrade((Object)properties) || Boolean.valueOf(properties.getProperty("hub-reset")).booleanValue()) {
            HubInternalProperties.BASE_URL.setNewServletParameter(this.getMandatoryProperty("base-url", properties), properties);
        } else {
            HubInternalProperties.BASE_URL.removeServletParameter(properties);
        }
        String bundleRootPassword = properties.getProperty(BundleProperty.ROOT_PASSWORD.getPrefixedName());
        String bundleRootUser = properties.getProperty(BundleProperty.ROOT_USER.getPrefixedName());
        if (bundleRootPassword != null && bundleRootUser != null) {
            HubInternalProperties.ADMIN_RESTORE.setNewServletParameter("true", properties);
            HubInternalProperties.ADMIN_LOGIN.setNewServletParameter(bundleRootUser, properties);
            HubInternalProperties.ADMIN_NAME.setNewServletParameter(bundleRootUser, properties);
            HubInternalProperties.ADMIN_PASSWORD.setNewServletParameter(bundleRootPassword, properties);
        } else {
            HubInternalProperties.ADMIN_RESTORE.removeServletParameter(properties);
        }
        HubInternalProperties.LOGS_DIRECTORY.setNewServletParameter(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, ServiceProperties.LOGS_DIR_PROPERTY), properties);
        String verifiedServiceIds = properties.getProperty("hub-verified-service-ids");
        if (verifiedServiceIds != null) {
            HubInternalProperties.VERIFIED_SERVICE_IDS.setNewServletParameter(verifiedServiceIds, properties);
        }
        if ((hostServiceId = properties.getProperty("hub-host-service-id")) != null) {
            HubInternalProperties.HOST_SERVICE_ID.setNewServletParameter(hostServiceId, properties);
        }
        String confDir = properties.getProperty(BundleEnvironmentProperty.CONF_DIR.getPrefixedName());
        HubInternalProperties.BUNDLE_CONF_DIR.setNewServletParameter(confDir, properties);
        String uploadStat = properties.getProperty(BundleProperty.STATISTICS_UPLOAD.getPrefixedName());
        if (uploadStat != null) {
            HubInternalProperties.STATISTICS_UPLOAD.setNewServletParameter(uploadStat, properties);
        }
        String dashboardDataDir = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, BundleProperty.DATA_DIR.getPrefixedName()) + "/dashboard";
        HubInternalProperties.DASHBOARD_DATA_DIR.setNewServletParameter(dashboardDataDir, properties);
        ConfiguratorUtils.savePropertiesFile((File)this.getConfigPath(contextProvider), (Properties)properties);
    }

    private boolean isYouTrackBundle(@NotNull Properties properties) {
        return this.isProduct("YouTrack", properties);
    }

    private boolean isHubBundle(@NotNull Properties properties) {
        return this.isProduct("Hub", properties);
    }

    private boolean isProduct(@NotNull String productName, @NotNull Properties properties) {
        return productName.equalsIgnoreCase(this.getMandatoryProperty("bundle.product.name", properties));
    }

    private boolean isExistingInstallation(@NotNull Properties properties) {
        boolean result = false;
        String dbYouTrackLocation = this.getMandatoryProperty(ServiceProperties.DATA_DIR_PROPERTY, properties);
        File dbDir = new File(dbYouTrackLocation);
        try {
            result = HubConfigurableService.containsExodusDb(dbDir);
        }
        catch (IOException e) {
            this.getLogger().debug("Failed to check db location directory", (Throwable)e);
        }
        return result;
    }

    private static boolean containsExodusDb(@NotNull File directory) throws IOException {
        if (directory.exists()) {
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory.toPath());){
                for (Path path : dirStream) {
                    if (!path.toString().toLowerCase().endsWith(".xd")) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private void assertBundleVersion(Properties properties) {
        String bundleVersion = properties.getProperty("bundle.version");
        String hubVersion = properties.getProperty("version");
        if (hubVersion != null) {
            if (bundleVersion == null) {
                throw new IllegalStateException(String.format("Hub of version %s requires bundle of version >= %s, but no correct bundle version was provided - this means bundle is too old!", hubVersion, MINIMAL_BUNDLE_VERSION));
            }
            if (Version.parseVersion((String)bundleVersion) != null && !Version.parseVersion((String)bundleVersion).isGreaterOrEqual(MINIMAL_BUNDLE_VERSION)) {
                throw new IllegalStateException(String.format("Hub of version %s requires bundle of version >= %s, but bundle of version %s is used!", hubVersion, MINIMAL_BUNDLE_VERSION, bundleVersion));
            }
        }
    }
}

