/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.hub.service;

import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HubInternalProperties {
    ADMIN_UID("jetbrains.jetpass.admin.uuid", "jetbrains.jetpass.admin.uuid"),
    BASE_URL("baseUrl", "jetbrains.jetpass.baseurl"),
    DB_LOCATION("jetbrains.jetpass.database.location", "jetbrains.jetpass.database.location"),
    DB_BACKUP_LOCATION("jetbrains.jetpass.database.backup.location", "jetbrains.jetpass.database.backup.location"),
    LOCALE("jetbrains.jetpass.locale", "jetbrains.jetpass.locale"),
    ADMIN_LOGIN("jetbrains.jetpass.admin.login", "jetbrains.jetpass.admin.login"),
    ADMIN_PASSWORD("jetbrains.jetpass.admin.password", "jetbrains.jetpass.admin.password"),
    ADMIN_NAME("jetbrains.jetpass.admin.name", "jetbrains.jetpass.admin.name"),
    ADMIN_RESTORE("jetbrains.jetpass.admin.restore", "jetbrains.jetpass.admin.restore"),
    LOGS_DIRECTORY("jetbrains.hub.logDir", "jetbrains.hub.logDir"),
    VERIFIED_SERVICE_IDS("verifiedServiceIds", "jetbrains.jetpass.verifiedServiceIds"),
    HOST_SERVICE_ID("jetbrains.jetpass.hostServiceId", "jetbrains.jetpass.hostServiceId"),
    BUNDLE_CONF_DIR("jetbrains.jetpass.backup.confLocation", "jetbrains.jetpass.backup.confLocation"),
    STATISTICS_UPLOAD("jetbrains.hub.statistics.upload", "jetbrains.hub.statistics.upload"),
    DASHBOARD_DATA_DIR("jetbrains.hub.dashboard.dataDir", "jetbrains.hub.dashboard.dataDir"),
    INSTALLATION_TYPE("jetbrains.hub.installation.type", "jetbrains.hub.installation.type");

    private static final Logger LOG;
    private String servletParamName;
    private String systemPropName;

    private HubInternalProperties(String servletParamName, String systemPropName) {
        this.servletParamName = servletParamName;
        this.systemPropName = systemPropName;
    }

    public void setSystemProperty(String value) {
        System.setProperty(this.systemPropName, value);
    }

    public void setNewServletParameter(String value, @NotNull Properties properties) {
        String oldValue = properties.getProperty(this.servletParamName);
        if (oldValue != null && !oldValue.equals(value) && this != ADMIN_PASSWORD) {
            LOG.debug("Servlet context parameter [" + this.servletParamName + "] is overridden. Its old value is [" + oldValue + "] and new value is [" + value + "]");
        }
        properties.setProperty(this.servletParamName, value);
    }

    public String removeServletParameter(@NotNull Properties properties) {
        return (String)properties.remove(this.servletParamName);
    }

    public void setSystemPropertyFromServletParameter(@NotNull Properties servletParameters) {
        String property = servletParameters.getProperty(this.servletParamName);
        if (property != null) {
            System.setProperty(this.systemPropName, property);
        }
    }

    public String getServletParam(@NotNull Properties servletParameters) {
        return servletParameters.getProperty(this.servletParamName);
    }

    public String getSystemProperty() {
        return System.getProperty(this.systemPropName);
    }

    static {
        LOG = LoggerFactory.getLogger(HubInternalProperties.class);
    }
}

