/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.gaprest.doc.model;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.youtrack.gaprest.doc.model.GDoc;
import jetbrains.youtrack.gaprest.doc.model.GEntityProperty;
import jetbrains.youtrack.gaprest.doc.model.GEntityType;
import jetbrains.youtrack.gaprest.doc.model.GEntityTypeTreeNode;
import jetbrains.youtrack.gaprest.doc.model.GHttpMethod;
import jetbrains.youtrack.gaprest.doc.model.GMethodInfo;
import jetbrains.youtrack.gaprest.doc.model.GMethodQueryParameter;
import jetbrains.youtrack.gaprest.doc.model.GPrimitiveType;
import jetbrains.youtrack.gaprest.doc.model.GResource;
import jetbrains.youtrack.gaprest.doc.model.GResourceTreeNode;
import jetbrains.youtrack.gaprest.doc.model.GSampleCommunication;
import jetbrains.youtrack.gaprest.doc.model.GSubResource;
import jetbrains.youtrack.gaprest.doc.model.GType;
import jetbrains.youtrack.gaprest.doc.model.GTypeReference;
import jetbrains.youtrack.gaprest.doc.model.GapDocGenerator;
import jetbrains.youtrack.gaprest.doc.model.GapDocGenerator$WhenMappings;
import jetbrains.youtrack.gaprest.doc.model.ModelCollector;
import jetbrains.youtrack.gaprest.doc.model.ResourceTreeKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 N2\u00020\u0001:\u0002NOB\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0(2\u0006\u0010)\u001a\u00020\u0004J\f\u0010*\u001a\u00020\u0004*\u00020+H\u0002J\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0(*\u00020\n2\u0006\u0010.\u001a\u00020\u0004H\u0002J$\u0010/\u001a\u00020\u0004*\u00020\u00102\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u0010/\u001a\u00020\u0004*\u00020\u00172\u0006\u00102\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u0004H\u0002J$\u0010/\u001a\u00020\u0004*\u00020\n2\u0006\u0010.\u001a\u00020\u00042\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0002J\u0014\u0010/\u001a\u00020$*\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0014\u00108\u001a\u00020\u0004*\u0002092\u0006\u0010:\u001a\u00020\u0004H\u0002J\u0014\u0010;\u001a\u00020\u0004*\u0002052\u0006\u0010:\u001a\u00020\u0004H\u0002J\u0014\u0010<\u001a\u00020\u0004*\u00020\u00172\u0006\u00102\u001a\u00020\nH\u0002J\u0014\u0010=\u001a\u00020\u0004*\u00020\u00052\u0006\u0010>\u001a\u00020\u0004H\u0002J\u0014\u0010\"\u001a\u00020\u0004*\u00020\u00172\u0006\u00102\u001a\u00020\nH\u0002J\u0012\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00040(*\u00020\u0010H\u0002J\f\u0010@\u001a\u00020\u0004*\u00020AH\u0002J\u0014\u0010B\u001a\u00020\u0004*\u00020C2\u0006\u0010D\u001a\u00020\u001bH\u0002J\u0016\u0010E\u001a\u00020\u0004*\u00020\u00102\b\b\u0002\u0010F\u001a\u00020\tH\u0002J \u0010G\u001a\u00020\u0004*\u0004\u0018\u00010\u00042\u0006\u0010B\u001a\u00020\u00042\b\b\u0002\u0010H\u001a\u00020\u0004H\u0002J\u0014\u0010I\u001a\u00020\u0004*\u00020\n2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0016\u0010J\u001a\u00020\u0004*\u00020\u00102\b\b\u0002\u0010F\u001a\u00020\tH\u0002J\u0014\u0010K\u001a\u00020\u0004*\u00020\n2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0014\u0010L\u001a\u00020\u0004*\u00020\n2\u0006\u0010.\u001a\u00020\u0004H\u0002J\f\u0010M\u001a\u00020\u0004*\u00020\u0004H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0018\u0010\u000f\u001a\u00020\u0004*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0004*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00020\u0004*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u0004*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\u00020\u0004*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u00020\u0004*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u0006P"}, d2={"Ljetbrains/youtrack/gaprest/doc/model/GapDocGenerator;", "", "()V", "docOrTodo", "", "Ljetbrains/youtrack/gaprest/doc/model/GDoc;", "getDocOrTodo", "(Ljetbrains/youtrack/gaprest/doc/model/GDoc;)Ljava/lang/String;", "hasEntityMethods", "", "Ljetbrains/youtrack/gaprest/doc/model/GResource;", "getHasEntityMethods", "(Ljetbrains/youtrack/gaprest/doc/model/GResource;)Z", "hasMethodAll", "getHasMethodAll", "idPlaceholder", "Ljetbrains/youtrack/gaprest/doc/model/GEntityType;", "getIdPlaceholder", "(Ljetbrains/youtrack/gaprest/doc/model/GEntityType;)Ljava/lang/String;", "plural", "getPlural", "(Ljava/lang/String;)Ljava/lang/String;", "querySyntax", "Ljetbrains/youtrack/gaprest/doc/model/GMethodInfo;", "getQuerySyntax", "(Ljetbrains/youtrack/gaprest/doc/model/GMethodInfo;)Ljava/lang/String;", "referenceName", "Ljetbrains/youtrack/gaprest/doc/model/GType;", "getReferenceName", "(Ljetbrains/youtrack/gaprest/doc/model/GType;)Ljava/lang/String;", "relativePath", "getRelativePath", "(Ljetbrains/youtrack/gaprest/doc/model/GResource;)Ljava/lang/String;", "relativePathWithId", "getRelativePathWithId", "generate", "", "types", "", "resources", "", "generatedArtifactsRoot", "asTableRaw", "Ljetbrains/youtrack/gaprest/doc/model/GMethodQueryParameter;", "describeSubResourceLinks", "Ljetbrains/youtrack/gaprest/doc/model/GapDocGenerator$SubResourceLinkDescriptor;", "parentResourcePath", "generateDoc", "h", "f", "resource", "asOperationsContainer", "unique", "Ljetbrains/youtrack/gaprest/doc/model/GResourceTreeNode;", "dest", "Ljava/io/File;", "generateEntityToc", "Ljetbrains/youtrack/gaprest/doc/model/GEntityTypeTreeNode;", "initialIndent", "generateResourceToc", "getAnchorIn", "getDocOrEmpty", "id", "getWords", "ref", "Ljetbrains/youtrack/gaprest/doc/model/GTypeReference;", "title", "Ljetbrains/youtrack/gaprest/doc/model/GHttpMethod;", "type", "toCaptionWords", "lastPlural", "toCodeBlock", "lang", "toId", "toLowerCaseWords", "toOperationsId", "toResourceId", "withProcessedEntityLinks", "Companion", "SubResourceLinkDescriptor", "youtrack-gap-doc"})
public final class GapDocGenerator {
    private static final Regex CAMEL_REGEX;
    private static final Regex ENTITY_LINK_REGEX;
    private static final String TAB = "    ";
    private static final String API_PREFIX = "/api";
    private static final String COMMON_STUFF = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE topic SYSTEM \"http://helpserver.labs.intellij.net/help/html-entities.dtd\">";
    private static final String COMMON_TOPIC_ATTRIBUTES = "xsi:noNamespaceSchemaLocation=\"http://helpserver.labs.intellij.net/help/topic.v2.xsd\"\n           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    private static final String SKIP = "$skip";
    private static final String TOP = "$top";
    @NotNull
    private static final Set<GHttpMethod> METHODS_ON_COLLECTIONS;
    @NotNull
    private static final Set<GHttpMethod> METHODS_ON_ENTITIES;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generate(@NotNull Collection<? extends GType> types, @NotNull List<? extends GResource> resources, @NotNull String generatedArtifactsRoot) {
        Object it;
        File $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        Intrinsics.checkParameterIsNotNull((Object)generatedArtifactsRoot, (String)"generatedArtifactsRoot");
        Iterable iterable = $receiver$iv = (Iterable)types;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof GEntityType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entityTypes = (List)destination$iv$iv;
        Companion.getLogger().info((Function0)new Function0<String>(entityTypes){
            final /* synthetic */ List $entityTypes;

            @NotNull
            public final String invoke() {
                return "About to generate docs for " + this.$entityTypes.size() + " entity types";
            }
            {
                this.$entityTypes = list;
                super(0);
            }
        });
        $receiver$iv$iv = new File(generatedArtifactsRoot);
        File $receiver = $receiver$iv$iv;
        boolean bl = false;
        if ($receiver.exists()) {
            if ($receiver.isDirectory()) {
                FilesKt.deleteRecursively((File)$receiver);
            } else {
                throw (Throwable)new IllegalArgumentException($receiver.getAbsolutePath() + " is not a directory");
            }
        }
        Files.createDirectories($receiver.toPath(), new FileAttribute[0]);
        File dest = $receiver$iv$iv;
        Iterable $receiver$iv2 = entityTypes;
        for (Object element$iv : $receiver$iv2) {
            Object $i$f$filterIsInstance;
            it = (GEntityType)element$iv;
            boolean bl2 = false;
            Object $receiver2 = $i$f$filterIsInstance = new File(generatedArtifactsRoot, this.getReferenceName((GType)it) + ".xml");
            boolean bl3 = false;
            ((File)$receiver2).createNewFile();
            File file = $i$f$filterIsInstance;
            $receiver2 = $i$f$filterIsInstance = new FileWriter(file);
            boolean bl4 = false;
            ((Writer)$receiver2).write(GapDocGenerator.generateDoc$default(this, (GEntityType)it, null, null, 3, null));
            ((OutputStreamWriter)$receiver2).close();
        }
        GResourceTreeNode resourceTree = ResourceTreeKt.generateTree(resources);
        this.generateDoc(resourceTree, dest);
        GEntityTypeTreeNode entityTypeTree = ResourceTreeKt.generateTree(entityTypes);
        Object $receiver3 = it = new StringBuilder();
        boolean bl5 = false;
        ((StringBuilder)$receiver3).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE product-profile\n        SYSTEM \"http://helpserver.labs.intellij.net/help/product-profile.dtd\">\n<product-profile\n        id=\"ytr\"\n        name=\"YouTrack REST API Reference\"\n        start-page=\"api-reference-gen.xml\"\n>\n    <toc-element id=\"api-reference-gen.xml\">\n");
        String indent = StringsKt.repeat((CharSequence)TAB, (int)2);
        ((StringBuilder)$receiver3).append(this.generateEntityToc(entityTypeTree, indent));
        ((StringBuilder)$receiver3).append(this.generateResourceToc(resourceTree, indent));
        ((StringBuilder)$receiver3).append("\n    </toc-element>\n</product-profile>");
        String string = ((StringBuilder)it).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String tocBuilder = string;
        Object object = new File(dest, "ytr.tree");
        File $receiver4 = object;
        boolean bl6 = false;
        $receiver4.createNewFile();
        File tocFile = object;
        object = new FileWriter(tocFile);
        Throwable throwable = null;
        try {
            FileWriter it2 = (FileWriter)object;
            boolean bl7 = false;
            it2.write(tocBuilder);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final String generateEntityToc(@NotNull GEntityTypeTreeNode $receiver, String initialIndent) {
        Object id;
        StringBuilder tocBuilder = new StringBuilder();
        String indent = initialIndent;
        Object object = $receiver.getWrapped();
        if (object == null || (object = this.getReferenceName((GType)object)) == null) {
            object = id = "api-entities";
        }
        if ($receiver.getChildren().isEmpty()) {
            tocBuilder.append(indent + "<toc-element id=\"" + (String)id + ".xml\"/>\n");
        } else {
            Iterable $receiver$iv;
            tocBuilder.append(indent + "<toc-element id=\"" + (String)id + ".xml\">\n");
            indent = indent + TAB;
            Iterable iterable = $receiver.getChildren();
            Iterator iterator = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    GEntityTypeTreeNode it = (GEntityTypeTreeNode)a;
                    boolean bl = false;
                    Object object = it.getWrapped();
                    if (object == null || (object = ((GEntityType)object).getTypeName()) == null) {
                        object = "";
                    }
                    it = (GEntityTypeTreeNode)b;
                    Comparable comparable = (Comparable)object;
                    bl = false;
                    Object object2 = it.getWrapped();
                    if (object2 == null || (object2 = ((GEntityType)object2).getTypeName()) == null) {
                        object2 = "";
                    }
                    Object object3 = object2;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)object3));
                }
            };
            $receiver$iv = CollectionsKt.sortedWith((Iterable)((Object)iterator), (Comparator)comparator);
            for (Object element$iv : $receiver$iv) {
                GEntityTypeTreeNode it = (GEntityTypeTreeNode)element$iv;
                boolean bl = false;
                tocBuilder.append(this.generateEntityToc(it, indent));
            }
            indent = StringsKt.removeSuffix((String)indent, (CharSequence)TAB);
            tocBuilder.append(indent + "</toc-element>\n");
        }
        String string = tocBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tocBuilder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateResourceToc(@NotNull GResourceTreeNode $receiver, String initialIndent) {
        void indent;
        StringBuilder tocBuilder = new StringBuilder();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = initialIndent;
        Function2<String, GResourceTreeNode, Unit> dfs$ = new Function2<String, GResourceTreeNode, Unit>(this, tocBuilder, (Ref.ObjectRef)indent){
            final /* synthetic */ GapDocGenerator this$0;
            final /* synthetic */ StringBuilder $tocBuilder;
            final /* synthetic */ Ref.ObjectRef $indent;

            public final void invoke(@NotNull String parentResourcePath, @NotNull GResourceTreeNode node) {
                Object resourceFileName;
                Object resourcePath;
                GResource resource;
                block9: {
                    Object object;
                    block8: {
                        GResource gResource;
                        Intrinsics.checkParameterIsNotNull((Object)parentResourcePath, (String)"parentResourcePath");
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        resource = node.getResource();
                        object = resource;
                        if (object == null) break block8;
                        GResource it = gResource = object;
                        boolean bl = false;
                        object = parentResourcePath + '/' + GapDocGenerator.access$getRelativePath$p(this.this$0, it);
                        if (object != null) break block9;
                    }
                    object = resourcePath = parentResourcePath;
                }
                if (resource != null) {
                    Iterable $receiver$iv;
                    Object operationsFileName;
                    resourceFileName = GapDocGenerator.access$toResourceId(this.this$0, resource, parentResourcePath) + ".xml";
                    this.$tocBuilder.append((String)this.$indent.element + "<toc-element id=\"" + (String)resourceFileName + "\" show-structure-for=\"chapter\" show-structure-depth=\"2\">\n");
                    this.$indent.element = (String)this.$indent.element + "    ";
                    if (GapDocGenerator.access$getHasEntityMethods$p(this.this$0, resource)) {
                        operationsFileName = GapDocGenerator.access$toOperationsId(this.this$0, resource, parentResourcePath) + ".xml";
                        this.$tocBuilder.append((String)this.$indent.element + "<toc-element id=\"" + (String)operationsFileName + "\" show-structure-for=\"chapter\" show-structure-depth=\"2\"/>\n");
                    }
                    operationsFileName = node.getChildren();
                    Iterator<T> bl = $receiver$iv;
                    Comparator comparator = new Comparator<T>(this){
                        final /* synthetic */ generateResourceToc.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final int compare(T a, T b) {
                            GResourceTreeNode it = (GResourceTreeNode)a;
                            boolean bl = false;
                            Object object = it.getResource();
                            if (object == null || (object = GapDocGenerator.access$getRelativePath$p(this.this$0.this$0, (GResource)object)) == null) {
                                object = "_";
                            }
                            it = (GResourceTreeNode)b;
                            Comparable comparable = (Comparable)object;
                            bl = false;
                            Object object2 = it.getResource();
                            if (object2 == null || (object2 = GapDocGenerator.access$getRelativePath$p(this.this$0.this$0, (GResource)object2)) == null) {
                                object2 = "_";
                            }
                            Object object3 = object2;
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)object3));
                        }
                    };
                    $receiver$iv = CollectionsKt.sortedWith((Iterable)((Object)bl), (Comparator)comparator);
                    for (T element$iv : $receiver$iv) {
                        GResourceTreeNode it = (GResourceTreeNode)element$iv;
                        boolean bl2 = false;
                        this.invoke((String)resourcePath, it);
                    }
                    this.$indent.element = StringsKt.removeSuffix((String)((String)this.$indent.element), (CharSequence)"    ");
                    this.$tocBuilder.append((String)this.$indent.element + "</toc-element>\n");
                } else {
                    Iterable $receiver$iv;
                    resourceFileName = node.getChildren();
                    Iterator<T> iterator = $receiver$iv;
                    Comparator bl = new Comparator<T>(this){
                        final /* synthetic */ generateResourceToc.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final int compare(T a, T b) {
                            GResourceTreeNode it = (GResourceTreeNode)a;
                            boolean bl = false;
                            Object object = it.getResource();
                            if (object == null || (object = GapDocGenerator.access$getRelativePath$p(this.this$0.this$0, (GResource)object)) == null) {
                                object = "_";
                            }
                            it = (GResourceTreeNode)b;
                            Comparable comparable = (Comparable)object;
                            bl = false;
                            Object object2 = it.getResource();
                            if (object2 == null || (object2 = GapDocGenerator.access$getRelativePath$p(this.this$0.this$0, (GResource)object2)) == null) {
                                object2 = "_";
                            }
                            Object object3 = object2;
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)object3));
                        }
                    };
                    $receiver$iv = CollectionsKt.sortedWith((Iterable)((Object)iterator), (Comparator)bl);
                    for (T element$iv : $receiver$iv) {
                        GResourceTreeNode it = (GResourceTreeNode)element$iv;
                        boolean bl3 = false;
                        this.invoke((String)resourcePath, it);
                    }
                }
            }
            {
                this.this$0 = gapDocGenerator;
                this.$tocBuilder = stringBuilder;
                this.$indent = objectRef;
                super(2);
            }
        };
        tocBuilder.append((String)indent.element + "<toc-element id=\"api-resources.xml\">\n");
        indent.element = (String)indent.element + TAB;
        dfs$.invoke(API_PREFIX, $receiver);
        indent.element = StringsKt.removeSuffix((String)((String)indent.element), (CharSequence)TAB);
        tocBuilder.append((String)indent.element + "</toc-element>\n");
        String string = tocBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tocBuilder.toString()");
        return string;
    }

    private final void generateDoc(@NotNull GResourceTreeNode $receiver, File dest) {
        Function2<String, GResourceTreeNode, Unit> dfs$ = new Function2<String, GResourceTreeNode, Unit>(this, dest){
            final /* synthetic */ GapDocGenerator this$0;
            final /* synthetic */ File $dest;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull String parentResourcePath, @NotNull GResourceTreeNode node) {
                Object object;
                block20: {
                    block19: {
                        Object operationsFile;
                        Intrinsics.checkParameterIsNotNull((Object)parentResourcePath, (String)"parentResourcePath");
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        GResource resource = node.getResource();
                        if (resource != null) {
                            Object object2;
                            Object $receiver = object2 = new File(this.$dest, GapDocGenerator.access$toResourceId(this.this$0, resource, parentResourcePath) + ".xml");
                            boolean bl = false;
                            ((File)$receiver).createNewFile();
                            File resourceFile = object2;
                            object2 = new FileWriter(resourceFile);
                            $receiver = null;
                            try {
                                FileWriter it = (FileWriter)object2;
                                boolean bl2 = false;
                                it.write(GapDocGenerator.access$generateDoc(this.this$0, resource, parentResourcePath, false, node.getUnique()));
                                it = Unit.INSTANCE;
                            }
                            catch (Throwable it) {
                                $receiver = it;
                                throw it;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object2, (Throwable)$receiver);
                            }
                            if (GapDocGenerator.access$getHasEntityMethods$p(this.this$0, resource)) {
                                $receiver = new File(this.$dest, GapDocGenerator.access$toOperationsId(this.this$0, resource, parentResourcePath) + ".xml");
                                Serializable $receiver2 = $receiver;
                                boolean bl3 = false;
                                ((File)$receiver2).createNewFile();
                                operationsFile = $receiver;
                                $receiver = new FileWriter((File)operationsFile);
                                $receiver2 = null;
                                try {
                                    FileWriter it = (FileWriter)$receiver;
                                    boolean bl4 = false;
                                    it.write(GapDocGenerator.access$generateDoc(this.this$0, resource, parentResourcePath, true, node.getUnique()));
                                    it = Unit.INSTANCE;
                                }
                                catch (Throwable it) {
                                    $receiver2 = it;
                                    throw it;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)$receiver, (Throwable)$receiver2);
                                }
                            }
                        }
                        if ((object = resource) == null) break block19;
                        operationsFile = object;
                        GResource it = operationsFile;
                        boolean bl = false;
                        object = parentResourcePath + '/' + GapDocGenerator.access$getRelativePath$p(this.this$0, it);
                        if (object != null) break block20;
                    }
                    object = parentResourcePath;
                }
                Object resourcePath = object;
                Iterable $receiver$iv = node.getChildren();
                for (T element$iv : $receiver$iv) {
                    GResourceTreeNode it = (GResourceTreeNode)element$iv;
                    boolean bl = false;
                    this.invoke((String)resourcePath, it);
                }
            }
            {
                this.this$0 = gapDocGenerator;
                this.$dest = file;
                super(2);
            }
        };
        dfs$.invoke(API_PREFIX, $receiver);
    }

    /*
     * WARNING - void declaration
     */
    private final String generateDoc(@NotNull GResource $receiver, String parentResourcePath, boolean asOperationsContainer, boolean unique) {
        StringBuilder stringBuilder;
        void $receiver$iv$iv;
        void $receiver$iv;
        String string;
        Iterable destination$iv$iv;
        Object it;
        boolean bl;
        Iterable $receiver$iv2;
        Object object;
        String header;
        String typeDescriptionHeader;
        Set<GHttpMethod> httpMethods;
        block7: {
            GEntityType gEntityType;
            httpMethods = asOperationsContainer ? METHODS_ON_ENTITIES : METHODS_ON_COLLECTIONS;
            Companion.getLogger().debug((Function0)new Function0<String>($receiver){
                final /* synthetic */ GResource $this_generateDoc;

                @NotNull
                public final String invoke() {
                    return "Generating documentation for " + this.$this_generateDoc.getPath().getBase() + " resource";
                }
                {
                    this.$this_generateDoc = gResource;
                    super(0);
                }
            });
            GEntityType $receiver2 = gEntityType = $receiver.getEntityType();
            boolean $i$a$-with-GapDocGenerator$generateDoc$typeDescriptionHeader$22 = false;
            typeDescriptionHeader = "\n    <chapter title=\"" + $receiver2.getTypeName() + " attributes\" id=\"" + $receiver2.getTypeName() + "-supported-fields\">\n";
            header = asOperationsContainer ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE topic SYSTEM \"http://helpserver.labs.intellij.net/help/html-entities.dtd\">\n<topic xsi:noNamespaceSchemaLocation=\"http://helpserver.labs.intellij.net/help/topic.v2.xsd\"\n           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    title=\"Operations with Specific " + $receiver.getEntityType().getTypeName() + "\"\n    id=\"" + this.toOperationsId($receiver, parentResourcePath) + "\">\n    <p>" + this.getDocOrEmpty($receiver, this.toOperationsId($receiver, parentResourcePath)) + "</p>\n            " : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE topic SYSTEM \"http://helpserver.labs.intellij.net/help/html-entities.dtd\">\n    <topic xsi:noNamespaceSchemaLocation=\"http://helpserver.labs.intellij.net/help/topic.v2.xsd\"\n           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        title=\"" + this.toCaptionWords($receiver.getEntityType(), this.getHasMethodAll($receiver)) + "\"\n        id=\"" + this.toResourceId($receiver, parentResourcePath) + "\">\n        <p>" + this.getDocOrEmpty($receiver, this.toResourceId($receiver, parentResourcePath)) + "</p>\n        ";
            Iterable $i$a$-with-GapDocGenerator$generateDoc$typeDescriptionHeader$22 = $receiver.getMethods();
            object = new StringBuilder().append("\n        <table header-style=\"none\">\n            <tr>\n                <td>Resource</td>\n                <td><code style=\"block\">").append(asOperationsContainer ? parentResourcePath + '/' + this.getRelativePathWithId($receiver) : parentResourcePath + '/' + this.getRelativePath($receiver)).append("</code></td>\n            </tr>\n            <tr>\n                <td>Returned entity</td>\n                <td>\n                    <a href=\"").append(this.getReferenceName($receiver.getEntityType())).append(".xml\">").append($receiver.getEntityType().getTypeName()).append("</a>. For the description of the entity attributes, see <a anchor=\"").append($receiver.getEntityType().getTypeName()).append("-supported-fields\">Supported Fields</a> section.\n                </td>\n            </tr>\n            ");
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    it = (GMethodInfo)element$iv;
                    boolean bl2 = false;
                    if (!httpMethods.contains((Object)((GMethodInfo)it).getMethod())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        StringBuilder stringBuilder2 = object;
        if (bl3) {
            void $receiver$iv$iv2;
            $receiver$iv2 = $receiver.getMethods();
            StringBuilder stringBuilder3 = new StringBuilder().append("\n            <tr>\n                <td>Supported methods</td>\n                <td>\n                    <list>");
            object = stringBuilder2;
            Iterable iterable = $receiver$iv2;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                GMethodInfo it2 = (GMethodInfo)element$iv$iv;
                boolean bl4 = false;
                if (!httpMethods.contains((Object)it2.getMethod())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            stringBuilder2 = object;
            string = stringBuilder3.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<GMethodInfo, String>(this, $receiver){
                final /* synthetic */ GapDocGenerator this$0;
                final /* synthetic */ GResource $this_generateDoc;

                @NotNull
                public final String invoke(@NotNull GMethodInfo it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return "\n                        <li><code>" + it.getMethod().getHttpMethodName() + "</code>: <a anchor=\"" + GapDocGenerator.access$getAnchorIn(this.this$0, it, this.$this_generateDoc) + "\">" + GapDocGenerator.access$title(this.this$0, it.getMethod(), this.$this_generateDoc.getEntityType()) + "</a>.</li>";
                }
                {
                    this.this$0 = gapDocGenerator;
                    this.$this_generateDoc = gResource;
                    super(1);
                }
            }), (int)30, null)).append("\n                    </list>\n                </td>\n            </tr>\n            ").toString();
        } else {
            string = "";
        }
        $receiver$iv2 = $receiver.getEntityType().getSubresources();
        object = stringBuilder2.append(string).append("\n            ");
        boolean bl5 = !$receiver$iv2.isEmpty();
        String resourcesTable2 = ((StringBuilder)object).append(bl5 && !asOperationsContainer && unique ? "\n            <tr>\n                <td>Supported sub-resources</td>\n                <td>\n                    <list>\n                    " + CollectionsKt.joinToString$default((Iterable)this.describeSubResourceLinks($receiver, parentResourcePath), (CharSequence)"", null, null, (int)0, null, (Function1)generateDoc.resourcesTable.4.INSTANCE, (int)30, null) + "\n\n                    </list>\n                </td>\n            </tr>\n            " : "").append("\n        </table>\n        ").toString();
        String footer = "</topic>";
        destination$iv$iv = $receiver.getMethods();
        it = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            GMethodInfo it3 = (GMethodInfo)element$iv$iv;
            boolean bl6 = false;
            if (!httpMethods.contains((Object)it3.getMethod())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        String methodsDoc2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<GMethodInfo, String>(this, $receiver, parentResourcePath){
            final /* synthetic */ GapDocGenerator this$0;
            final /* synthetic */ GResource $this_generateDoc;
            final /* synthetic */ String $parentResourcePath;

            @NotNull
            public final String invoke(@NotNull GMethodInfo it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return GapDocGenerator.access$generateDoc(this.this$0, it, this.$this_generateDoc, this.$parentResourcePath);
            }
            {
                this.this$0 = gapDocGenerator;
                this.$this_generateDoc = gResource;
                this.$parentResourcePath = string;
                super(1);
            }
        }), (int)30, null);
        Companion.getLogger().debug((Function0)new Function0<String>(this, $receiver){
            final /* synthetic */ GapDocGenerator this$0;
            final /* synthetic */ GResource $this_generateDoc;

            @NotNull
            public final String invoke() {
                return "Including entity type " + this.$this_generateDoc.getEntityType().getTypeName() + " and " + "sub-resources " + CollectionsKt.joinToString$default((Iterable)this.$this_generateDoc.getEntityType().getSubresources(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<GSubResource, String>(this){
                    final /* synthetic */ generateDoc.3 this$0;

                    @NotNull
                    public final String invoke(@NotNull GSubResource it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return GapDocGenerator.access$getRelativePath$p(this.this$0.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)31, null);
            }
            {
                this.this$0 = gapDocGenerator;
                this.$this_generateDoc = gResource;
                super(0);
            }
        });
        object = this;
        StringBuilder $receiver3 = stringBuilder = new StringBuilder();
        boolean bl7 = false;
        $receiver3.append(header);
        $receiver3.append(resourcesTable2);
        $receiver3.append(this.generateDoc($receiver.getEntityType(), typeDescriptionHeader, "</chapter>"));
        $receiver3.append(methodsDoc2);
        $receiver3.append(footer);
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String string3 = string2;
        return super.withProcessedEntityLinks(string3);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SubResourceLinkDescriptor> describeSubResourceLinks(@NotNull GResource $receiver, String parentResourcePath) {
        Collection<SubResourceLinkDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        String resourcePath = parentResourcePath + '/' + this.getRelativePath($receiver);
        String resourcePathWithId = parentResourcePath + '/' + this.getRelativePathWithId($receiver);
        String resourceFile = this.toOperationsId($receiver, parentResourcePath) + ".xml";
        String resourceType = GapDocGenerator.toLowerCaseWords$default(this, $receiver.getEntityType(), false, 1, null);
        SubResourceLinkDescriptor resourceSingleEntity = new SubResourceLinkDescriptor(resourcePathWithId, resourceFile, resourceType);
        Iterable iterable = $receiver.getEntityType().getSubresources();
        Collection collection2 = CollectionsKt.listOf((Object)resourceSingleEntity);
        void var9_10 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void subresource;
            GSubResource gSubResource = (GSubResource)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String subresourcePath = resourcePathWithId + '/' + subresource.getPath().getBase();
            String subresourceFile = this.toResourceId((GResource)subresource, resourcePath) + ".xml";
            String subresourceType = GapDocGenerator.toLowerCaseWords$default(this, subresource.getEntityType(), false, 1, null);
            SubResourceLinkDescriptor subResourceLinkDescriptor = new SubResourceLinkDescriptor(subresourcePath, subresourceFile, subresourceType);
            collection.add(subResourceLinkDescriptor);
        }
        collection = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection2, (Iterable)collection);
    }

    private final String generateDoc(@NotNull GMethodInfo $receiver, GResource resource, String parentResourcePath) {
        return "\n        <chapter title=\"" + this.title($receiver.getMethod(), resource.getEntityType()) + "\" id=\"" + this.getAnchorIn($receiver, resource) + "\">\n            <p>" + this.getDocOrEmpty($receiver, this.getAnchorIn($receiver, resource)) + "</p>\n            <h4>Request syntax</h4>\n            <code style=\"block\">\n                " + $receiver.getMethod().getHttpMethodName() + ' ' + parentResourcePath + '/' + this.getRelativePathWithId($receiver, resource) + this.getQuerySyntax($receiver) + "\n            </code>\n            <h4>Request parameters</h4>\n\t\t\t<table>\n                <tr>\n\t\t\t        <td>Parameter</td>\n\t\t\t        <td>Type</td>\n\t\t\t        <td>Description</td>\n\t\t\t    </tr>\n            " + ($receiver.getMethod() != GHttpMethod.DELETE ? "\n\t\t\t    <tr>\n\t\t\t        <td>fields</td>\n\t\t\t        <td>string</td>\n                    <td>A list of " + resource.getEntityType().getTypeName() + " attributes that should be returned in the response. If no field is specified,\n\t\t\t                        only the <code>entityID</code> is returned.</td>\n                </tr>\n            " : "") + "\n            " + ($receiver.getMethod() == GHttpMethod.GET_ALL ? "\n                <tr>\n                    <td>$skip</td>\n                    <td>int</td>\n                    <td><emphasis>Optional</emphasis>. Lets you set a number of returned entities to skip before returning the first one.</td>\n                </tr>\n\t\t\t    <tr>\n\t\t\t        <td>$top</td>\n\t\t\t        <td>int</td>\n\t\t\t        <td><emphasis>Optional</emphasis>. Lets you specify the maximum number of entries that are returned in the response.</td>\n                </tr>\n            " : "") + '\n' + CollectionsKt.joinToString$default((Iterable)$receiver.getQueryParameters(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<GMethodQueryParameter, String>(this){
            final /* synthetic */ GapDocGenerator this$0;

            @NotNull
            public final String invoke(@NotNull GMethodQueryParameter it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return GapDocGenerator.access$asTableRaw(this.this$0, it);
            }
            {
                this.this$0 = gapDocGenerator;
                super(1);
            }
        }), (int)30, null) + "\n            </table>\n            " + CollectionsKt.joinToString$default((Iterable)$receiver.getSampleCommunications(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<GSampleCommunication, String>(this){
            final /* synthetic */ GapDocGenerator this$0;

            @NotNull
            public final String invoke(@NotNull GSampleCommunication it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return "\n            " + GapDocGenerator.access$toCodeBlock(this.this$0, it.getRequestCurl(), "Sample request URI", "cURL") + "\n            " + GapDocGenerator.toCodeBlock$default(this.this$0, it.getRequestBody(), "Sample request body", null, 2, null) + "\n            " + GapDocGenerator.toCodeBlock$default(this.this$0, it.getResponseBody(), "Sample response body", null, 2, null) + '\n';
            }
            {
                this.this$0 = gapDocGenerator;
                super(1);
            }
        }), (int)30, null) + "\n        </chapter>\n";
    }

    private final String toCodeBlock(@Nullable String $receiver, String title, String lang) {
        String string;
        block3: {
            block2: {
                String string2;
                string = $receiver;
                if (string == null || (string = StringsKt.replace$default((String)string, (String)"\n", (String)("\n" + StringsKt.repeat((CharSequence)TAB, (int)4)), (boolean)false, (int)4, null)) == null) break block2;
                String block = string2 = string;
                boolean bl = false;
                String string3 = "\n            <h4>" + title + "</h4>\n            <code style=\"block\" lang=\"" + lang + "\">\n                " + block + "\n            </code>\n           ";
                string = string3;
                if (string3 != null) break block3;
            }
            string = "";
        }
        return string;
    }

    static /* synthetic */ String toCodeBlock$default(GapDocGenerator gapDocGenerator, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "JSON";
        }
        return gapDocGenerator.toCodeBlock(string, string2, string3);
    }

    private final String getQuerySyntax(@NotNull GMethodInfo $receiver) {
        return $receiver.getMethod() == GHttpMethod.DELETE ? "" : "?{fields}" + ($receiver.getMethod() == GHttpMethod.GET_ALL ? "&amp;{$top}&amp;{$skip}" : "") + CollectionsKt.joinToString$default((Iterable)$receiver.getQueryParameters(), null, null, null, (int)0, null, (Function1)querySyntax.1.INSTANCE, (int)31, null);
    }

    private final String asTableRaw(@NotNull GMethodQueryParameter $receiver) {
        return "\n            <tr>\n                <td>" + $receiver.getName() + "</td>\n                <td>" + (Object)((Object)$receiver.getType()) + "</td>\n                <td>" + this.getDocOrTodo($receiver) + "</td>\n            </tr>\n        ";
    }

    private final String title(@NotNull GHttpMethod $receiver, GType type) {
        String string;
        switch (GapDocGenerator$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                string = "Read a List of " + this.getPlural(type.getTypeName());
                break;
            }
            case 2: {
                string = "Read a Specific " + type.getTypeName();
                break;
            }
            case 3: {
                string = "Update a Specific " + type.getTypeName();
                break;
            }
            case 4: {
                string = "Delete a Specific " + type.getTypeName();
                break;
            }
            case 5: {
                string = "Add a New " + type.getTypeName();
                break;
            }
            case 6: {
                string = "TODO no documentation for PUT";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String getReferenceName(@NotNull GType $receiver) {
        return "api-entity-" + $receiver.getTypeName();
    }

    private final String generateDoc(@NotNull GEntityType $receiver, String h, String f) {
        StringBuilder stringBuilder;
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String footer;
        String header;
        block7: {
            block6: {
                Companion.getLogger().debug((Function0)new Function0<String>($receiver){
                    final /* synthetic */ GEntityType $this_generateDoc;

                    @NotNull
                    public final String invoke() {
                        return "Generating documentation for " + this.$this_generateDoc.getTypeName() + " entity type";
                    }
                    {
                        this.$this_generateDoc = gEntityType;
                        super(0);
                    }
                });
                String string2 = h;
                if (string2 == null) {
                    string2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE topic SYSTEM \"http://helpserver.labs.intellij.net/help/html-entities.dtd\">\n    <topic xsi:noNamespaceSchemaLocation=\"http://helpserver.labs.intellij.net/help/topic.v2.xsd\"\n           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" title=\"" + $receiver.getTypeName() + "\" id=\"" + this.getReferenceName($receiver) + "\">\n";
                }
                header = string2;
                StringBuilder stringBuilder2 = new StringBuilder().append(TAB);
                String string3 = f;
                if (string3 == null) {
                    string3 = "</topic>";
                }
                footer = stringBuilder2.append(string3).append('\n').toString();
                GTypeReference gTypeReference = $receiver.getParent();
                GType parentType = gTypeReference != null ? gTypeReference.getType() : null;
                object4 = new StringBuilder().append("\n        <p>").append(this.getDocOrEmpty($receiver, this.getReferenceName($receiver))).append("</p>\n        ");
                object3 = parentType;
                if (object3 == null) break block6;
                object2 = object3;
                object = object4;
                GType it = object2;
                boolean bl = false;
                string = "<p>Extends <a href=\"" + this.getReferenceName(it) + ".xml\"/></p>";
                object4 = object;
                object3 = string;
                if (object3 != null) break block7;
            }
            object3 = "";
        }
        String description = ((StringBuilder)object4).append((String)object3).append('\n').toString();
        if ($receiver.getProperties().isEmpty()) {
            object = this;
            Object $receiver2 = object2 = new StringBuilder();
            boolean bl = false;
            ((StringBuilder)$receiver2).append(header);
            ((StringBuilder)$receiver2).append(description);
            ((StringBuilder)$receiver2).append(footer);
            String string4 = ((StringBuilder)object2).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
            string = string4;
            return super.withProcessedEntityLinks(string);
        }
        String tableHeader = "\n        <p>This table describes attributes of the <code>" + $receiver.getTypeName() + "</code> entity.</p>\n        <list>\n            <li>To receive an attribute in the response from server, specify it explicitly in the\n                request parameter <code>fields</code>.\n            </li>\n            <li>To update an attribute, provide it in the body of a POST request.</li>\n        </list>\n        <table width=\"100%\">\n            <tr>\n                <td width=\"20%\">Field</td>\n                <td width=\"20%\">Type</td>\n                <td>Description</td>\n            </tr>\n";
        String tableBody2 = CollectionsKt.joinToString$default((Iterable)$receiver.getProperties(), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<GEntityProperty, String>(this){
            final /* synthetic */ GapDocGenerator this$0;

            @NotNull
            public final String invoke(@NotNull GEntityProperty it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                GEntityProperty $receiver = it;
                boolean bl = false;
                String ro = $receiver.getReadOnly() ? "<code>Read-only</code>." : "";
                String nullable = $receiver.getType().getCardinality().getNullable() ? "<code>Can be null</code>." : "";
                return "\n            <tr>\n                <td>" + $receiver.getName() + "</td>\n                <td>" + GapDocGenerator.access$ref(this.this$0, $receiver.getType()) + "</td>\n                <td>" + GapDocGenerator.access$getDocOrTodo$p(this.this$0, $receiver) + ' ' + ro + ' ' + nullable + "</td>\n            </tr>\n";
            }
            {
                this.this$0 = gapDocGenerator;
                super(1);
            }
        }), (int)30, null);
        String tableFooter = "\n        </table>\n";
        object = this;
        StringBuilder $receiver3 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $receiver3.append(header);
        $receiver3.append(description);
        $receiver3.append(tableHeader);
        $receiver3.append(tableBody2);
        $receiver3.append(tableFooter);
        $receiver3.append(footer);
        String string5 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
        string = string5;
        return super.withProcessedEntityLinks(string);
    }

    static /* synthetic */ String generateDoc$default(GapDocGenerator gapDocGenerator, GEntityType gEntityType, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return gapDocGenerator.generateDoc(gEntityType, string, string2);
    }

    private final String ref(@NotNull GTypeReference $receiver) {
        StringBuilder stringBuilder;
        String string;
        String prefix = $receiver.getCardinality().getMulti() ? "Array of " : "";
        GType t = $receiver.getType();
        if (t == null) {
            string = "TODO provide documentation for type";
        } else {
            String typeName = t.getTypeName();
            String typeNamePluralized = $receiver.getCardinality().getMulti() ? this.getPlural(typeName) : typeName;
            string = t instanceof GPrimitiveType ? typeNamePluralized : "<a href=\"" + this.getReferenceName(t) + ".xml\">" + typeNamePluralized + "</a>";
        }
        String body = string;
        StringBuilder $receiver2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $receiver2.append(prefix);
        $receiver2.append(body);
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final String getPlural(@NotNull String $receiver) {
        return StringsKt.endsWith$default((String)$receiver, (String)"s", (boolean)false, (int)2, null) ? $receiver + "es" : (StringsKt.endsWith$default((String)$receiver, (String)"y", (boolean)false, (int)2, null) ? StringsKt.removeSuffix((String)$receiver, (CharSequence)"y") + "ies" : $receiver + "s");
    }

    /*
     * WARNING - void declaration
     */
    private final String toLowerCaseWords(@NotNull GEntityType $receiver, boolean lastPlural) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<String> words = this.getWords($receiver);
        int last = words.size() - 1;
        Iterable iterable = $receiver$iv = (Iterable)words;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            void var17_17;
            void word;
            void index;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            String string2 = (String)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl = false;
            if (lastPlural && index == last) {
                String string3;
                var17_17 = word;
                GapDocGenerator gapDocGenerator = this;
                void v0 = var17_17;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v0.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                string = gapDocGenerator.getPlural(string3);
            } else {
                void v2 = var17_17 = word;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = v2.toLowerCase();
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            }
            String string5 = string;
            collection2.add(string5);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    static /* synthetic */ String toLowerCaseWords$default(GapDocGenerator gapDocGenerator, GEntityType gEntityType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return gapDocGenerator.toLowerCaseWords(gEntityType, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final String toCaptionWords(@NotNull GEntityType $receiver, boolean lastPlural) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<String> words = this.getWords($receiver);
        int last = words.size() - 1;
        Iterable iterable = $receiver$iv = (Iterable)words;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void word;
            void index;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            String string = (String)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl = false;
            String string2 = lastPlural && index == last ? this.getPlural(StringsKt.capitalize((String)word)) : StringsKt.capitalize((String)word);
            collection2.add(string2);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    static /* synthetic */ String toCaptionWords$default(GapDocGenerator gapDocGenerator, GEntityType gEntityType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return gapDocGenerator.toCaptionWords(gEntityType, bl);
    }

    private final List<String> getWords(@NotNull GEntityType $receiver) {
        CharSequence charSequence = $receiver.getTypeName();
        Regex regex = CAMEL_REGEX;
        int n = 0;
        return regex.split(charSequence, n);
    }

    private final String getIdPlaceholder(@NotNull GEntityType $receiver) {
        String string = (String)CollectionsKt.last(this.getWords($receiver));
        StringBuilder stringBuilder = new StringBuilder().append('{');
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        return stringBuilder.append(string4).append("ID}").toString();
    }

    private final String toResourceId(@NotNull GResource $receiver, String parentResourcePath) {
        String string;
        switch ($receiver.getResourceType()) {
            case "ApplyCommandResource": {
                string = "-apply";
                break;
            }
            case "CommandAssistResource": {
                string = "-assist";
                break;
            }
            default: {
                string = "";
            }
        }
        String suffix = string;
        return "resource-" + this.toId($receiver, parentResourcePath) + suffix;
    }

    private final String toOperationsId(@NotNull GResource $receiver, String parentResourcePath) {
        return "operations-" + this.toId($receiver, parentResourcePath);
    }

    private final String toId(@NotNull GResource $receiver, String parentResourcePath) {
        return StringsKt.removePrefix((String)StringsKt.removeSuffix((String)StringsKt.replace$default((String)(parentResourcePath + '/' + $receiver.getPath().getBase()), (String)"/", (String)"-", (boolean)false, (int)4, null), (CharSequence)"-"), (CharSequence)"-");
    }

    private final String getRelativePath(@NotNull GResource $receiver) {
        String string;
        StringBuilder stringBuilder;
        block3: {
            block2: {
                stringBuilder = new StringBuilder().append($receiver.getPath().getBase());
                string = $receiver.getPath().getSegmentName();
                if (string == null) break block2;
                String string2 = string;
                StringBuilder stringBuilder2 = stringBuilder;
                String it = string2;
                boolean bl = false;
                String string3 = '/' + it;
                stringBuilder = stringBuilder2;
                string = string3;
                if (string != null) break block3;
            }
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    private final String getRelativePathWithId(@NotNull GResource $receiver) {
        return this.getHasMethodAll($receiver) ? this.getRelativePath($receiver) + '/' + this.getIdPlaceholder($receiver.getEntityType()) : this.getRelativePath($receiver);
    }

    private final boolean getHasEntityMethods(@NotNull GResource $receiver) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = $receiver.getMethods();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    GMethodInfo it = (GMethodInfo)element$iv;
                    boolean bl2 = false;
                    if (!METHODS_ON_ENTITIES.contains((Object)it.getMethod())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean getHasMethodAll(@NotNull GResource $receiver) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = $receiver.getMethods();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    GMethodInfo it = (GMethodInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.getMethod() == GHttpMethod.GET_ALL)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String getRelativePathWithId(@NotNull GMethodInfo $receiver, GResource resource) {
        return METHODS_ON_ENTITIES.contains((Object)$receiver.getMethod()) ? this.getRelativePath(resource) + '/' + this.getIdPlaceholder(resource.getEntityType()) : this.getRelativePath(resource);
    }

    private final String getAnchorIn(@NotNull GMethodInfo $receiver, GResource resource) {
        String string = $receiver.getMethod().name();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        return stringBuilder.append(string4).append('-').append(resource.getEntityType().getTypeName()).append("-method").toString();
    }

    private final String getDocOrEmpty(@NotNull GDoc $receiver, String id) {
        String string = $receiver.getDoc();
        if (string == null) {
            String string2;
            String it = string2 = "";
            boolean bl = false;
            GDoc gDoc = $receiver;
            String where = gDoc instanceof GResource ? "resource: " + ((GResource)$receiver).getResourceType() + '<' + ((GResource)$receiver).getEntityType().getTypeName() + '>' : (gDoc instanceof GEntityType ? "entity: " + ((GEntityType)$receiver).getTypeName() : (gDoc instanceof GMethodInfo ? "method " + ((GMethodInfo)$receiver).getMethod().name() : $receiver.toString()));
            Companion.getLogger().error((Function0)new Function0<String>(where, $receiver, id){
                final /* synthetic */ String $where;
                final /* synthetic */ GDoc $this_getDocOrEmpty$inlined;
                final /* synthetic */ String $id$inlined;
                {
                    this.$where = string;
                    this.$this_getDocOrEmpty$inlined = gDoc;
                    this.$id$inlined = string2;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "ATTENTION: missing doc in " + this.$where + " for " + this.$id$inlined;
                }
            });
            string = string2;
        }
        return string;
    }

    private final String getDocOrTodo(@NotNull GDoc $receiver) {
        String string = $receiver.getDoc();
        if (string == null) {
            string = "TODO provide documentation";
        }
        return string;
    }

    private final String withProcessedEntityLinks(@NotNull String $receiver) {
        CharSequence charSequence = $receiver;
        Regex regex = ENTITY_LINK_REGEX;
        String string = "<a href=\"$1.xml\">$1</a>";
        return regex.replace(charSequence, string);
    }

    static {
        Companion = new Companion(null);
        CAMEL_REGEX = new Regex("(?<=[a-z])(?=[A-Z])");
        ENTITY_LINK_REGEX = new Regex("@@([a-zA-Z_$][a-zA-Z\\d-_$]*)");
        METHODS_ON_COLLECTIONS = SetsKt.setOf((Object[])new GHttpMethod[]{GHttpMethod.GET_ALL, GHttpMethod.CREATE});
        METHODS_ON_ENTITIES = ArraysKt.subtract((Object[])GHttpMethod.values(), (Iterable)METHODS_ON_COLLECTIONS);
    }

    public static final /* synthetic */ String access$getRelativePath$p(GapDocGenerator $this, GResource $receiver) {
        return $this.getRelativePath($receiver);
    }

    public static final /* synthetic */ String access$toResourceId(GapDocGenerator $this, GResource $receiver, String parentResourcePath) {
        return $this.toResourceId($receiver, parentResourcePath);
    }

    public static final /* synthetic */ boolean access$getHasEntityMethods$p(GapDocGenerator $this, GResource $receiver) {
        return $this.getHasEntityMethods($receiver);
    }

    public static final /* synthetic */ String access$toOperationsId(GapDocGenerator $this, GResource $receiver, String parentResourcePath) {
        return $this.toOperationsId($receiver, parentResourcePath);
    }

    public static final /* synthetic */ String access$generateDoc(GapDocGenerator $this, GResource $receiver, String parentResourcePath, boolean asOperationsContainer, boolean unique) {
        return $this.generateDoc($receiver, parentResourcePath, asOperationsContainer, unique);
    }

    public static final /* synthetic */ String access$getAnchorIn(GapDocGenerator $this, GMethodInfo $receiver, GResource resource) {
        return $this.getAnchorIn($receiver, resource);
    }

    public static final /* synthetic */ String access$title(GapDocGenerator $this, GHttpMethod $receiver, GType type) {
        return $this.title($receiver, type);
    }

    public static final /* synthetic */ String access$generateDoc(GapDocGenerator $this, GMethodInfo $receiver, GResource resource, String parentResourcePath) {
        return $this.generateDoc($receiver, resource, parentResourcePath);
    }

    public static final /* synthetic */ String access$asTableRaw(GapDocGenerator $this, GMethodQueryParameter $receiver) {
        return $this.asTableRaw($receiver);
    }

    public static final /* synthetic */ String access$toCodeBlock(GapDocGenerator $this, String $receiver, String title, String lang) {
        return $this.toCodeBlock($receiver, title, lang);
    }

    public static final /* synthetic */ String access$ref(GapDocGenerator $this, GTypeReference $receiver) {
        return $this.ref($receiver);
    }

    public static final /* synthetic */ String access$getDocOrTodo$p(GapDocGenerator $this, GDoc $receiver) {
        return $this.getDocOrTodo($receiver);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/gaprest/doc/model/GapDocGenerator$SubResourceLinkDescriptor;", "", "fullPath", "", "fileName", "typeName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "getFullPath", "getTypeName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "youtrack-gap-doc"})
    private static final class SubResourceLinkDescriptor {
        @NotNull
        private final String fullPath;
        @NotNull
        private final String fileName;
        @NotNull
        private final String typeName;

        @NotNull
        public final String getFullPath() {
            return this.fullPath;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }

        public SubResourceLinkDescriptor(@NotNull String fullPath, @NotNull String fileName, @NotNull String typeName) {
            Intrinsics.checkParameterIsNotNull((Object)fullPath, (String)"fullPath");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
            this.fullPath = fullPath;
            this.fileName = fileName;
            this.typeName = typeName;
        }

        @NotNull
        public final String component1() {
            return this.fullPath;
        }

        @NotNull
        public final String component2() {
            return this.fileName;
        }

        @NotNull
        public final String component3() {
            return this.typeName;
        }

        @NotNull
        public final SubResourceLinkDescriptor copy(@NotNull String fullPath, @NotNull String fileName, @NotNull String typeName) {
            Intrinsics.checkParameterIsNotNull((Object)fullPath, (String)"fullPath");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
            return new SubResourceLinkDescriptor(fullPath, fileName, typeName);
        }

        @NotNull
        public static /* synthetic */ SubResourceLinkDescriptor copy$default(SubResourceLinkDescriptor subResourceLinkDescriptor, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = subResourceLinkDescriptor.fullPath;
            }
            if ((n & 2) != 0) {
                string2 = subResourceLinkDescriptor.fileName;
            }
            if ((n & 4) != 0) {
                string3 = subResourceLinkDescriptor.typeName;
            }
            return subResourceLinkDescriptor.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SubResourceLinkDescriptor(fullPath=" + this.fullPath + ", fileName=" + this.fileName + ", typeName=" + this.typeName + ")";
        }

        public int hashCode() {
            String string = this.fullPath;
            String string2 = this.fileName;
            String string3 = this.typeName;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SubResourceLinkDescriptor)) break block3;
                    SubResourceLinkDescriptor subResourceLinkDescriptor = (SubResourceLinkDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.fullPath, (Object)subResourceLinkDescriptor.fullPath) || !Intrinsics.areEqual((Object)this.fileName, (Object)subResourceLinkDescriptor.fileName) || !Intrinsics.areEqual((Object)this.typeName, (Object)subResourceLinkDescriptor.typeName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/gaprest/doc/model/GapDocGenerator$Companion;", "Lmu/KLogging;", "()V", "API_PREFIX", "", "CAMEL_REGEX", "Lkotlin/text/Regex;", "COMMON_STUFF", "COMMON_TOPIC_ATTRIBUTES", "ENTITY_LINK_REGEX", "METHODS_ON_COLLECTIONS", "", "Ljetbrains/youtrack/gaprest/doc/model/GHttpMethod;", "getMETHODS_ON_COLLECTIONS", "()Ljava/util/Set;", "METHODS_ON_ENTITIES", "getMETHODS_ON_ENTITIES", "SKIP", "TAB", "TOP", "main", "", "args", "", "([Ljava/lang/String;)V", "youtrack-gap-doc"})
    public static final class Companion
    extends KLogging {
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            ModelCollector modelCollector = new ModelCollector();
            new GapDocGenerator().generate(modelCollector.getGTypesHolder().getAllTypes(), modelCollector.getGResources(), args[0]);
        }

        @NotNull
        public final Set<GHttpMethod> getMETHODS_ON_COLLECTIONS() {
            return METHODS_ON_COLLECTIONS;
        }

        @NotNull
        public final Set<GHttpMethod> getMETHODS_ON_ENTITIES() {
            return METHODS_ON_ENTITIES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

