/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.ldap.dnq.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class LDAPSSLContextFactoryHolder
extends SocketFactory {
    private static ThreadLocal<SocketFactory> CURRENT = new ThreadLocal();
    private final SocketFactory delegate;

    public LDAPSSLContextFactoryHolder(SocketFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.delegate.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.delegate.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.delegate.createSocket(host, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.delegate.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.delegate.createSocket(address, port, localAddress, localPort);
    }

    public static SocketFactory getDefault() {
        SocketFactory factory = CURRENT.get();
        if (factory == null) {
            throw new IllegalStateException("SSLFactory is not set in current context");
        }
        return new LDAPSSLContextFactoryHolder(factory);
    }

    public static void set(SocketFactory factory) {
        CURRENT.set(factory);
    }

    public static void unset() {
        CURRENT.remove();
    }
}

