/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.ldap.dnq.client;

import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.InvalidSearchFilterException;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapHelpersKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nBC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012*\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f0\u000b\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\u0002\u0010\rB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapAuthenticationException;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "code", "", "message", "cause", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "params", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "", "Lkotlin/Pair;", "(Ljava/lang/String;Ljava/lang/String;[Lkotlin/Pair;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "Companion", "jetbrains.jetpass.auth.module.ldap.dnq"})
public final class LdapAuthenticationException
extends jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException {
    @NotNull
    public static final String AUTH_FAILED = "ldap-auth-failed";
    @NotNull
    public static final String USER_FETCH_FAILED = "ldap-user-fetch";
    @NotNull
    public static final String BIND_USER_MISSING = "ldap-bind-user-missing";
    @NotNull
    public static final String BIND_USER_INVALID = "ldap-bind-user-invalid";
    @NotNull
    public static final String INVALID_FILTER = "ldap-invalid-filter";
    public static final Companion Companion = new Companion(null);

    public LdapAuthenticationException(@NotNull String code, @NotNull String message, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        super(code, message, cause, null, 8, null);
    }

    public LdapAuthenticationException(@NotNull String code, @NotNull String message, @NotNull Map<String, String> params) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        super(code, message, params);
    }

    public LdapAuthenticationException(@NotNull String code, @NotNull String message, Pair<String, String> ... params) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        this(code, message, MapsKt.toMap(params));
    }

    public LdapAuthenticationException(@NotNull String code, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        super(code, message, null, 4, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0010J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapAuthenticationException$Companion;", "", "()V", "AUTH_FAILED", "", "BIND_USER_INVALID", "BIND_USER_MISSING", "INVALID_FILTER", "USER_FETCH_FAILED", "bindUserInvalid", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapAuthenticationException;", "ex", "Ljavax/naming/AuthenticationException;", "bindUserMissing", "cantGetUser", "e", "Ljavax/naming/NamingException;", "getCommunicationExceptionMessage", "Ljavax/naming/CommunicationException;", "tryParse", "source", "getVeryRootCause", "", "jetbrains.jetpass.auth.module.ldap.dnq"})
    public static final class Companion {
        @Nullable
        public final LdapAuthenticationException tryParse(@NotNull NamingException source) {
            Throwable root;
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Throwable throwable = root = this.getVeryRootCause(source);
            return throwable instanceof UnknownHostException ? new LdapAuthenticationException(LdapAuthenticationException.AUTH_FAILED, "Cannot connect to LDAP server. Host is unknown: " + root.getMessage(), source) : (throwable instanceof CommunicationException ? new LdapAuthenticationException(LdapAuthenticationException.AUTH_FAILED, "Cannot connect to LDAP server. " + this.getCommunicationExceptionMessage((CommunicationException)root), source) : (throwable instanceof ServiceUnavailableException ? new LdapAuthenticationException(LdapAuthenticationException.AUTH_FAILED, "LDAP service unavailable", source) : (throwable instanceof InvalidSearchFilterException ? new LdapAuthenticationException(LdapAuthenticationException.INVALID_FILTER, "Error in the LDAP search filter: " + root.getMessage(), source) : null)));
        }

        @NotNull
        public final LdapAuthenticationException cantGetUser(@NotNull NamingException e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            StringBuilder stringBuilder = new StringBuilder().append("LDAP failure: ");
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            return new LdapAuthenticationException(LdapAuthenticationException.USER_FETCH_FAILED, stringBuilder.append(string).toString(), e);
        }

        @NotNull
        public final LdapAuthenticationException bindUserMissing() {
            return new LdapAuthenticationException(LdapAuthenticationException.BIND_USER_MISSING, "Binding via the bind user failed. Bind user DN or password is missing.");
        }

        @NotNull
        public final LdapAuthenticationException bindUserInvalid(@NotNull AuthenticationException ex) {
            Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
            String message = LdapHelpersKt.getMappedMessage(ex);
            return new LdapAuthenticationException(LdapAuthenticationException.BIND_USER_INVALID, "Binding with LDAP failed. " + message, ex);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getCommunicationExceptionMessage(CommunicationException ex) {
            String string;
            String string2;
            Throwable rootCause = ex.getRootCause();
            if (rootCause == null) {
                String string3 = ex.getMessage();
                string2 = string3;
                if (string3 == null) return "unknown host";
                return string2;
            }
            if (rootCause instanceof ConnectException) {
                String string4 = rootCause.getMessage();
                if (string4 != null) {
                    if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"Connection timed out: connect", (boolean)false, (int)2, null)) {
                        string2 = Intrinsics.stringPlus((String)ex.getMessage(), (Object)" connection timed out");
                        return string2;
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append(ex.getMessage());
            String string5 = rootCause.getMessage();
            if (string5 != null) {
                String string6 = string5;
                StringBuilder stringBuilder2 = stringBuilder;
                String it = string6;
                String string7 = ' ' + it;
                stringBuilder = stringBuilder2;
                string = string7;
            } else {
                string = null;
            }
            string2 = stringBuilder.append(string).toString();
            return string2;
        }

        private final Throwable getVeryRootCause(@NotNull NamingException $receiver) {
            Throwable throwable = $receiver.getCause();
            Throwable it = throwable;
            Throwable throwable2 = it;
            return throwable2 == null ? (Throwable)$receiver : (throwable2 instanceof CommunicationException ? it : (throwable2 instanceof NamingException ? Companion.getVeryRootCause((NamingException)it) : it));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

