/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.ldap.dnq.client;

import java.util.List;
import jetbrains.jetpass.auth.module.ldap.api.user.details.LdapUserDetailsImpl;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapClient;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapClientFactory;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapClientImpl;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapContext;
import jetbrains.jetpass.auth.module.ldap.dnq.xd.XdLdapAuthModule;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClientFactoryImpl;", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClientFactory;", "context", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapContext;", "(Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapContext;)V", "createClient", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClient;", "xdAuthModule", "Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;", "useOldLdapUserIdScheme", "", "LdapClientMockProxy", "jetbrains.jetpass.auth.module.ldap.dnq"})
public final class LdapClientFactoryImpl
implements LdapClientFactory {
    private final LdapContext context;

    @Override
    @NotNull
    public LdapClient createClient(@NotNull XdLdapAuthModule xdAuthModule, boolean useOldLdapUserIdScheme) {
        LdapClient ldapClient;
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdAuthModule), (String)"xdAuthModule");
        LdapClientImpl client = new LdapClientImpl(xdAuthModule, useOldLdapUserIdScheme);
        LdapContext ldapContext = this.context;
        if (ldapContext != null) {
            LdapContext ldapContext2;
            LdapContext it = ldapContext2 = ldapContext;
            ldapClient = new LdapClientMockProxy(it, client);
        } else {
            ldapClient = client;
        }
        return ldapClient;
    }

    public LdapClientFactoryImpl(@Nullable LdapContext context2) {
        this.context = context2;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClientFactoryImpl$LdapClientMockProxy;", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClient;", "context", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapContext;", "client", "(Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapContext;Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClient;)V", "getClient", "()Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClient;", "getContext", "()Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapContext;", "getGroups", "", "", "requestLDAP", "Ljetbrains/jetpass/auth/module/ldap/api/user/details/LdapUserDetailsImpl;", "username", "password", "jetbrains.jetpass.auth.module.ldap.dnq"})
    private static final class LdapClientMockProxy
    implements LdapClient {
        @NotNull
        private final LdapContext context;
        @NotNull
        private final LdapClient client;

        @Override
        @Nullable
        public LdapUserDetailsImpl requestLDAP(@NotNull String username, @NotNull String password) {
            Function2<String, String, LdapUserDetailsImpl> function2;
            Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            Function2<String, String, LdapUserDetailsImpl> it = function2 = this.context.getRequestLdapByCredentials();
            return it != null ? (LdapUserDetailsImpl)it.invoke((Object)username, (Object)password) : this.client.requestLDAP(username, password);
        }

        @Override
        @NotNull
        public List<String> getGroups() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public final LdapContext getContext() {
            return this.context;
        }

        @NotNull
        public final LdapClient getClient() {
            return this.client;
        }

        public LdapClientMockProxy(@NotNull LdapContext context2, @NotNull LdapClient client) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            this.context = context2;
            this.client = client;
        }
    }
}

