/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.ldap.dnq.client;

import java.util.List;
import jetbrains.jetpass.auth.module.ldap.api.user.details.LdapUserDetailsImpl;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapAuthenticationException;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapClient;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.BindUserLdapAuthenticator;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.DynamicLdapAuthenticator;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.LdapAuthenticator;
import jetbrains.jetpass.auth.module.ldap.dnq.xd.XdLdapAuthModule;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClientImpl;", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClient;", "authSetting", "Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;", "useOldLdapUserIdScheme", "", "(Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;Z)V", "getAuthenticator", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/LdapAuthenticator;", "getGroups", "", "", "requestLDAP", "Ljetbrains/jetpass/auth/module/ldap/api/user/details/LdapUserDetailsImpl;", "username", "password", "Companion", "jetbrains.jetpass.auth.module.ldap.dnq"})
public final class LdapClientImpl
implements LdapClient {
    private final XdLdapAuthModule authSetting;
    private final boolean useOldLdapUserIdScheme;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public LdapUserDetailsImpl requestLDAP(@NotNull String username, @NotNull String password) throws LdapAuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Companion.getLogger().info((Function0)new Function0<String>(username){
            final /* synthetic */ String $username;

            @NotNull
            public final String invoke() {
                return this.$username + ": auth in LDAP";
            }
            {
                this.$username = string;
                super(0);
            }
        });
        LdapAuthenticator authenticator = this.getAuthenticator();
        return authenticator.authenticate(username, password);
    }

    @Override
    @NotNull
    public List<String> getGroups() {
        LdapAuthenticator authenticator = this.getAuthenticator();
        return authenticator.getGroups();
    }

    private final LdapAuthenticator getAuthenticator() {
        LdapAuthenticator ldapAuthenticator;
        if (this.authSetting.getUseBindUser()) {
            if (this.authSetting.getBindUserLogin() == null || this.authSetting.getBindUserPassword() == null) {
                throw (Throwable)((Object)LdapAuthenticationException.Companion.bindUserMissing());
            }
            ldapAuthenticator = new BindUserLdapAuthenticator(this.authSetting, this.useOldLdapUserIdScheme);
        } else {
            ldapAuthenticator = new DynamicLdapAuthenticator(this.authSetting, this.useOldLdapUserIdScheme);
        }
        return ldapAuthenticator;
    }

    public LdapClientImpl(@NotNull XdLdapAuthModule authSetting, boolean useOldLdapUserIdScheme) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)authSetting), (String)"authSetting");
        this.authSetting = authSetting;
        this.useOldLdapUserIdScheme = useOldLdapUserIdScheme;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/LdapClientImpl$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.auth.module.ldap.dnq"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

