/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators;

import java.io.Closeable;
import java.util.List;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapAuthenticationException;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.BindCredentials;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.LdapAuthenticator;
import jetbrains.jetpass.auth.module.ldap.dnq.xd.XdLdapAuthModule;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/BindUserLdapAuthenticator;", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/LdapAuthenticator;", "authSetting", "Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;", "useOldUserIdScheme", "", "(Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;Z)V", "authenticateUser", "userCn", "", "password", "getBindCredentials", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/BindCredentials;", "username", "getGroups", "", "logAuthenticationStart", "", "jetbrains.jetpass.auth.module.ldap.dnq"})
public final class BindUserLdapAuthenticator
extends LdapAuthenticator {
    @Override
    public void logAuthenticationStart(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        LdapAuthenticator.Companion.getLogger().info((Function0)new Function0<String>(this, username){
            final /* synthetic */ BindUserLdapAuthenticator this$0;
            final /* synthetic */ String $username;

            @NotNull
            public final String invoke() {
                return "Bind user [" + this.this$0.getAuthSetting().getBindUserLogin() + "] will be used to bind to LDAP for the authentication of [" + this.$username + ']';
            }
            {
                this.this$0 = bindUserLdapAuthenticator;
                this.$username = string;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public BindCredentials getBindCredentials(@NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        return this.getBindCredentials();
    }

    @Override
    @NotNull
    public List<String> getGroups() {
        BindCredentials bindCredentials = this.getBindCredentials();
        LdapAuthenticator.CloseableDirContext closeableDirContext = this.bindUser(bindCredentials);
        if (closeableDirContext == null) {
            return CollectionsKt.emptyList();
        }
        LdapAuthenticator.CloseableDirContext bindContext = closeableDirContext;
        return this.getGroups(bindContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticateUser(@NotNull String userCn, @NotNull String password) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)userCn, (String)"userCn");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        LdapAuthenticator.CloseableDirContext closeableDirContext = this.bindUser(new BindCredentials(userCn, password));
        if (closeableDirContext != null) {
            Closeable closeable = closeableDirContext;
            Throwable throwable = null;
            try {
                LdapAuthenticator.CloseableDirContext it = (LdapAuthenticator.CloseableDirContext)closeable;
                LdapAuthenticator.Companion.getLogger().info((Function0)new Function0<String>(userCn){
                    final /* synthetic */ String $userCn$inlined;
                    {
                        this.$userCn$inlined = string;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "User DN [" + this.$userCn$inlined + "] was successfully authenticated in LDAP";
                    }
                });
                boolean bl2 = true;
                bl = bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final BindCredentials getBindCredentials() {
        String bindLogin = this.getAuthSetting().getBindUserLogin();
        String bindPassword = this.getAuthSetting().getBindUserPassword();
        if (bindLogin == null || bindPassword == null) {
            throw (Throwable)((Object)LdapAuthenticationException.Companion.bindUserMissing());
        }
        return new BindCredentials(bindLogin, bindPassword);
    }

    public BindUserLdapAuthenticator(@NotNull XdLdapAuthModule authSetting, boolean useOldUserIdScheme) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)authSetting), (String)"authSetting");
        super(authSetting, useOldUserIdScheme);
    }
}

