/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators;

import java.util.List;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapAuthenticationException;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.BindCredentials;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.LdapAuthenticator;
import jetbrains.jetpass.auth.module.ldap.dnq.xd.XdLdapAuthModule;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\tH\u0016\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/DynamicLdapAuthenticator;", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/LdapAuthenticator;", "authSetting", "Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;", "useOldUserIdScheme", "", "(Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;Z)V", "authenticateUser", "userCn", "", "password", "bindUser", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/LdapAuthenticator$CloseableDirContext;", "credentials", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/BindCredentials;", "constructDN", "username", "getBindCredentials", "getGroups", "", "logAuthenticationStart", "", "jetbrains.jetpass.auth.module.ldap.dnq"})
public final class DynamicLdapAuthenticator
extends LdapAuthenticator {
    @Override
    public void logAuthenticationStart(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        LdapAuthenticator.Companion.getLogger().info((Function0)new Function0<String>(username){
            final /* synthetic */ String $username;

            @NotNull
            public final String invoke() {
                return "User [" + this.$username + "] will be used to bind to LDAP";
            }
            {
                this.$username = string;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public List<String> getGroups() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public BindCredentials getBindCredentials(@NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        String bindLogin = this.constructDN(username);
        return new BindCredentials(bindLogin, password);
    }

    private final String constructDN(String username) {
        String string;
        CharSequence charSequence = this.getAuthSetting().getFormatDN();
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string2 = this.getAuthSetting().getFormatDN();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.replace$default((String)string2, (String)"%u", (String)username, (boolean)false, (int)4, null);
        } else {
            string = username;
        }
        return string;
    }

    @Override
    public boolean authenticateUser(@NotNull String userCn, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)userCn, (String)"userCn");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        return true;
    }

    @Override
    @Nullable
    protected LdapAuthenticator.CloseableDirContext bindUser(@NotNull BindCredentials credentials) {
        LdapAuthenticator.CloseableDirContext closeableDirContext;
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        try {
            closeableDirContext = super.bindUser(credentials);
        }
        catch (LdapAuthenticationException ex) {
            LdapAuthenticator.Companion.getLogger().info((Throwable)((Object)ex), (Function0)new Function0<String>(credentials){
                final /* synthetic */ BindCredentials $credentials;

                @NotNull
                public final String invoke() {
                    return "Can't bind to LDAP with [" + this.$credentials.getUsername() + ']';
                }
                {
                    this.$credentials = bindCredentials;
                    super(0);
                }
            });
            closeableDirContext = null;
        }
        return closeableDirContext;
    }

    public DynamicLdapAuthenticator(@NotNull XdLdapAuthModule authSetting, boolean useOldUserIdScheme) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)authSetting), (String)"authSetting");
        super(authSetting, useOldUserIdScheme);
    }
}

