/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.ssl.SSLContext;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.api.authority.profile.JabberContact;
import jetbrains.jetpass.auth.module.ldap.api.user.details.LdapUserDetailsImpl;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LDAPSSLContextFactoryHolder;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapAuthenticationException;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapClientImpl;
import jetbrains.jetpass.auth.module.ldap.dnq.client.LdapHelpersKt;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.BindCredentials;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.LdapAuthenticator;
import jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.NamingEnumerationCloseable;
import jetbrains.jetpass.auth.module.ldap.dnq.xd.XdLdapAuthModule;
import jetbrains.jetpass.pojo.api.authority.profile.EmailContactImpl;
import jetbrains.jetpass.pojo.api.authority.profile.JabberContactImpl;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b \u0018\u0000 82\u00020\u0001:\u000278B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH&J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH&J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H&J\u001e\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\f0\f0\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\fH&J\u001c\u0010\u001e\u001a\u00020\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010 H\u0002J0\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0018\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\fH\u0002J*\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0)2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\fH\u0002J*\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0)2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\fH\u0002J)\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010-2\u0006\u0010.\u001a\u00020\f2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-00H\u0002\u00a2\u0006\u0002\u00101J\u001e\u00102\u001a\b\u0012\u0004\u0012\u0002H-0$\"\u0004\b\u0000\u0010-*\b\u0012\u0004\u0012\u0002H-03H\u0002J1\u00102\u001a\u00020\u0011*\u00020\u001b2\u001e\u00104\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u001d0005\"\b\u0012\u0004\u0012\u00020\u001d00H\u0002\u00a2\u0006\u0002\u00106R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/LdapAuthenticator;", "", "authSetting", "Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;", "useOldUserIdScheme", "", "(Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;Z)V", "getAuthSetting", "()Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;", "authenticate", "Ljetbrains/jetpass/auth/module/ldap/api/user/details/LdapUserDetailsImpl;", "usernameWithDomain", "", "password", "authenticateUser", "userCn", "bindUser", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/LdapAuthenticator$CloseableDirContext;", "credentials", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/BindCredentials;", "constructSearchFilter", "username", "getBindCredentials", "getGroups", "", "kotlin.jvm.PlatformType", "context", "Ljavax/naming/directory/DirContext;", "logAuthenticationStart", "", "logEnvironment", "env", "Ljava/util/Hashtable;", "readDetails", "filter", "results", "Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/NamingEnumerationCloseable;", "Ljavax/naming/directory/SearchResult;", "retrieveAttributes", "searchResult", "searchRecord", "Lkotlin/Pair;", "rawFilter", "searchRecordByUsername", "withNamingExceptionHandling", "T", "message", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "asCloseable", "Ljavax/naming/NamingEnumeration;", "beforeCloseActions", "", "(Ljavax/naming/directory/DirContext;[Lkotlin/jvm/functions/Function0;)Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/LdapAuthenticator$CloseableDirContext;", "CloseableDirContext", "Companion", "jetbrains.jetpass.auth.module.ldap.dnq"})
public abstract class LdapAuthenticator {
    @NotNull
    private final XdLdapAuthModule authSetting;
    private final boolean useOldUserIdScheme;
    @NotNull
    private static final KLogger logger;
    @NotNull
    public static final String USERNAME_PLACEHOLDER = "%u";
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LdapUserDetailsImpl authenticate(@NotNull String usernameWithDomain, @NotNull String password) {
        void filter;
        Intrinsics.checkParameterIsNotNull((Object)usernameWithDomain, (String)"usernameWithDomain");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        String username = StringsKt.substringAfter$default((String)usernameWithDomain, (String)"\\", null, (int)2, null);
        this.logAuthenticationStart(username);
        BindCredentials bindCredentials = this.getBindCredentials(username, password);
        CloseableDirContext closeableDirContext = this.bindUser(bindCredentials);
        if (closeableDirContext == null) {
            return null;
        }
        CloseableDirContext bindContext = closeableDirContext;
        Pair<String, NamingEnumerationCloseable<SearchResult>> pair = this.searchRecordByUsername(bindContext, username);
        String string = (String)pair.component1();
        NamingEnumerationCloseable results = (NamingEnumerationCloseable)pair.component2();
        return this.readDetails(username, password, (String)filter, results);
    }

    @NotNull
    public abstract List<String> getGroups();

    private final LdapUserDetailsImpl readDetails(String username, String password, String filter, NamingEnumerationCloseable<SearchResult> results) {
        return (LdapUserDetailsImpl)this.withNamingExceptionHandling("Read search results", (Function0)new Function0<LdapUserDetailsImpl>(this, results, filter, password, username){
            final /* synthetic */ LdapAuthenticator this$0;
            final /* synthetic */ NamingEnumerationCloseable $results;
            final /* synthetic */ String $filter;
            final /* synthetic */ String $password;
            final /* synthetic */ String $username;

            @Nullable
            public final LdapUserDetailsImpl invoke() {
                String userDn;
                if (!jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.LdapAuthenticator$Companion.access$hasMoreSafe(LdapAuthenticator.Companion, this.$results)) {
                    LdapAuthenticator.Companion.getLogger().debug((Function0)new Function0<String>(this){
                        final /* synthetic */ readDetails.1 this$0;

                        @NotNull
                        public final String invoke() {
                            return "No user was found by query [" + this.this$0.$filter + ']';
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                    return null;
                }
                SearchResult searchResult = (SearchResult)this.$results.next();
                if (jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.LdapAuthenticator$Companion.access$hasMoreSafe(LdapAuthenticator.Companion, this.$results)) {
                    LdapAuthenticator.Companion.getLogger().warn((Function0)new Function0<String>(this){
                        final /* synthetic */ readDetails.1 this$0;

                        @NotNull
                        public final String invoke() {
                            return "Multiple results are not supported. Filter: " + this.this$0.$filter + ". Only the first entry will be fetched.";
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                SearchResult searchResult2 = searchResult;
                Intrinsics.checkExpressionValueIsNotNull((Object)searchResult2, (String)"searchResult");
                String string = userDn = searchResult2.getNameInNamespace();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"userDn");
                if (!this.this$0.authenticateUser(string, this.$password)) {
                    LdapAuthenticator.Companion.getLogger().debug((Function0)new Function0<String>(userDn){
                        final /* synthetic */ String $userDn;

                        @NotNull
                        public final String invoke() {
                            return "User [" + this.$userDn + "] was found but the provided password is wrong";
                        }
                        {
                            this.$userDn = string;
                            super(0);
                        }
                    });
                    return null;
                }
                return LdapAuthenticator.access$retrieveAttributes(this.this$0, searchResult, this.$username);
            }
            {
                this.this$0 = ldapAuthenticator;
                this.$results = namingEnumerationCloseable;
                this.$filter = string;
                this.$password = string2;
                this.$username = string3;
                super(0);
            }
        });
    }

    @NotNull
    public abstract BindCredentials getBindCredentials(@NotNull String var1, @NotNull String var2);

    public abstract boolean authenticateUser(@NotNull String var1, @NotNull String var2);

    public abstract void logAuthenticationStart(@NotNull String var1);

    private final LdapUserDetailsImpl retrieveAttributes(SearchResult searchResult, String username) {
        String it;
        String string;
        String string2;
        LdapUserDetailsImpl ldapUserDetailsImpl;
        Attributes attributes = searchResult.getAttributes();
        LdapUserDetailsImpl $receiver = ldapUserDetailsImpl = new LdapUserDetailsImpl();
        if (this.useOldUserIdScheme) {
            string2 = username;
        } else {
            Attributes attributes2 = attributes;
            Intrinsics.checkExpressionValueIsNotNull((Object)attributes2, (String)"attributes");
            string2 = LdapAuthenticator.Companion.getSingleValue(attributes2, this.authSetting.getUserIdAttributeName());
            if (string2 == null) {
                string2 = username;
            }
        }
        $receiver.setUserid(string2);
        Attributes attributes3 = attributes;
        Intrinsics.checkExpressionValueIsNotNull((Object)attributes3, (String)"attributes");
        $receiver.setFullName(LdapAuthenticator.Companion.getConcatenatedValue(attributes3, this.authSetting.getFullNameAttributeName()));
        String string3 = LdapAuthenticator.Companion.getSingleValue(attributes, this.authSetting.getEmailAttributeName());
        if (string3 != null) {
            it = string = string3;
            $receiver.setEmail((EmailContact)new EmailContactImpl(it, true));
        }
        String string4 = LdapAuthenticator.Companion.getSingleValue(attributes, this.authSetting.getJabberAttributeName());
        if (string4 != null) {
            it = string = string4;
            $receiver.setJabber((JabberContact)new JabberContactImpl(it, true));
        }
        $receiver.setVCSName(LdapAuthenticator.Companion.getSingleValue(attributes, this.authSetting.getVcsNameAttributeName()));
        $receiver.setLdapGroupNames(LdapAuthenticator.Companion.getListValue(attributes, this.authSetting.getGroupsAttributeName()));
        return ldapUserDetailsImpl;
    }

    private final Pair<String, NamingEnumerationCloseable<SearchResult>> searchRecordByUsername(DirContext context2, String username) {
        String rawFilter = this.constructSearchFilter(username);
        return this.searchRecord(context2, rawFilter);
    }

    private final Pair<String, NamingEnumerationCloseable<SearchResult>> searchRecord(DirContext context2, String rawFilter) {
        return (Pair)this.withNamingExceptionHandling("Search user in the tree", (Function0)new Function0<Pair<? extends String, ? extends NamingEnumerationCloseable<SearchResult>>>(this, rawFilter, context2){
            final /* synthetic */ LdapAuthenticator this$0;
            final /* synthetic */ String $rawFilter;
            final /* synthetic */ DirContext $context;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<String, NamingEnumerationCloseable<SearchResult>> invoke() {
                Pair pair;
                void $receiver$iv;
                SearchControls searchControls;
                SearchControls $receiver = searchControls = new SearchControls();
                $receiver.setSearchScope(2);
                Collection collection = CollectionsKt.listOfNotNull((Object[])new String[]{this.this$0.getAuthSetting().getEmailAttributeName(), this.this$0.getAuthSetting().getFullNameAttributeName(), this.this$0.getAuthSetting().getJabberAttributeName(), this.this$0.getAuthSetting().getVcsNameAttributeName(), this.this$0.getAuthSetting().getUserIdAttributeName(), this.this$0.getAuthSetting().getGroupsAttributeName()});
                SearchControls searchControls2 = $receiver;
                void v0 = $receiver$iv;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v0;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray2 = stringArray;
                searchControls2.setReturningAttributes(stringArray2);
                SearchControls searchControls3 = searchControls;
                String filter = LdapHelpersKt.fixLdapFilter(this.$rawFilter);
                LdapAuthenticator.Companion.getLogger().info((Function0)new Function0<String>(filter){
                    final /* synthetic */ String $filter;

                    @NotNull
                    public final String invoke() {
                        return "Searching by the filter: " + this.$filter;
                    }
                    {
                        this.$filter = string;
                        super(0);
                    }
                });
                try {
                    NamingEnumeration<SearchResult> namingEnumeration = this.$context.search("", filter, searchControls3);
                    Intrinsics.checkExpressionValueIsNotNull(namingEnumeration, (String)"context.search(\"\", filter, searchControls)");
                    pair = TuplesKt.to((Object)filter, (Object)LdapAuthenticator.access$asCloseable(this.this$0, namingEnumeration));
                }
                catch (InvalidSearchFilterException ex) {
                    LdapAuthenticator.Companion.getLogger().warn((Function0)new Function0<String>(filter){
                        final /* synthetic */ String $filter;

                        @NotNull
                        public final String invoke() {
                            return "Provided filter " + this.$filter + " expression is invalid";
                        }
                        {
                            this.$filter = string;
                            super(0);
                        }
                    });
                    throw (Throwable)ex;
                }
                return pair;
            }
            {
                this.this$0 = ldapAuthenticator;
                this.$rawFilter = string;
                this.$context = dirContext;
                super(0);
            }
        });
    }

    @NotNull
    protected final List<String> getGroups(@NotNull DirContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        return (List)this.withNamingExceptionHandling("Get all groups", (Function0)new Function0<List<? extends String>>(context2){
            final /* synthetic */ DirContext $context;

            @NotNull
            public final List<String> invoke() {
                SearchControls searchControls;
                SearchControls $receiver = searchControls = new SearchControls();
                $receiver.setSearchScope(2);
                $receiver.setReturningAttributes(new String[0]);
                SearchControls searchControls2 = searchControls;
                LdapAuthenticator.Companion.getLogger().info((Function0)getGroups.1.INSTANCE);
                NamingEnumeration<SearchResult> answer = this.$context.search("", "(|(objectClass=groupOfUniqueNames)(objectClass=GroupOfNames)(objectClass=group))", searchControls2);
                return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<SearchResult>(answer){
                    final /* synthetic */ NamingEnumeration $answer;

                    @Nullable
                    public final SearchResult invoke() {
                        NamingEnumeration namingEnumeration = this.$answer;
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingEnumeration, (String)"answer");
                        return jetbrains.jetpass.auth.module.ldap.dnq.client.authenticators.LdapAuthenticator$Companion.access$hasMoreSafe(LdapAuthenticator.Companion, namingEnumeration) ? (SearchResult)this.$answer.next() : null;
                    }
                    {
                        this.$answer = namingEnumeration;
                        super(0);
                    }
                })), (Function1)getGroups.3.INSTANCE));
            }
            {
                this.$context = dirContext;
                super(0);
            }
        });
    }

    private final String constructSearchFilter(String username) {
        String string;
        CharSequence charSequence = this.authSetting.getFilter();
        if (charSequence == null || charSequence.length() == 0) {
            string = this.authSetting.getUserIdAttributeName() + '=' + username;
        } else {
            String string2 = this.authSetting.getFilter();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.replace$default((String)string2, (String)USERNAME_PLACEHOLDER, (String)username, (boolean)false, (int)4, null);
        }
        return string;
    }

    @Nullable
    protected CloseableDirContext bindUser(@NotNull BindCredentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        return (CloseableDirContext)this.withNamingExceptionHandling("Bind user", (Function0)new Function0<CloseableDirContext>(this, credentials){
            final /* synthetic */ LdapAuthenticator this$0;
            final /* synthetic */ BindCredentials $credentials;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CloseableDirContext invoke() {
                void var3_2;
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                Map<String, String> $receiver = hashtable;
                ((Hashtable)$receiver).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                ((Hashtable)$receiver).put("java.naming.security.authentication", "simple");
                ((Hashtable)$receiver).put("java.naming.provider.url", this.this$0.getAuthSetting().getUrl());
                ((Hashtable)$receiver).put("java.naming.security.principal", this.$credentials.getUsername());
                ((Hashtable)$receiver).put("java.naming.security.credentials", this.$credentials.getPassword());
                ((Hashtable)$receiver).put("java.naming.referral", this.this$0.getAuthSetting().getReferralIgnored() ? "ignore" : "follow");
                ((Hashtable)$receiver).put("com.sun.jndi.ldap.connect.timeout", String.valueOf(this.this$0.getAuthSetting().getConnectionTimeout()));
                ((Hashtable)$receiver).put("com.sun.jndi.ldap.read.timeout", String.valueOf(this.this$0.getAuthSetting().getReadTimeout()));
                Hashtable<String, String> env = hashtable;
                SSLContext sslContext = this.this$0.getAuthSetting().getSSLContext();
                if (sslContext != null) {
                    $receiver = env;
                    String string = "java.naming.ldap.factory.socket";
                    String string2 = LDAPSSLContextFactoryHolder.class.getName();
                    $receiver.put(string, string2);
                    LDAPSSLContextFactoryHolder.set(sslContext.getSocketFactory());
                }
                LdapAuthenticator.access$logEnvironment(this.this$0, env);
                CloseableDirContext context2 = LdapAuthenticator.access$asCloseable(this.this$0, new InitialDirContext(env), (Function0)new Function0<Unit>(sslContext){
                    final /* synthetic */ SSLContext $sslContext;

                    public final void invoke() {
                        if (this.$sslContext != null) {
                            LDAPSSLContextFactoryHolder.unset();
                        }
                    }
                    {
                        this.$sslContext = sSLContext;
                        super(0);
                    }
                });
                LdapAuthenticator.Companion.getLogger().info((Function0)new Function0<String>(this){
                    final /* synthetic */ bindUser.1 this$0;

                    @NotNull
                    public final String invoke() {
                        return "Bind with [" + this.this$0.$credentials.getUsername() + "] is successful";
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                return var3_2;
            }
            {
                this.this$0 = ldapAuthenticator;
                this.$credentials = bindCredentials;
                super(0);
            }
        });
    }

    private final void logEnvironment(Hashtable<String, Object> env) {
        Map map = MapsKt.toMutableMap((Map)env);
        Map $receiver = map;
        if ($receiver.get("java.naming.security.credentials") != null) {
            Map map2 = $receiver;
            String string = "java.naming.security.credentials";
            String string2 = "***";
            map2.put(string, string2);
        }
        Map safeEnv = map;
        logger.debug((Function0)new Function0<String>(safeEnv){
            final /* synthetic */ Map $safeEnv;

            @NotNull
            public final String invoke() {
                return "Binding LDAP with environment: " + this.$safeEnv;
            }
            {
                this.$safeEnv = map;
                super(0);
            }
        });
    }

    private final <T> T withNamingExceptionHandling(String message, Function0<? extends T> action) {
        try {
            return (T)action.invoke();
        }
        catch (AuthenticationException ex) {
            throw (Throwable)((Object)LdapAuthenticationException.Companion.bindUserInvalid(ex));
        }
        catch (NamingException ex) {
            logger.warn((Throwable)ex, (Function0)new Function0<String>(message){
                final /* synthetic */ String $message;

                @NotNull
                public final String invoke() {
                    return this.$message + " failed";
                }
                {
                    this.$message = string;
                    super(0);
                }
            });
            LdapAuthenticationException ldapAuthenticationException = LdapAuthenticationException.Companion.tryParse(ex);
            throw ldapAuthenticationException != null ? (Throwable)((Object)ldapAuthenticationException) : (Throwable)((Object)LdapAuthenticationException.Companion.cantGetUser(ex));
        }
    }

    private final CloseableDirContext asCloseable(@NotNull DirContext $receiver, Function0<Unit> ... beforeCloseActions) {
        return new CloseableDirContext($receiver, Arrays.copyOf(beforeCloseActions, beforeCloseActions.length));
    }

    private final <T> NamingEnumerationCloseable<T> asCloseable(@NotNull NamingEnumeration<T> $receiver) {
        return new NamingEnumerationCloseable<T>($receiver);
    }

    @NotNull
    public final XdLdapAuthModule getAuthSetting() {
        return this.authSetting;
    }

    public LdapAuthenticator(@NotNull XdLdapAuthModule authSetting, boolean useOldUserIdScheme) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)authSetting), (String)"authSetting");
        this.authSetting = authSetting;
        this.useOldUserIdScheme = useOldUserIdScheme;
    }

    static {
        Companion = new Companion(null);
        String string = LdapClientImpl.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LdapClientImpl::class.java.name");
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @NotNull
    public static final /* synthetic */ LdapUserDetailsImpl access$retrieveAttributes(LdapAuthenticator $this, @NotNull SearchResult searchResult, @NotNull String username) {
        return $this.retrieveAttributes(searchResult, username);
    }

    @NotNull
    public static final /* synthetic */ NamingEnumerationCloseable access$asCloseable(LdapAuthenticator $this, @NotNull NamingEnumeration $receiver) {
        return $this.asCloseable($receiver);
    }

    public static final /* synthetic */ void access$logEnvironment(LdapAuthenticator $this, @NotNull Hashtable env) {
        $this.logEnvironment(env);
    }

    @NotNull
    public static final /* synthetic */ CloseableDirContext access$asCloseable(LdapAuthenticator $this, @NotNull DirContext $receiver, Function0 ... beforeCloseActions) {
        return $this.asCloseable($receiver, beforeCloseActions);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u001e\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\"\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ1\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J)\u0010\u0010\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J9\u0010\u0010\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\u0012\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J)\u0010\u0010\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J9\u0010\u0010\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\u0012\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\b\u0010\u0014\u001a\u00020\u0007H\u0016J1\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J1\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J!\u0010\u0016\u001a\n \f*\u0004\u0018\u00010\u00170\u00172\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J1\u0010\u0016\u001a\n \f*\u0004\u0018\u00010\u00010\u00012\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J!\u0010\u0016\u001a\n \f*\u0004\u0018\u00010\u00170\u00172\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J1\u0010\u0016\u001a\n \f*\u0004\u0018\u00010\u00010\u00012\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0019\u0010\u0018\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J\u0019\u0010\u0018\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J!\u0010\u0019\u001a\n \f*\u0004\u0018\u00010\u00130\u00132\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001JT\u0010\u0019\u001a\n \f*\u0004\u0018\u00010\u00130\u00132\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112,\u0010\u000f\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00050\u0005H\u0096\u0001\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u0019\u001a\n \f*\u0004\u0018\u00010\u00130\u00132\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001JT\u0010\u0019\u001a\n \f*\u0004\u0018\u00010\u00130\u00132\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2,\u0010\u000f\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00050\u0005H\u0096\u0001\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \f*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001d0\u001dH\u0096\u0001J\u0011\u0010\u001e\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J!\u0010\u001f\u001a\n \f*\u0004\u0018\u00010 0 2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J!\u0010\u001f\u001a\n \f*\u0004\u0018\u00010 0 2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J!\u0010!\u001a\n \f*\u0004\u0018\u00010\u00010\u00012\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J!\u0010!\u001a\n \f*\u0004\u0018\u00010\u00010\u00012\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J!\u0010\"\u001a\n \f*\u0004\u0018\u00010\u00010\u00012\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J!\u0010\"\u001a\n \f*\u0004\u0018\u00010\u00010\u00012\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J=\u0010#\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010%0% \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010%0%\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J=\u0010#\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010%0% \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010%0%\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J=\u0010&\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010'0' \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010'0'\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J=\u0010&\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010'0' \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010'0'\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J!\u0010(\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J!\u0010(\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J!\u0010)\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J!\u0010)\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001JL\u0010*\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112,\u0010\u000f\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010+0+ \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010+0+\u0018\u00010\u00050\u0005H\u0096\u0001\u00a2\u0006\u0002\u0010,J1\u0010*\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u000f\u001a\u00020-2\u000e\u0010\u0012\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001JL\u0010*\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2,\u0010\u000f\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010+0+ \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010+0+\u0018\u00010\u00050\u0005H\u0096\u0001\u00a2\u0006\u0002\u0010.J1\u0010*\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u000f\u001a\u00020-2\u000e\u0010\u0012\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J)\u0010/\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J9\u0010/\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\u0012\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J)\u0010/\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J9\u0010/\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\u0012\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J!\u00100\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J)\u00101\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J)\u00101\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001JM\u00102\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010303 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010303\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0080\u0001\u00102\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010303 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010303\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00130\u00132,\u0010\u0012\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00050\u0005H\u0096\u0001\u00a2\u0006\u0002\u00104J]\u00102\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010303 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010303\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u0012\u001a\n \f*\u0004\u0018\u00010505H\u0096\u0001J\u0090\u0001\u00102\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010303 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010303\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2,\u0010\u0012\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00050\u00052\u000e\u00106\u001a\n \f*\u0004\u0018\u00010505H\u0096\u0001\u00a2\u0006\u0002\u00107JM\u00102\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010303 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010303\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0096\u0001J\u0080\u0001\u00102\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010303 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010303\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00130\u00132,\u0010\u0012\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00050\u0005H\u0096\u0001\u00a2\u0006\u0002\u00108J]\u00102\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010303 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010303\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u0012\u001a\n \f*\u0004\u0018\u00010505H\u0096\u0001J\u0090\u0001\u00102\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010303 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010303\u0018\u00010$0$2\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e2,\u0010\u0012\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00050\u00052\u000e\u00106\u001a\n \f*\u0004\u0018\u00010505H\u0096\u0001\u00a2\u0006\u0002\u00109J\u0019\u0010:\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J\u0019\u0010:\u001a\u00020\u00072\u000e\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001R\u001e\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/LdapAuthenticator$CloseableDirContext;", "Ljavax/naming/directory/DirContext;", "Ljava/io/Closeable;", "context", "beforeCloseActions", "", "Lkotlin/Function0;", "", "(Ljavax/naming/directory/DirContext;[Lkotlin/jvm/functions/Function0;)V", "[Lkotlin/jvm/functions/Function0;", "addToEnvironment", "", "kotlin.jvm.PlatformType", "p0", "", "p1", "bind", "Ljavax/naming/Name;", "p2", "Ljavax/naming/directory/Attributes;", "close", "composeName", "createSubcontext", "Ljavax/naming/Context;", "destroySubcontext", "getAttributes", "(Ljavax/naming/Name;[Ljava/lang/String;)Ljavax/naming/directory/Attributes;", "(Ljava/lang/String;[Ljava/lang/String;)Ljavax/naming/directory/Attributes;", "getEnvironment", "Ljava/util/Hashtable;", "getNameInNamespace", "getNameParser", "Ljavax/naming/NameParser;", "getSchema", "getSchemaClassDefinition", "list", "Ljavax/naming/NamingEnumeration;", "Ljavax/naming/NameClassPair;", "listBindings", "Ljavax/naming/Binding;", "lookup", "lookupLink", "modifyAttributes", "Ljavax/naming/directory/ModificationItem;", "(Ljavax/naming/Name;[Ljavax/naming/directory/ModificationItem;)V", "", "(Ljava/lang/String;[Ljavax/naming/directory/ModificationItem;)V", "rebind", "removeFromEnvironment", "rename", "search", "Ljavax/naming/directory/SearchResult;", "(Ljavax/naming/Name;Ljavax/naming/directory/Attributes;[Ljava/lang/String;)Ljavax/naming/NamingEnumeration;", "Ljavax/naming/directory/SearchControls;", "p3", "(Ljavax/naming/Name;Ljava/lang/String;[Ljava/lang/Object;Ljavax/naming/directory/SearchControls;)Ljavax/naming/NamingEnumeration;", "(Ljava/lang/String;Ljavax/naming/directory/Attributes;[Ljava/lang/String;)Ljavax/naming/NamingEnumeration;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;Ljavax/naming/directory/SearchControls;)Ljavax/naming/NamingEnumeration;", "unbind", "jetbrains.jetpass.auth.module.ldap.dnq"})
    protected static final class CloseableDirContext
    implements DirContext,
    Closeable {
        private final DirContext context;
        private final Function0<Unit>[] beforeCloseActions;

        @Override
        public void close() {
            try {
                Function0<Unit>[] $receiver$iv;
                Function0<Unit>[] function0Array = $receiver$iv = this.beforeCloseActions;
                int n = function0Array.length;
                for (int i = 0; i < n; ++i) {
                    Function0<Unit> element$iv;
                    Function0<Unit> it = element$iv = function0Array[i];
                    it.invoke();
                }
                this.context.close();
            }
            catch (NamingException ex) {
                Companion.getLogger().error((Throwable)ex, (Function0)close.2.INSTANCE);
            }
        }

        public CloseableDirContext(@NotNull DirContext context2, Function0<Unit> ... beforeCloseActions) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull(beforeCloseActions, (String)"beforeCloseActions");
            this.context = context2;
            this.beforeCloseActions = beforeCloseActions;
        }

        @Override
        public Object addToEnvironment(String p0, Object p1) {
            return this.context.addToEnvironment(p0, p1);
        }

        @Override
        public void bind(Name p0, Object p1) {
            this.context.bind(p0, p1);
        }

        @Override
        public void bind(Name p0, Object p1, Attributes p2) {
            this.context.bind(p0, p1, p2);
        }

        @Override
        public void bind(String p0, Object p1) {
            this.context.bind(p0, p1);
        }

        @Override
        public void bind(String p0, Object p1, Attributes p2) {
            this.context.bind(p0, p1, p2);
        }

        @Override
        public Name composeName(Name p0, Name p1) {
            return this.context.composeName(p0, p1);
        }

        @Override
        public String composeName(String p0, String p1) {
            return this.context.composeName(p0, p1);
        }

        @Override
        public Context createSubcontext(Name p0) {
            return this.context.createSubcontext(p0);
        }

        @Override
        public DirContext createSubcontext(Name p0, Attributes p1) {
            return this.context.createSubcontext(p0, p1);
        }

        @Override
        public Context createSubcontext(String p0) {
            return this.context.createSubcontext(p0);
        }

        @Override
        public DirContext createSubcontext(String p0, Attributes p1) {
            return this.context.createSubcontext(p0, p1);
        }

        @Override
        public void destroySubcontext(Name p0) {
            this.context.destroySubcontext(p0);
        }

        @Override
        public void destroySubcontext(String p0) {
            this.context.destroySubcontext(p0);
        }

        @Override
        public Attributes getAttributes(Name p0) {
            return this.context.getAttributes(p0);
        }

        @Override
        public Attributes getAttributes(Name p0, String[] p1) {
            return this.context.getAttributes(p0, p1);
        }

        @Override
        public Attributes getAttributes(String p0) {
            return this.context.getAttributes(p0);
        }

        @Override
        public Attributes getAttributes(String p0, String[] p1) {
            return this.context.getAttributes(p0, p1);
        }

        @Override
        public Hashtable<?, ?> getEnvironment() {
            return this.context.getEnvironment();
        }

        @Override
        public String getNameInNamespace() {
            return this.context.getNameInNamespace();
        }

        @Override
        public NameParser getNameParser(Name p0) {
            return this.context.getNameParser(p0);
        }

        @Override
        public NameParser getNameParser(String p0) {
            return this.context.getNameParser(p0);
        }

        @Override
        public DirContext getSchema(Name p0) {
            return this.context.getSchema(p0);
        }

        @Override
        public DirContext getSchema(String p0) {
            return this.context.getSchema(p0);
        }

        @Override
        public DirContext getSchemaClassDefinition(Name p0) {
            return this.context.getSchemaClassDefinition(p0);
        }

        @Override
        public DirContext getSchemaClassDefinition(String p0) {
            return this.context.getSchemaClassDefinition(p0);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name p0) {
            return this.context.list(p0);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String p0) {
            return this.context.list(p0);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name p0) {
            return this.context.listBindings(p0);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String p0) {
            return this.context.listBindings(p0);
        }

        @Override
        public Object lookup(Name p0) {
            return this.context.lookup(p0);
        }

        @Override
        public Object lookup(String p0) {
            return this.context.lookup(p0);
        }

        @Override
        public Object lookupLink(Name p0) {
            return this.context.lookupLink(p0);
        }

        @Override
        public Object lookupLink(String p0) {
            return this.context.lookupLink(p0);
        }

        @Override
        public void modifyAttributes(Name p0, ModificationItem[] p1) {
            this.context.modifyAttributes(p0, p1);
        }

        @Override
        public void modifyAttributes(Name p0, int p1, Attributes p2) {
            this.context.modifyAttributes(p0, p1, p2);
        }

        @Override
        public void modifyAttributes(String p0, ModificationItem[] p1) {
            this.context.modifyAttributes(p0, p1);
        }

        @Override
        public void modifyAttributes(String p0, int p1, Attributes p2) {
            this.context.modifyAttributes(p0, p1, p2);
        }

        @Override
        public void rebind(Name p0, Object p1) {
            this.context.rebind(p0, p1);
        }

        @Override
        public void rebind(Name p0, Object p1, Attributes p2) {
            this.context.rebind(p0, p1, p2);
        }

        @Override
        public void rebind(String p0, Object p1) {
            this.context.rebind(p0, p1);
        }

        @Override
        public void rebind(String p0, Object p1, Attributes p2) {
            this.context.rebind(p0, p1, p2);
        }

        @Override
        public Object removeFromEnvironment(String p0) {
            return this.context.removeFromEnvironment(p0);
        }

        @Override
        public void rename(Name p0, Name p1) {
            this.context.rename(p0, p1);
        }

        @Override
        public void rename(String p0, String p1) {
            this.context.rename(p0, p1);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name p0, Attributes p1) {
            return this.context.search(p0, p1);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name p0, Attributes p1, String[] p2) {
            return this.context.search(p0, p1, p2);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name p0, String p1, SearchControls p2) {
            return this.context.search(p0, p1, p2);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name p0, String p1, Object[] p2, SearchControls p3) {
            return this.context.search(p0, p1, p2, p3);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String p0, Attributes p1) {
            return this.context.search(p0, p1);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String p0, Attributes p1, String[] p2) {
            return this.context.search(p0, p1, p2);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String p0, String p1, SearchControls p2) {
            return this.context.search(p0, p1, p2);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String p0, String p1, Object[] p2, SearchControls p3) {
            return this.context.search(p0, p1, p2, p3);
        }

        @Override
        public void unbind(Name p0) {
            this.context.unbind(p0);
        }

        @Override
        public void unbind(String p0) {
            this.context.unbind(p0);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\u0004*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\r*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u0004*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/client/authenticators/LdapAuthenticator$Companion;", "", "()V", "USERNAME_PLACEHOLDER", "", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "getConcatenatedValue", "Ljavax/naming/directory/Attributes;", "attributeName", "getListValue", "", "getSingleValue", "hasMoreSafe", "", "T", "Ljavax/naming/NamingEnumeration;", "jetbrains.jetpass.auth.module.ldap.dnq"})
    public static final class Companion {
        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        private final String getConcatenatedValue(@NotNull Attributes $receiver, String attributeName) throws NamingException {
            CharSequence charSequence;
            if (attributeName == null || (charSequence = (CharSequence)attributeName).length() == 0) {
                return null;
            }
            Attribute attribute = $receiver.get(attributeName);
            if (attribute == null) {
                return null;
            }
            Attribute attribute2 = attribute;
            NamingEnumeration<?> namingEnumeration = attribute2.getAll();
            if (namingEnumeration == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.naming.NamingEnumeration<kotlin.String>");
            }
            NamingEnumeration<?> values = namingEnumeration;
            if (!this.hasMoreSafe(values)) {
                return null;
            }
            Enumeration enumeration = values;
            return SequencesKt.joinToString$default((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }

        private final String getSingleValue(@NotNull Attributes $receiver, String attributeName) throws NamingException {
            CharSequence charSequence;
            if (attributeName == null || (charSequence = (CharSequence)attributeName).length() == 0) {
                return null;
            }
            Attribute attribute = $receiver.get(attributeName);
            if (attribute == null) {
                return null;
            }
            Attribute attribute2 = attribute;
            NamingEnumeration<?> namingEnumeration = attribute2.getAll();
            if (namingEnumeration == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.naming.NamingEnumeration<kotlin.String>");
            }
            NamingEnumeration<?> allValues = namingEnumeration;
            if (this.hasMoreSafe(allValues)) {
                String elementToAdd = (String)allValues.next();
                if (this.hasMoreSafe(allValues)) {
                    this.getLogger().warn((Function0)new Function0<String>(attributeName){
                        final /* synthetic */ String $attributeName;

                        @NotNull
                        public final String invoke() {
                            return "Multiple " + this.$attributeName + " are not supported";
                        }
                        {
                            this.$attributeName = string;
                            super(0);
                        }
                    });
                }
                return elementToAdd;
            }
            return null;
        }

        private final List<String> getListValue(@NotNull Attributes $receiver, String attributeName) throws NamingException {
            CharSequence charSequence;
            if (attributeName == null || (charSequence = (CharSequence)attributeName).length() == 0) {
                return null;
            }
            Attribute attribute = $receiver.get(attributeName);
            if (attribute == null) {
                return null;
            }
            Attribute attribute2 = attribute;
            NamingEnumeration<?> namingEnumeration = attribute2.getAll();
            if (namingEnumeration == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.naming.NamingEnumeration<kotlin.String>");
            }
            NamingEnumeration<?> values = namingEnumeration;
            if (!this.hasMoreSafe(values)) {
                return null;
            }
            Enumeration enumeration = values;
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
            return arrayList;
        }

        private final <T> boolean hasMoreSafe(@NotNull NamingEnumeration<T> $receiver) {
            boolean bl;
            try {
                bl = $receiver.hasMore();
            }
            catch (NamingException ex) {
                this.getLogger().warn((Throwable)ex, (Function0)new Function0<String>(ex){
                    final /* synthetic */ NamingException $ex;

                    @NotNull
                    public final String invoke() {
                        return "Error while fetching more results from LDAP: " + this.$ex.getMessage();
                    }
                    {
                        this.$ex = namingException;
                        super(0);
                    }
                });
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$hasMoreSafe(Companion $this, @NotNull NamingEnumeration $receiver) {
            return $this.hasMoreSafe($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

