/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.ldap.dnq.migration;

import java.util.List;
import jetbrains.jetpass.auth.module.ldap.dnq.migration.MakeLdapUserIdAttributeNameRequired;
import jetbrains.jetpass.auth.module.ldap.dnq.xd.XdLdapAuthModule;
import jetbrains.jetpass.userManagement.persistence.migration.PluggedMigrationImpl;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J\u0014\u0010\r\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\bH\u0002J\"\u0010\u000e\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/auth/module/ldap/dnq/migration/MakeLdapUserIdAttributeNameRequired;", "Ljetbrains/jetpass/userManagement/persistence/migration/PluggedMigrationImpl;", "()V", "logger", "Lmu/KLogger;", "apply", "", "guessIdNameManyPlaceholders", "", "Ljetbrains/jetpass/auth/module/ldap/dnq/xd/XdLdapAuthModule;", "filter", "matches", "", "guessIdNameNoPlaceholder", "guessIdNameSinglePlaceholder", "jetbrains.jetpass.auth.module.ldap.dnq"})
public final class MakeLdapUserIdAttributeNameRequired
extends PluggedMigrationImpl {
    private final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    public void apply() {
        String placeholder = "%u";
        Regex pattern = new Regex("(\\w[\\w.-]*)=" + placeholder);
        Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdLdapAuthModule.Companion), (Function2)apply.1.INSTANCE));
        for (Object element$iv : $receiver$iv) {
            String string;
            XdLdapAuthModule it = (XdLdapAuthModule)((Object)element$iv);
            String filter = it.getFilter();
            if (filter == null || StringsKt.isBlank((CharSequence)filter)) {
                this.logger.info((Function0)new Function0<String>(it){
                    final /* synthetic */ XdLdapAuthModule $it;

                    @NotNull
                    public final String invoke() {
                        return "The " + this.$it.getName() + " module has neither " + "filter" + ' ' + "nor " + "userIdAttributeName" + " properties set. " + "Fixed: " + "userIdAttributeName" + " is set to 'uid'";
                    }
                    {
                        this.$it = xdLdapAuthModule;
                        super(0);
                    }
                });
                it.setUserIdAttributeName("uid");
                continue;
            }
            List matches2 = CollectionsKt.distinct((Iterable)SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)pattern, (CharSequence)filter, (int)0, (int)2, null), (Function1)apply.2.matches.1.INSTANCE)));
            switch (matches2.size()) {
                case 0: {
                    string = this.guessIdNameNoPlaceholder(it, filter);
                    break;
                }
                case 1: {
                    string = this.guessIdNameSinglePlaceholder(it, filter, matches2);
                    break;
                }
                default: {
                    string = this.guessIdNameManyPlaceholders(it, filter, matches2);
                }
            }
            it.setUserIdAttributeName(string);
        }
    }

    private final String guessIdNameNoPlaceholder(@NotNull XdLdapAuthModule $receiver, String filter) {
        String idName = StringsKt.contains$default((CharSequence)filter, (CharSequence)"sAMAccountName", (boolean)false, (int)2, null) ? "sAMAccountName" : "uid";
        this.logger.warn((Function0)new Function0<String>($receiver, filter, idName){
            final /* synthetic */ XdLdapAuthModule receiver$0;
            final /* synthetic */ String $filter;
            final /* synthetic */ String $idName;

            @NotNull
            public final String invoke() {
                return "The " + this.receiver$0.getName() + " module's filter '" + this.$filter + "' has no username placeholder. So we're " + "doing an educated guess and set " + "userIdAttributeName" + " property " + "to '" + this.$idName + '\'';
            }
            {
                this.receiver$0 = xdLdapAuthModule;
                this.$filter = string;
                this.$idName = string2;
                super(0);
            }
        });
        return idName;
    }

    private final String guessIdNameSinglePlaceholder(@NotNull XdLdapAuthModule $receiver, String filter, List<String> matches2) {
        this.logger.info((Function0)new Function0<String>($receiver, matches2, filter){
            final /* synthetic */ XdLdapAuthModule receiver$0;
            final /* synthetic */ List $matches;
            final /* synthetic */ String $filter;

            @NotNull
            public final String invoke() {
                return "The " + this.receiver$0.getName() + " module got the " + "userIdAttributeName" + " property " + "set to '" + (String)CollectionsKt.single((List)this.$matches) + "' based on the filter value '" + this.$filter + '\'';
            }
            {
                this.receiver$0 = xdLdapAuthModule;
                this.$matches = list;
                this.$filter = string;
                super(0);
            }
        });
        return (String)CollectionsKt.single(matches2);
    }

    private final String guessIdNameManyPlaceholders(@NotNull XdLdapAuthModule $receiver, String filter, List<String> matches2) {
        String idName = matches2.contains("sAMAccountName") ? "sAMAccountName" : (matches2.contains("uid") ? "uid" : (String)CollectionsKt.first(matches2));
        this.logger.warn((Function0)new Function0<String>($receiver, filter, matches2, idName){
            final /* synthetic */ XdLdapAuthModule receiver$0;
            final /* synthetic */ String $filter;
            final /* synthetic */ List $matches;
            final /* synthetic */ String $idName;

            @NotNull
            public final String invoke() {
                return "The " + this.receiver$0.getName() + " module's filter '" + this.$filter + "' uses several different attributes with " + "the placeholder '%u': " + this.$matches + ". So we're doing an educated guess and set " + "userIdAttributeName" + " property to '" + this.$idName + '\'';
            }
            {
                this.receiver$0 = xdLdapAuthModule;
                this.$filter = string;
                this.$matches = list;
                this.$idName = string2;
                super(0);
            }
        });
        return idName;
    }
}

