/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.nio.ByteBuffer;
import org.gflogger.AbstractLocalLogEntry;
import org.gflogger.LoggerService;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.formatter.BufferFormatter;
import org.gflogger.helpers.OptionConverter;

abstract class AbstractBufferLocalLogEntry
extends AbstractLocalLogEntry {
    protected final ByteBuffer byteBuffer;

    public AbstractBufferLocalLogEntry(Thread owner, ObjectFormatterFactory formatterFactory, LoggerService loggerService, ByteBuffer byteBuffer) {
        this(owner, formatterFactory, loggerService, OptionConverter.getStringProperty("gflogger.errorMessage", ">>TRNCTD>>"), byteBuffer);
    }

    public AbstractBufferLocalLogEntry(Thread owner, ObjectFormatterFactory formatterFactory, LoggerService loggerService, String logErrorsMessage, ByteBuffer byteBuffer) {
        super(owner, formatterFactory, loggerService, logErrorsMessage);
        this.byteBuffer = byteBuffer;
    }

    protected static class BufferPurger
    implements Runnable {
        private final ByteBuffer buffer;

        public BufferPurger(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void run() {
            BufferFormatter.purge(this.buffer);
        }
    }
}

