/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gflogger.Appender;
import org.gflogger.LogEntryItemImpl;
import org.gflogger.helpers.LogLog;

public abstract class AbstractEntryHandler {
    protected final AtomicBoolean running = new AtomicBoolean();
    protected final Appender[] appenders;

    public AbstractEntryHandler(Appender[] appenders) {
        this.appenders = appenders;
    }

    protected void workerIsAboutToFinish() {
        for (int i = 0; i < this.appenders.length; ++i) {
            this.appenders[i].workerIsAboutToFinish();
        }
    }

    protected final void flushBuffer() {
        this.flushBuffer(true);
    }

    protected void flushBuffer(boolean force) {
        for (int i = 0; i < this.appenders.length; ++i) {
            this.appenders[i].flush(force);
        }
    }

    protected final void process(LogEntryItemImpl entry) {
        int idx = 0;
        for (long mask = entry.getAppenderMask(); mask != 0L; mask >>= 1) {
            if ((mask & 1L) != 0L) {
                try {
                    this.appenders[idx].process(entry);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            ++idx;
        }
    }

    public void start() {
        if (this.running.getAndSet(true)) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < this.appenders.length; ++i) {
            LogLog.debug("going to start appender " + this.appenders[i].getName());
            this.appenders[i].start();
        }
    }

    public void stop() {
        if (!this.running.getAndSet(false)) {
            return;
        }
        for (int i = 0; i < this.appenders.length; ++i) {
            LogLog.debug("going to stop appender " + this.appenders[i].getName());
            this.appenders[i].stop();
        }
    }
}

