/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.util.Iterator;
import org.gflogger.FormattedGFLogEntry;
import org.gflogger.GFLogEntry;
import org.gflogger.LocalLogEntry;
import org.gflogger.LogLevel;
import org.gflogger.Loggable;
import org.gflogger.LoggerService;
import org.gflogger.ObjectFormatter;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.helpers.LogLog;
import org.gflogger.helpers.OptionConverter;
import org.gflogger.util.StackTraceUtils;

abstract class AbstractLocalLogEntry
implements LocalLogEntry {
    protected String threadName;
    protected final LoggerService loggerService;
    protected final ObjectFormatterFactory formatterFactory;
    protected final String logErrorsMessage;
    protected String categoryName;
    protected LogLevel logLevel;
    protected long appenderMask;
    protected boolean commited = true;
    protected Throwable error;
    protected String pattern;
    protected int pPos;

    AbstractLocalLogEntry(ObjectFormatterFactory formatterFactory, LoggerService loggerService, String logErrorsMessage) {
        this.formatterFactory = formatterFactory;
        this.loggerService = loggerService;
        this.logErrorsMessage = logErrorsMessage;
    }

    public AbstractLocalLogEntry(Thread owner, ObjectFormatterFactory formatterFactory, LoggerService loggerService) {
        this(owner, formatterFactory, loggerService, OptionConverter.getStringProperty("gflogger.errorMessage", ">>TRNCTD>>"));
    }

    public AbstractLocalLogEntry(Thread owner, ObjectFormatterFactory formatterFactory, LoggerService loggerService, String logErrorsMessage) {
        this.threadName = owner.getName();
        this.formatterFactory = formatterFactory;
        this.loggerService = loggerService;
        this.logErrorsMessage = logErrorsMessage != null && logErrorsMessage.length() > 0 ? logErrorsMessage : null;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public boolean isCommited() {
        return this.commited;
    }

    @Override
    public void setCommited(boolean commited) {
        this.commited = commited;
    }

    @Override
    public long getAppenderMask() {
        return this.appenderMask;
    }

    @Override
    public void setAppenderMask(long appenderMask) {
        this.appenderMask = appenderMask;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public void setPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("expected not null pattern.");
        }
        this.pattern = pattern;
        this.pPos = 0;
        this.appendNextPatternChank();
    }

    protected void appendNextPatternChank() {
        int len = this.pattern.length();
        while (this.pPos < len) {
            char ch = this.pattern.charAt(this.pPos);
            if (ch == '%' && this.pPos + 1 < len) {
                if (this.pattern.charAt(this.pPos + 1) != '%') break;
                ++this.pPos;
            }
            this.append(ch);
            ++this.pPos;
        }
        if (this.pPos == len) {
            this.commit();
        }
    }

    protected void checkIfCommitted() {
        if (this.commited) {
            throw new IllegalStateException("Entry has been commited.");
        }
    }

    protected void checkPlaceholder() {
        this.checkIfCommitted();
        if (this.pattern == null) {
            throw new IllegalStateException("Entry has been commited.");
        }
        if (this.pPos + 1 >= this.pattern.length()) {
            throw new IllegalStateException("Illegal pattern '" + this.pattern + "' or position " + this.pPos);
        }
        char ch1 = this.pattern.charAt(this.pPos);
        char ch2 = this.pattern.charAt(this.pPos + 1);
        if (ch1 != '%' || ch2 != 's') {
            throw new IllegalArgumentException("Illegal pattern placeholder '" + ch1 + "" + ch2 + " at " + this.pPos);
        }
        this.pPos += 2;
    }

    protected void checkAndCommit() {
        if (this.commited) {
            return;
        }
        if (this.pPos + 1 != this.pattern.length()) {
            throw new IllegalStateException("The pattern has not been finished. More parameters are required.");
        }
        this.commit();
    }

    protected void error(String msg, Throwable e) {
        this.error = e;
        if (this.logErrorsMessage == null) {
            LogLog.error(msg + ":" + e.getMessage(), e);
        } else {
            this.moveAndAppendSilent(this.logErrorsMessage);
        }
    }

    protected abstract void moveAndAppendSilent(String var1);

    @Override
    public GFLogEntry append(Loggable loggable) {
        this.checkIfCommitted();
        if (loggable != null) {
            try {
                loggable.appendTo(this);
            }
            catch (Throwable e) {
                this.error("append(Loggable loggable)", e);
            }
        } else {
            this.append('n').append('u').append('l').append('l');
        }
        return this;
    }

    @Override
    public <T> GFLogEntry append(T[] array, String separator) {
        this.checkIfCommitted();
        if (array == null) {
            this.append('n').append('u').append('l').append('l');
        } else {
            try {
                this.append('[');
                ObjectFormatter formatter = null;
                for (int i = 0; i < array.length; ++i) {
                    T obj;
                    if (i > 0) {
                        this.append(separator);
                    }
                    if ((obj = array[i]) != null) {
                        if (formatter == null) {
                            formatter = this.formatterFactory.getObjectFormatter(obj);
                        }
                        formatter.append(obj, this);
                        continue;
                    }
                    this.append('n').append('u').append('l').append('l');
                }
                this.append(']');
            }
            catch (Throwable e) {
                this.error("append(Object o)", e);
            }
        }
        return this;
    }

    @Override
    public <T> GFLogEntry append(Iterable<T> iterable, String separator) {
        this.checkIfCommitted();
        if (iterable == null) {
            this.append('n').append('u').append('l').append('l');
        } else {
            try {
                this.append('[');
                ObjectFormatter formatter = null;
                Iterator<T> it = iterable.iterator();
                while (it.hasNext()) {
                    T obj = it.next();
                    if (obj != null) {
                        if (formatter == null) {
                            formatter = this.formatterFactory.getObjectFormatter(obj);
                        }
                        formatter.append(obj, this);
                    } else {
                        this.append('n').append('u').append('l').append('l');
                    }
                    if (!it.hasNext()) continue;
                    this.append(separator);
                }
                this.append(']');
            }
            catch (Throwable e) {
                this.error("append(Object o)", e);
            }
        }
        return this;
    }

    @Override
    public GFLogEntry append(Throwable e) {
        this.checkIfCommitted();
        if (e != null) {
            try {
                this.append(e.getClass().getName());
                String message = e.getLocalizedMessage();
                if (message != null) {
                    this.append(": ").append(message);
                }
                this.append('\n');
                StackTraceElement[] trace = e.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    this.append("\tat ").append(trace[i].getClassName()).append('.').append(trace[i].getMethodName());
                    this.append('(');
                    if (trace[i].isNativeMethod()) {
                        this.append("native)");
                    } else {
                        String fileName = trace[i].getFileName();
                        int lineNumber = trace[i].getLineNumber();
                        if (fileName != null) {
                            this.append(fileName);
                            if (lineNumber >= 0) {
                                this.append(':').append(lineNumber);
                            }
                            this.append(')');
                            Class clazz = StackTraceUtils.loadClass(trace[i].getClassName());
                            if (clazz != null) {
                                this.append('[').append(StackTraceUtils.getCodeLocation(clazz));
                                String implVersion = StackTraceUtils.getImplementationVersion(clazz);
                                if (implVersion != null) {
                                    this.append(':').append(implVersion);
                                }
                                this.append(']');
                            }
                        } else {
                            this.append("unknown");
                        }
                    }
                    this.append('\n');
                }
                Throwable cause = e.getCause();
                if (cause != null) {
                    this.append("\n caused by: \n");
                    this.append(cause);
                }
            }
            catch (Throwable t) {
                LogLog.error("append(Throwable e):" + t.getMessage(), t);
            }
        }
        return this;
    }

    @Override
    public GFLogEntry append(double v) {
        this.checkIfCommitted();
        this.append(v, 10);
        return this;
    }

    @Override
    public GFLogEntry append(Object o) {
        this.checkIfCommitted();
        try {
            if (o != null) {
                ObjectFormatter formatter = this.formatterFactory.getObjectFormatter(o);
                formatter.append(o, this);
            } else {
                this.append('n').append('u').append('l').append('l');
            }
        }
        catch (Throwable e) {
            this.error("append(Object o)", e);
        }
        return this;
    }

    @Override
    public void appendLast(char c) {
        this.append(c);
        this.commit();
    }

    @Override
    public void appendLast(CharSequence csq) {
        this.append(csq);
        this.commit();
    }

    @Override
    public void appendLast(CharSequence csq, int start, int end) {
        this.append(csq, start, end);
        this.commit();
    }

    @Override
    public void appendLast(boolean b) {
        this.append(b);
        this.commit();
    }

    @Override
    public void appendLast(int i) {
        this.append(i);
        this.commit();
    }

    @Override
    public void appendLast(long i) {
        this.append(i);
        this.commit();
    }

    @Override
    public void appendLast(double i) {
        this.append(i);
        this.commit();
    }

    @Override
    public void appendLast(double i, int precision) {
        this.append(i, precision);
        this.commit();
    }

    @Override
    public <T> void appendLast(T[] array, String separator) {
        this.append(array, separator);
        this.commit();
    }

    @Override
    public <T> void appendLast(Iterable<T> iterable, String separator) {
        this.append(iterable, separator);
        this.commit();
    }

    @Override
    public void appendLast(Throwable e) {
        this.append(e);
        this.commit();
    }

    @Override
    public void appendLast(Loggable loggable) {
        this.append(loggable);
        this.commit();
    }

    @Override
    public void appendLast(Object o) {
        this.append(o);
        this.commit();
    }

    @Override
    public FormattedGFLogEntry with(char c) {
        this.checkPlaceholder();
        this.append(c);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(CharSequence csq) {
        this.checkPlaceholder();
        this.append(csq);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(CharSequence csq, int start, int end) {
        this.checkPlaceholder();
        this.append(csq, start, end);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(boolean b) {
        this.checkPlaceholder();
        this.append(b);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(int i) {
        this.checkPlaceholder();
        this.append(i);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(long i) {
        this.checkPlaceholder();
        this.append(i);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(double i) {
        this.checkPlaceholder();
        this.append(i);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(double i, int precision) {
        this.checkPlaceholder();
        this.append(i, precision);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public <T> FormattedGFLogEntry with(T[] array, String separator) {
        this.checkPlaceholder();
        this.append(array, separator);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public <T> FormattedGFLogEntry with(Iterable<T> iterable, String separator) {
        this.checkPlaceholder();
        this.append(iterable, separator);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(Throwable e) {
        this.checkPlaceholder();
        this.append(e);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(Loggable loggable) {
        this.checkPlaceholder();
        this.append(loggable);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(Object o) {
        this.checkPlaceholder();
        this.append(o);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public void withLast(char c) {
        this.with(c);
        this.checkAndCommit();
    }

    @Override
    public void withLast(CharSequence csq) {
        this.with(csq);
        this.checkAndCommit();
    }

    @Override
    public void withLast(CharSequence csq, int start, int end) {
        this.with(csq, start, end);
        this.checkAndCommit();
    }

    @Override
    public void withLast(boolean b) {
        this.with(b);
        this.checkAndCommit();
    }

    @Override
    public void withLast(int i) {
        this.with(i);
        this.checkAndCommit();
    }

    @Override
    public void withLast(long i) {
        this.with(i);
        this.checkAndCommit();
    }

    @Override
    public void withLast(double i) {
        this.with(i);
        this.checkAndCommit();
    }

    @Override
    public void withLast(double i, int precision) {
        this.with(i, precision);
        this.checkAndCommit();
    }

    @Override
    public <T> void withLast(T[] array, String separator) {
        this.with(array, separator);
        this.checkAndCommit();
    }

    @Override
    public <T> void withLast(Iterable<T> iterable, String separator) {
        this.with(iterable, separator);
        this.checkAndCommit();
    }

    @Override
    public void withLast(Throwable e) {
        this.with(e);
        this.checkAndCommit();
    }

    @Override
    public void withLast(Loggable loggable) {
        this.with(loggable);
        this.checkAndCommit();
    }

    @Override
    public void withLast(Object o) {
        this.with(o);
        this.checkAndCommit();
    }

    @Override
    public void commit() {
        this.checkIfCommitted();
        this.commit0();
        this.loggerService.entryFlushed(this);
        this.commited = true;
        this.pattern = null;
        this.error = null;
    }

    protected abstract void commit0();
}

