/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gflogger.AbstractLocalLogEntry;
import org.gflogger.Appender;
import org.gflogger.ByteBufferLocalLogEntry;
import org.gflogger.ByteLocalLogEntry;
import org.gflogger.CharBufferLocalLogEntry;
import org.gflogger.DefaultObjectFormatterFactory;
import org.gflogger.FormattedGFLogEntry;
import org.gflogger.GFLogEntry;
import org.gflogger.GFLogger;
import org.gflogger.GFLoggerBuilder;
import org.gflogger.LocalLogEntry;
import org.gflogger.LogEntryItemImpl;
import org.gflogger.LogLevel;
import org.gflogger.LoggerService;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.appender.AppenderFactory;
import org.gflogger.disruptor.LoggerServiceImpl;
import org.gflogger.formatter.BufferFormatter;
import org.gflogger.helpers.LogLog;
import org.gflogger.helpers.OptionConverter;
import org.gflogger.util.NamedThreadFactory;

public abstract class AbstractLoggerServiceImpl
implements LoggerService {
    protected final LogLevel level;
    protected final Appender[] appenders;
    protected final GFLogger[] loggers;
    protected final ThreadLocal<LocalLogEntry> logEntryThreadLocal;
    protected final ExecutorService executorService;
    protected final boolean multibyte;
    protected volatile boolean running = false;

    public AbstractLoggerServiceImpl(int count, int maxMessageSize, ObjectFormatterFactory objectFormatterFactory, GFLogger[] loggers, Appender ... appenders) {
        if (appenders.length <= 0) {
            throw new IllegalArgumentException("Expected at least one appender");
        }
        this.loggers = loggers;
        this.appenders = appenders;
        this.multibyte = this.multibyte(appenders);
        final int maxMessageSize0 = this.multibyte ? maxMessageSize << 1 : maxMessageSize;
        final ObjectFormatterFactory formatterFactory = objectFormatterFactory != null ? objectFormatterFactory : new DefaultObjectFormatterFactory();
        this.level = this.initLogLevel(loggers);
        final AbstractLoggerServiceImpl service = this;
        final boolean typeOfByteBuffer = OptionConverter.getBooleanProperty("gflogger.bytebuffer", true);
        this.logEntryThreadLocal = new ThreadLocal<LocalLogEntry>(){

            @Override
            protected LocalLogEntry initialValue() {
                AbstractLocalLogEntry logEntry = AbstractLoggerServiceImpl.this.multibyte ? new CharBufferLocalLogEntry(Thread.currentThread(), maxMessageSize0, formatterFactory, (LoggerService)service) : (typeOfByteBuffer ? new ByteBufferLocalLogEntry(Thread.currentThread(), maxMessageSize0, formatterFactory, (LoggerService)service) : new ByteLocalLogEntry(Thread.currentThread(), maxMessageSize0, formatterFactory, service));
                return logEntry;
            }
        };
        this.executorService = this.initExecutorService();
    }

    protected static Appender[] createAppenders(AppenderFactory[] appenderFactories) {
        Appender[] appenders = new Appender[appenderFactories.length];
        for (int i = 0; i < appenders.length; ++i) {
            appenderFactories[i].setIndex(i);
            appenders[i] = appenderFactories[i].createAppender(LoggerServiceImpl.class);
        }
        return appenders;
    }

    protected static GFLogger[] createLoggers(AppenderFactory[] appenderFactories, GFLoggerBuilder[] loggerBuilders) {
        GFLogger[] loggers = new GFLogger[loggerBuilders.length];
        for (int i = 0; i < loggerBuilders.length; ++i) {
            loggers[i] = loggerBuilders[i].build();
        }
        return loggers;
    }

    protected final LogLevel initLogLevel(GFLogger ... loggers) {
        LogLevel level = LogLevel.FATAL;
        for (int i = 0; i < loggers.length; ++i) {
            LogLevel l = loggers[i].getLogLevel();
            level = !level.greaterThan(l) ? level : l;
        }
        return level;
    }

    protected final boolean multibyte(Appender ... appenders) {
        boolean multibyte = appenders[0].isMultibyte();
        for (int i = 1; i < appenders.length; ++i) {
            if (appenders[i].isMultibyte() == multibyte) continue;
            throw new IllegalArgumentException("Expected " + (multibyte ? "multibyte" : "single byte") + " mode for appender #" + i);
        }
        return multibyte;
    }

    protected abstract String name();

    protected ExecutorService initExecutorService() {
        return Executors.newFixedThreadPool(1, new NamedThreadFactory(this.name(), new String[0]));
    }

    protected LogEntryItemImpl[] initEnties(int count, int maxMessageSize) {
        int bufferSize = this.multibyte ? maxMessageSize << 1 : maxMessageSize;
        ByteBuffer buffer = BufferFormatter.allocate(count * bufferSize);
        LogEntryItemImpl[] entries = new LogEntryItemImpl[count];
        for (int i = 0; i < count; ++i) {
            buffer.limit((i + 1) * bufferSize);
            buffer.position(i * bufferSize);
            ByteBuffer subBuffer = buffer.slice();
            entries[i] = new LogEntryItemImpl(subBuffer, this.multibyte);
        }
        return entries;
    }

    protected void start() {
        for (int i = 0; i < this.appenders.length; ++i) {
            if (!this.appenders[i].isEnabled()) continue;
            this.appenders[i].start();
        }
        this.running = true;
    }

    @Override
    public GFLogEntry log(LogLevel level, String categoryName, long appenderMask) {
        if (!this.running) {
            throw new IllegalStateException("Logger was stopped.");
        }
        LocalLogEntry entry = this.logEntryThreadLocal.get();
        if (!entry.isCommited()) {
            LogLog.error("ERROR! log message '" + entry.stringValue() + "' at thread '" + entry.getThreadName() + "' has not been commited properly.");
            entry.commit();
        }
        entry.setCommited(false);
        entry.setLogLevel(level);
        entry.setCategoryName(categoryName);
        entry.setAppenderMask(appenderMask);
        entry.clear();
        return entry;
    }

    @Override
    public FormattedGFLogEntry formattedLog(LogLevel level, String categoryName, String pattern, long appenderMask) {
        if (!this.running) {
            throw new IllegalStateException("Logger was stopped.");
        }
        LocalLogEntry entry = this.logEntryThreadLocal.get();
        if (!entry.isCommited()) {
            LogLog.error("ERROR! log message '" + entry.stringValue() + "' at thread '" + entry.getThreadName() + "' has not been commited properly.");
            entry.commit();
        }
        entry.setCommited(false);
        entry.setLogLevel(level);
        entry.setCategoryName(categoryName);
        entry.setAppenderMask(appenderMask);
        entry.clear();
        entry.setPattern(pattern);
        return entry;
    }

    @Override
    public final GFLogger[] lookupLoggers(String name) {
        GFLogger gfLogger;
        ArrayList<GFLogger> list = new ArrayList<GFLogger>();
        for (GFLogger logger : this.loggers) {
            String category = logger.getCategory();
            if (category != null && !name.startsWith(category)) continue;
            list.add(logger);
        }
        Collections.sort(list, new Comparator<GFLogger>(){

            @Override
            public int compare(GFLogger o1, GFLogger o2) {
                String c1 = o1.getCategory();
                String c2 = o2.getCategory();
                return c2 == null ? -1 : (c1 == null ? 1 : c2.length() - c1.length());
            }
        });
        int idx = 0;
        Iterator it = list.iterator();
        while (it.hasNext() && (gfLogger = (GFLogger)it.next()).hasAdditivity()) {
            ++idx;
        }
        if (list.isEmpty()) {
            return GFLogger.EMPTY;
        }
        List subList = list.subList(0, idx + 1);
        GFLogger[] array = subList.toArray(new GFLogger[subList.size()]);
        return array;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public void stop() {
        this.logEntryThreadLocal.remove();
    }
}

