/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.gflogger.AbstractBufferLocalLogEntry;
import org.gflogger.GFLogEntry;
import org.gflogger.LoggerService;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.formatter.BufferFormatter;

public final class ByteBufferLocalLogEntry
extends AbstractBufferLocalLogEntry {
    public ByteBufferLocalLogEntry(int maxMessageSize, ObjectFormatterFactory formatterFactory, LoggerService loggerService) {
        this(Thread.currentThread(), maxMessageSize, formatterFactory, loggerService);
    }

    public ByteBufferLocalLogEntry(Thread owner, int maxMessageSize, ObjectFormatterFactory formatterFactory, LoggerService loggerService) {
        this(owner, BufferFormatter.allocate(maxMessageSize), formatterFactory, loggerService);
    }

    public ByteBufferLocalLogEntry(Thread owner, ByteBuffer byteBuffer, ObjectFormatterFactory formatterFactory, LoggerService loggerService) {
        super(owner, formatterFactory, loggerService, byteBuffer);
    }

    public ByteBufferLocalLogEntry(Thread owner, ByteBuffer byteBuffer, ObjectFormatterFactory formatterFactory, LoggerService loggerService, String logErrorsMsg) {
        super(owner, formatterFactory, loggerService, logErrorsMsg, byteBuffer);
    }

    @Override
    public void clear() {
        this.byteBuffer.clear();
    }

    @Override
    public <T extends Buffer> void copyTo(T buffer) {
        buffer.clear();
        ((ByteBuffer)buffer).put(this.byteBuffer);
    }

    @Override
    protected void moveAndAppendSilent(String message) {
        int length = message.length();
        int remaining = this.byteBuffer.remaining();
        if (remaining < length) {
            this.byteBuffer.position(this.byteBuffer.position() - (length - remaining));
        }
        try {
            BufferFormatter.append(this.byteBuffer, (CharSequence)message);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    @Override
    public ByteBufferLocalLogEntry append(char c) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.byteBuffer, c);
        }
        catch (Throwable e) {
            this.error("append(char c)", e);
        }
        return this;
    }

    @Override
    public ByteBufferLocalLogEntry append(CharSequence csq) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.byteBuffer, csq);
        }
        catch (Throwable e) {
            this.error("append(CharSequence csq)", e);
        }
        return this;
    }

    @Override
    public ByteBufferLocalLogEntry append(CharSequence csq, int start, int end) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.byteBuffer, csq, start, end);
        }
        catch (Throwable e) {
            this.error("append(CharSequence csq, int start, int end)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(boolean b) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.byteBuffer, b);
        }
        catch (Throwable e) {
            this.error("append(boolean b)", e);
        }
        return this;
    }

    @Override
    public ByteBufferLocalLogEntry append(int i) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.byteBuffer, i);
        }
        catch (Throwable e) {
            this.error("append(int i)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(long i) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.byteBuffer, i);
        }
        catch (Throwable e) {
            this.error("append(long i)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(double i, int precision) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.byteBuffer, i, precision);
        }
        catch (Throwable e) {
            this.error("append(double i, int precision)", e);
        }
        return this;
    }

    @Override
    protected void commit0() {
        this.byteBuffer.flip();
    }

    @Override
    public String stringValue() {
        int pos = this.byteBuffer.position();
        int limit = this.byteBuffer.limit();
        this.byteBuffer.flip();
        byte[] bs = new byte[pos];
        this.byteBuffer.get(bs);
        this.byteBuffer.position(pos);
        this.byteBuffer.limit(limit);
        return new String(bs);
    }

    public String toString() {
        return "[local of " + this.threadName + " " + (Object)((Object)this.logLevel) + " pos:" + this.byteBuffer.position() + " limit:" + this.byteBuffer.limit() + " capacity:" + this.byteBuffer.capacity() + "]";
    }
}

