/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.gflogger.AbstractLocalLogEntry;
import org.gflogger.GFLogEntry;
import org.gflogger.LoggerService;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.formatter.Bytes;

public final class ByteLocalLogEntry
extends AbstractLocalLogEntry {
    private final Bytes bytes;

    public ByteLocalLogEntry(int maxMessageSize, ObjectFormatterFactory formatterFactory, LoggerService loggerService) {
        this(Thread.currentThread(), maxMessageSize, formatterFactory, loggerService);
    }

    public ByteLocalLogEntry(Thread owner, int maxMessageSize, ObjectFormatterFactory formatterFactory, LoggerService loggerService) {
        this(owner, maxMessageSize, formatterFactory, loggerService, null);
    }

    public ByteLocalLogEntry(Thread owner, int maxMessageSize, ObjectFormatterFactory formatterFactory, LoggerService loggerService, String logErrorsMsg) {
        super(owner, formatterFactory, loggerService, logErrorsMsg);
        this.bytes = new Bytes(maxMessageSize);
    }

    @Override
    public <T extends Buffer> void copyTo(T buffer) {
        buffer.clear();
        this.bytes.copyTo((ByteBuffer)buffer);
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    public String stringValue() {
        return this.bytes.asString();
    }

    @Override
    public GFLogEntry append(char c) {
        try {
            this.bytes.put(c);
        }
        catch (Throwable e) {
            this.error("append(char c)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(CharSequence csq) {
        try {
            this.bytes.put(csq);
        }
        catch (Throwable e) {
            this.error("append(CharSequence csq)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(CharSequence csq, int start, int end) {
        try {
            this.bytes.put(csq, start, end);
        }
        catch (Throwable e) {
            this.error("append(CharSequence csq, int start, int end)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(boolean b) {
        try {
            this.bytes.put(b);
        }
        catch (Throwable e) {
            this.error("append(boolean b)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(int i) {
        try {
            this.bytes.put(i);
        }
        catch (Throwable e) {
            this.error("append(int i)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(long i) {
        try {
            this.bytes.put(i);
        }
        catch (Throwable e) {
            this.error("append(long i)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(double i, int precision) {
        try {
            this.bytes.put(i, precision);
        }
        catch (Throwable e) {
            this.error("append(double i, int precision)", e);
        }
        return this;
    }

    @Override
    protected void moveAndAppendSilent(String message) {
        int length = message.length();
        int remaining = this.bytes.remaining();
        if (remaining < length) {
            this.bytes.position(this.bytes.position() - (length - remaining));
        }
        try {
            this.bytes.put(message);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    @Override
    protected void commit0() {
    }
}

